# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Array", "Object", "class")
aClass.addFragment(Paragraph.new("Arrays are ordered, integer-indexed collections of any object. Array indexing starts at 0, as in C or Java. A negative index is assumed relative to the end of the array---that is, an index of -1 indicates the last element of the array, -2 is the next to last element in the array, and so on.\n"))
m0002 = MethodDesc.new("[]", "class", "Array[ <i>[</i>anObject<i>]*</i> ] -> <i>anArray</i>")
m0002.addFragment(Paragraph.new("Returns a new array populated with the given objects. Equivalent to the operator form <code>Array.[](</code><em>...</em><code>)</code>.\n"))
m0002.addFragment(Verbatim.new("Array.[]( 1, 'a', /^A/ )   \#=> [1, \"a\", /^A/]\nArray[ 1, 'a', /^A/ ]      \#=> [1, \"a\", /^A/]\n[ 1, 'a', /^A/ ]           \#=> [1, \"a\", /^A/]\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("new", "class", "Array.new( <i>anInteger=0</i>, <i>anObject=nil</i> ) -> <i>anArray</i>")
m0003.addFragment(Paragraph.new("Returns a new array, optionally with a size and initial value (that is, <i>anInteger</i> references to the same <i>anObject</i>).\n"))
m0003.addFragment(Verbatim.new("Array.new                \#=> []\nArray.new(2)             \#=> [nil, nil]\nArray.new(5, \"A\")        \#=> [\"A\", \"A\", \"A\", \"A\", \"A\"]\nArray.new(2, Hash.new)   \#=> [{}, {}]\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("&", "instance", "<i>arr</i> & <i>anOtherArray</i> -> <i>anArray</i>")
m0004.addFragment(Paragraph.new("Set Intersection---Returns a new array containing elements common to the two arrays, with no duplicates.\n"))
m0004.addFragment(Verbatim.new("[ 1, 1, 3, 5 ] & [ 1, 2, 3 ]   \#=> [1, 3]\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("*", "instance", "<i>arr</i> * <i>anInteger</i> -> <i>anArray</i><br></br><i>arr</i> * <i>aString</i> -> <i>anOtherString</i>")
m0005.addFragment(Paragraph.new("Repetition---With a <code>String</code> argument, equivalent to <code><i>arr</i>.join(aString)</code>. Otherwise, returns a new array built by concatenating the <i>anInteger</i> copies of <i>arr</i>.\n"))
m0005.addFragment(Verbatim.new("[ 1, 2, 3 ] * 3   \#=> [1, 2, 3, 1, 2, 3, 1, 2, 3]\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("+", "instance", "<i>arr</i> + <i>anOtherArray</i> -> <i>anArray</i>")
m0006.addFragment(Paragraph.new("Concatenation---Returns a new array built by concatenating the two arrays together to produce a third array.\n"))
m0006.addFragment(Verbatim.new("[ 1, 2, 3 ] + [ 4, 5 ]   \#=> [1, 2, 3, 4, 5]\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("--", "instance", "<i>arr</i> - <i>anOtherArray</i> -> <i>anArray</i>")
m0007.addFragment(Paragraph.new("Set Difference---Returns a new array that is a copy of the original array, removing any items that also appear in <i>anOtherArray</i> and duplicated items.\n"))
m0007.addFragment(Verbatim.new("[ 1, 1, 2, 2, 3, 3, 3, 4, 5 ] - [ 1, 2, 4 ]   \#=> [3, 5]\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("<<", "instance", "<i>arr</i> << <i>anObject</i> -> <i>arr</i>")
m0008.addFragment(Paragraph.new("Append---Pushes the given object on to the end of this array. This expression returns the array itself, so several appends may be chained together.\n"))
m0008.addFragment(Paragraph.new("See also <code>Array\#push</code>.\n"))
m0008.addFragment(Verbatim.new("[ 1, 2 ] << \"c\" << \"d\" << [ 3, 4 ]   \#=> [1, 2, \"c\", \"d\", [3, 4]]\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("<=>", "instance", "<i>arr</i> <=> <i>anOtherArray</i> -> -1, 0, +1")
m0009.addFragment(Paragraph.new("Comparison---Returns an integer -1, 0, or +1 if this array is less than, equal to, or greater than <i>anOtherArray</i>. Each object in each array is compared (using <code><=></code>). If any value isn't equal, then that inequality is the return value. If all the values found are equal, then the return is based on a comparison of the array lengths. Thus, two arrays are ``equal'' according to <code>Array\#<=></code> if and only if they have the same length and the value of each element is equal to the value of the corresponding element in the other array.\n"))
m0009.addFragment(Verbatim.new("[ \"a\", \"a\", \"c\" ]    <=> [ \"a\", \"b\", \"c\" ]   \#=> -1\n[ 1, 2, 3, 4, 5, 6 ] <=> [ 1, 2 ]            \#=> 1\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("==", "instance", "<i>arr</i> == <i>anOtherArray</i> -> <code>true</code> or <code>false</code>")
m0010.addFragment(Paragraph.new("Equality---Two arrays are equal if they contain the same number of elements and if each element is equal to (according to <code>Object\#==</code>) the corresponding element in the other array.\n"))
m0010.addFragment(Verbatim.new("[ \"a\", \"c\" ]    == [ \"a\", \"c\", 7 ]     \#=> false\n[ \"a\", \"c\", 7 ] == [ \"a\", \"c\", 7 ]     \#=> true\n[ \"a\", \"c\", 7 ] == [ \"a\", \"d\", \"f\" ]   \#=> false\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("===", "instance", "<i>arr</i> === <i>anOtherArray</i> -> <code>true</code> or <code>false</code>")
m0011.addFragment(Paragraph.new("Case Equality---Equality as evaluated by <code>case</code> expressions. For arrays, this is the same as <code>Array\#==</code>.\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("[]", "instance", "<i>arr</i>[<i>anInteger</i>] -> <i>anObject</i> or <code>nil</code><br></br><i>arr</i>[<i>start</i>, <i>length</i>] -> <i>aSubArray</i> or <code>nil</code><br></br><i>arr</i>[<i>aRange</i>] -> <i>aSubArray</i> or <code>nil</code> <p></p>")
m0012.addFragment(Paragraph.new("Element Reference---Returns the element at index <i>anInteger</i>, or returns a subarray starting at index <i>start</i> and continuing for <i>length</i> elements, or returns a subarray specified by <i>aRange</i>. Negative indices count backward from the end of the array (-1 is the last element). Returns <code>nil</code> if any indices are out of range.\n"))
m0012.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\", \"e\" ]\na[2] +  a[0] + a[1]   \#=> \"cab\"\na[6]                  \#=> nil\na[1, 2]               \#=> [\"b\", \"c\"]\na[1..3]               \#=> [\"b\", \"c\", \"d\"]\na[4..7]               \#=> [\"e\"]\na[6..10]              \#=> nil\na[-3, 3]              \#=> [\"c\", \"d\", \"e\"]\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("[]=", "instance", "<i>arr</i>[<i>anInteger</i>] = <i>anObject</i> -> <i>anObject</i> <br></br><i>arr</i>[<i>start</i>, <i>length</i>] = <i>aSubArray</i> -> <i>aSubArray</i> <br></br><i>arr</i>[<i>aRange</i>] = <i>aSubArray</i> -> <i>aSubArray</i>")
m0013.addFragment(Paragraph.new("Element Assignment---Sets the element at index <i>anInteger</i>, or replaces a subarray starting at index <i>start</i> and continuing for <i>length</i> elements, or replaces a subarray specified by <i>aRange</i>. If <i>anInteger</i> is greater than the current capacity of the array, the array grows automatically. A negative <i>anInteger</i> will count backward from the end of the array. Inserts elements if <i>length</i> is zero. If <i>subArray</i> is <code>nil</code>, deletes elements from <i>arr</i>. An <code>IndexError</code> is raised if a negative index points past the beginning of the array. See also <code>Array\#push</code>, <code>Array\#unshift</code>.\n"))
m0013.addFragment(Verbatim.new("a = Array.new                    \#=> []\na[4] = \"4\";                  a   \#=> [nil, nil, nil, nil, \"4\"]\na[0, 3] = [ 'a', 'b', 'c' ]; a   \#=> [\"a\", \"b\", \"c\", nil, \"4\"]\na[1..2] = [ 1, 2 ];          a   \#=> [\"a\", 1, 2, nil, \"4\"]\na[0, 2] = \"?\";               a   \#=> [\"?\", 2, nil, \"4\"]\na[0..2] = \"A\";               a   \#=> [\"A\", \"4\"]\na[-1]   = \"Z\";               a   \#=> [\"A\", \"Z\"]\na[1..-1] = nil;              a   \#=> [\"A\"]\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("|", "instance", "<i>arr</i> | <i>anOtherArray</i> -> <i>anArray</i>")
m0014.addFragment(Paragraph.new("Set Union---Returns a new array by joining this array with <i>anOtherArray</i>, removing duplicates.\n"))
m0014.addFragment(Verbatim.new("[ \"a\", \"b\", \"c\" ] | [ \"c\", \"d\", \"a\" ]   \#=> [\"a\", \"b\", \"c\", \"d\"]\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("assoc", "instance", "<i>arr</i>.assoc( <i>anObject</i> ) -> <i>anArray</i> or <code>nil</code>")
m0015.addFragment(Paragraph.new("Searches through an array whose elements are also arrays comparing <i>anObject</i> with the first element of each contained array using <i>anObject</i><code>.==</code> . Returns the first contained array that matches (that is, the first <em>assoc</em>iated array), or <code>nil</code> if no match is found. See also <code>Array\#rassoc</code>.\n"))
m0015.addFragment(Verbatim.new("s1 = [ \"colors\", \"red\", \"blue\", \"green\" ]\ns2 = [ \"letters\", \"a\", \"b\", \"c\" ]\ns3 = \"foo\"\na  = [ s1, s2, s3 ]\na.assoc(\"letters\")   \#=> [\"letters\", \"a\", \"b\", \"c\"]\na.assoc(\"foo\")       \#=> nil\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("at", "instance", "<i>arr</i>.at( <i>anInteger</i> ) -> <i>anObject</i> or <code>nil</code>")
m0016.addFragment(Paragraph.new("Returns the element at index <i>anInteger</i>. A negative index counts from the end of <i>arr</i>. Returns <code>nil</code> if the index is out of range. See also <code>Array\#[]</code>. (<code>Array\#at</code> is slightly faster than <code>Array\#[]</code>, as it does not accept ranges and so on.)\n"))
m0016.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\", \"e\" ]\na.at(0)    \#=> \"a\"\na.at(-1)   \#=> \"e\"\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("clear", "instance", "<i>arr</i>.clear -> <i>arr</i>")
m0017.addFragment(Paragraph.new("Removes all elements from <i>arr</i>.\n"))
m0017.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\", \"e\" ]\na.clear   \#=> []\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("collect", "instance", "<i>arr</i>.collect {| obj | block } <p></p> -> <i>anArray</i>")
m0018.addFragment(Paragraph.new("Returns a new array by invoking <i>block</i> once for every element, passing each element as a parameter to <i>block</i>. The result of <i>block</i> is used as the given element in the new array. See also <code>Array\#collect!</code>.\n"))
m0018.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\" ]\na.collect {|x| x + \"!\" }   \#=> [\"a!\", \"b!\", \"c!\", \"d!\"]\na                          \#=> [\"a\", \"b\", \"c\", \"d\"]\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("collect!", "instance", "<i>arr</i>.collect! {| obj | block } <p></p> -> <i>arr</i>")
m0019.addFragment(Paragraph.new("Invokes <i>block</i> once for each element of <i>arr</i>, replacing the element with the value returned by <i>block</i>. See also <code>Array\#collect</code>.\n"))
m0019.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\" ]\na.collect! {|x| x + \"!\" }   \#=> [\"a!\", \"b!\", \"c!\", \"d!\"]\na                           \#=> [\"a!\", \"b!\", \"c!\", \"d!\"]\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("compact", "instance", "<i>arr</i>.compact -> <i>anArray</i>")
m0020.addFragment(Paragraph.new("Returns a new array based on the <i>arr</i> with all <code>nil</code> elements removed.\n"))
m0020.addFragment(Verbatim.new("[ \"a\", nil, \"b\", nil, \"c\", nil ].compact   \#=> [\"a\", \"b\", \"c\"]\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("compact!", "instance", "<i>arr</i>.compact! -> <i>arr</i> or <code>nil</code>")
m0021.addFragment(Paragraph.new("Same as <code>Array\#compact</code>, but modifies the receiver in place. Returns <code>nil</code> if no changes were made.\n"))
m0021.addFragment(Verbatim.new("[ \"a\", nil, \"b\", nil, \"c\" ].compact!   \#=> [\"a\", \"b\", \"c\"]\n[ \"a\", \"b\", \"c\" ].compact!             \#=> nil\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("concat", "instance", "<i>arr</i>.concat( <i>anOtherArray</i> ) -> <i>arr</i>")
m0022.addFragment(Paragraph.new("Appends the elements in <i>anOtherArray</i> to <i>arr</i>.\n"))
m0022.addFragment(Verbatim.new("[ \"a\", \"b\" ].concat( [\"c\", \"d\"] )   \#=> [\"a\", \"b\", \"c\", \"d\"]\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("delete", "instance", "<i>arr</i>.delete( <i>anObject</i> ) -> <i>anObject</i> or <code>nil</code> <br></br><i>arr</i>.delete( <i>anObject</i> ) {| | block } <p></p> -> <i>anObject</i> or <code>nil</code>")
m0023.addFragment(Paragraph.new("Deletes items from the self that are equal to <i>anObject</i>. If the item is not found, returns <code>nil</code>. If the optional code block is given, returns the result of <i>block</i> if the item is not found.\n"))
m0023.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"b\", \"b\", \"c\" ]\na.delete(\"b\")                   \#=> \"b\"\na                               \#=> [\"a\", \"c\"]\na.delete(\"z\")                   \#=> nil\na.delete(\"z\") { \"not found\" }   \#=> \"not found\"\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("delete_at", "instance", "<i>arr</i>.delete_at( <i>anIndex</i> ) -> <i>anObject</i> or <code>nil</code>")
m0024.addFragment(Paragraph.new("Deletes the element at the specified index, returning that element, or <code>nil</code> if the index is out of range. See also <code>Array\#slice!</code>.\n"))
m0024.addFragment(Verbatim.new("a = %w( ant bat cat dog )\na.delete_at(2)    \#=> \"cat\"\na                 \#=> [\"ant\", \"bat\", \"dog\"]\na.delete_at(99)   \#=> nil\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("delete_if", "instance", "<i>arr</i>.delete_if {| | block } <p></p> -> <i>arr</i>")
m0025.addFragment(Paragraph.new("Deletes every element of <i>arr</i> for which <i>block</i> evaluates to <code>true</code>.\n"))
m0025.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.delete_if {|x| x >= \"b\" }   \#=> [\"a\"]\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("each", "instance", "<i>arr</i>.each {| item | block } -> <i>arr</i>")
m0026.addFragment(Paragraph.new("Calls <i>block</i> once for each element in <i>arr</i>, passing that element as a parameter.\n"))
m0026.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.each {|x| print x, \" -- \" }"))
m0026.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0026.addFragment(Verbatim.new("a -- b -- c --"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("each_index", "instance", "<i>arr</i>.each_index {| anIndex | block } -> <i>arr</i>")
m0027.addFragment(Paragraph.new("Same as <code>Array\#each</code>, but passes the index of the element instead of the element itself.\n"))
m0027.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.each_index {|x| print x, \" -- \" }"))
m0027.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0027.addFragment(Verbatim.new("0 -- 1 -- 2 --"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("empty?", "instance", "<i>arr</i>.empty? -> <code>true</code> or <code>false</code>")
m0028.addFragment(Paragraph.new("Returns <code>true</code> if <i>arr</i> array contains no elements.\n"))
m0028.addFragment(Verbatim.new("[].empty?   \#=> true\n"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("eql?", "instance", "<i>arr</i>.eql?( <i>anOtherArray</i> ) -> <code>true</code> or <code>false</code>")
m0029.addFragment(Paragraph.new("An array is equal to another array if the lengths are equal and each corresponding element is equal (according to <code>Object\#eql?</code>). See also <code>Array\#<=></code>. <code>eql?</code> is used for <code>Hash</code> comparison.\n"))
m0029.addFragment(Verbatim.new("[ \"a\", \"b\", \"c\" ].eql?([\"a\", \"b\", \"c\"])   \#=> true\n[ \"a\", \"b\", \"c\" ].eql?([\"a\", \"b\"])        \#=> false\n[ \"a\", \"b\", \"c\" ].eql?([\"b\", \"c\", \"d\"])   \#=> false\n"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("fill", "instance", "<i>arr</i>.fill( <i>anObject</i> ) -> <i>arr</i> <br></br><i>arr</i>.fill( <i>anObject</i>, <i>start</i> <i>[</i>, <i>length</i><i>]</i> ) -> <i>arr</i> <br></br><i>arr</i>.fill( <i>anObject</i>, <i>aRange</i> ) -> <i>arr</i> <p></p>")
m0030.addFragment(Paragraph.new("Sets the selected elements of <i>arr</i> (which may be the entire array) to <i>anObject</i>. A <i>start</i> of <code>nil</code> is equivalent to zero. A <i>length</i> of <code>nil</code> is equivalent to <i>arr</i>.length.\n"))
m0030.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\" ]\na.fill(\"x\")         \#=> [\"x\", \"x\", \"x\", \"x\"]\na.fill(\"z\", 2, 2)   \#=> [\"x\", \"x\", \"z\", \"z\"]\na.fill(\"y\", 0..1)   \#=> [\"y\", \"y\", \"z\", \"z\"]\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("first", "instance", "<i>arr</i>.first -> <i>anObject</i> or <code>nil</code>")
m0031.addFragment(Paragraph.new("Returns the first element of the array. If the array is empty, returns <code>nil</code>.\n"))
m0031.addFragment(Verbatim.new("a = [ \"q\", \"r\", \"s\", \"t\" ]\na.first   \#=> \"q\"\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("flatten", "instance", "<i>arr</i>.flatten -> <i>anArray</i>")
m0032.addFragment(Paragraph.new("Returns a new array that is a one-dimensional flattening of this array (recursively). That is, for every element that is an array, extract its elements into the new array.\n"))
m0032.addFragment(Verbatim.new("s = [ 1, 2, 3 ]           \#=> [1, 2, 3]\nt = [ 4, 5, 6, [7, 8] ]   \#=> [4, 5, 6, [7, 8]]\na = [ s, t, 9, 10 ]       \#=> [[1, 2, 3], [4, 5, 6, [7, 8]], 9, 10]\na.flatten                 \#=> [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]\n"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("flatten!", "instance", "<i>arr</i>.flatten! -> <i>arr</i> or <code>nil</code>")
m0033.addFragment(Paragraph.new("Same as <code>Array\#flatten</code>, but modifies the receiver in place. Returns <code>nil</code> if no modifications were made (i.e., <i>arr</i> contains no subarrays.)\n"))
m0033.addFragment(Verbatim.new("a = [ 1, 2, [3, [4, 5] ] ]\na.flatten!   \#=> [1, 2, 3, 4, 5]\na.flatten!   \#=> nil\na            \#=> [1, 2, 3, 4, 5]\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("include?", "instance", "<i>arr</i>.include?( <i>anObject</i> ) -> <code>true</code> or <code>false</code>")
m0034.addFragment(Paragraph.new("Returns <code>true</code> if the given object is present in <i>arr</i> (that is, if any object <code>==</code> <i>anObject</i>), <code>false</code> otherwise.\n"))
m0034.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.include?(\"b\")   \#=> true\na.include?(\"z\")   \#=> false\n"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("index", "instance", "<i>arr</i>.index( <i>anObject</i> ) -> <i>anInteger</i> or <code>nil</code>")
m0035.addFragment(Paragraph.new("Returns the index of the first object in <i>arr</i> such that the object <code>==</code> <i>anObject</i>. Returns <code>nil</code> if no match is found.\n"))
m0035.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.index(\"b\")   \#=> 1\na.index(\"z\")   \#=> nil\n"))
aClass.addMethod(m0035)
m0036 = MethodDesc.new("indexes", "instance", "<i>arr</i>.indexes( <i>i1, i2, ... iN</i> ) -> <i>anArray</i>")
m0036.addFragment(Paragraph.new("Returns a new array consisting of elements at the given indices. May insert <code>nil</code> for indices out of range.\n"))
m0036.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\", \"e\", \"f\", \"g\" ]\na.indexes(0, 2, 4)       \#=> [\"a\", \"c\", \"e\"]\na.indexes(0, 2, 4, 12)   \#=> [\"a\", \"c\", \"e\", nil]\n"))
aClass.addMethod(m0036)
m0037 = MethodDesc.new("indices", "instance", "<i>arr</i>.indices( <i>i1, i2, ... iN</i> ) -> <i>anArray</i>")
m0037.addFragment(Paragraph.new("Synonym for <code>Array\#indexes</code>.\n"))
aClass.addMethod(m0037)
m0038 = MethodDesc.new("join", "instance", "<i>arr</i>.join( <i>aSepString</i>=<code>$,</code> ) -> <i>aString</i>")
m0038.addFragment(Paragraph.new("Returns a string created by converting each element of the array to a string, separated by <i>aSepString</i>.\n"))
m0038.addFragment(Verbatim.new("[ \"a\", \"b\", \"c\" ].join        \#=> \"abc\"\n[ \"a\", \"b\", \"c\" ].join(\"-\")   \#=> \"a-b-c\"\n"))
aClass.addMethod(m0038)
m0039 = MethodDesc.new("last", "instance", "<i>arr</i>.last -> <i>anObject</i> or <code>nil</code>")
m0039.addFragment(Paragraph.new("Returns the last element of <i>arr</i>. If the array is empty, returns <code>nil</code>.\n"))
m0039.addFragment(Verbatim.new("[ \"w\", \"x\", \"y\", \"z\" ].last   \#=> \"z\"\n"))
aClass.addMethod(m0039)
m0040 = MethodDesc.new("length", "instance", "<i>arr</i>.length -> <i>anInteger</i>")
m0040.addFragment(Paragraph.new("Returns the number of elements in <i>arr</i>. May be zero.\n"))
m0040.addFragment(Verbatim.new("[ 1, 2, 3, 4, 5 ].length   \#=> 5\n"))
aClass.addMethod(m0040)
m0041 = MethodDesc.new("map!", "instance", "<i>arr</i>.map! {| obj | block } <p></p> -> <i>arr</i>")
m0041.addFragment(Paragraph.new("Synonym for <code>Array\#collect!</code>.\n"))
aClass.addMethod(m0041)
m0042 = MethodDesc.new("nitems", "instance", "<i>arr</i>.nitems -> <i>anInteger</i>")
m0042.addFragment(Paragraph.new("Returns the number of non-<code>nil</code> elements in <i>arr</i>. May be zero.\n"))
m0042.addFragment(Verbatim.new("[ 1, nil, 3, nil, 5 ].nitems   \#=> 3\n"))
aClass.addMethod(m0042)
m0043 = MethodDesc.new("pack", "instance", "<i>arr</i>.pack ( <i>aTemplateString</i> ) -> <i>aBinaryString</i>")
m0043.addFragment(Paragraph.new("Packs the contents of <i>arr</i> into a binary sequence according to the directives in <i>aTemplateString</i> (see Table 22.1 on page 289). Directives ``A,'' ``a,'' and ``Z'' may be followed by a count, which gives the width of the resulting field. The remaining directives also may take a count, indicating the number of array elements to convert. If the count is an asterisk (``<code>*</code>''), all remaining array elements will be converted. Any of the directives ``<code>sSiIlL</code>'' may be followed by an underscore (``<code>_</code>'') to use the underlying platform's native size for the specified type; otherwise, they use a platform-independent size. Spaces are ignored in the template string. See also <code>String\#unpack</code> on page 383.\n"))
m0043.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\nn = [ 65, 66, 67 ]\na.pack(\"A3A3A3\")   \#=> \"a  b  c  \"\na.pack(\"a3a3a3\")   \#=> \"a\\000\\000b\\000\\000c\\000\\000\"\nn.pack(\"ccc\")      \#=> \"ABC\"\n"))
aClass.addMethod(m0043)
m0044 = MethodDesc.new("pop", "instance", "<i>arr</i>.pop -> <i>anObject</i> or <code>nil</code>")
m0044.addFragment(Paragraph.new("Removes the last element from <i>arr</i> and returns it, or <code>nil</code> if the array is empty (as with a stack).\n"))
m0044.addFragment(Verbatim.new("a = [ \"a\", \"m\", \"z\" ]\na.pop   \#=> \"z\"\na       \#=> [\"a\", \"m\"]\n"))
aClass.addMethod(m0044)
m0045 = MethodDesc.new("push", "instance", "<i>arr</i>.push( <i>[</i><i>anObject</i><i>]+></i> ) -> <i>arr</i>")
m0045.addFragment(Paragraph.new("Appends the given argument(s) to the end of <i>arr</i> (as with a stack).\n"))
m0045.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.push(\"d\", \"e\", \"f\")   \#=> [\"a\", \"b\", \"c\", \"d\", \"e\", \"f\"]\n"))
aClass.addMethod(m0045)
m0046 = MethodDesc.new("rassoc", "instance", "<i>arr</i>.rassoc( <em>key</em> ) -> <i>anArray</i> or <code>nil</code>")
m0046.addFragment(Paragraph.new("Searches through the array whose elements are also arrays. Compares <em>key</em> with the second element of each contained array using <code>==</code>. Returns the first contained array that matches. See also <code>assoc</code>.\n"))
m0046.addFragment(Verbatim.new("a = [ [ 1, \"one\"], [2, \"two\"], [3, \"three\"], [\"ii\", \"two\"] ]\na.rassoc(\"two\")    \#=> [2, \"two\"]\na.rassoc(\"four\")   \#=> nil\n"))
aClass.addMethod(m0046)
m0047 = MethodDesc.new("reject!", "instance", "<i>arr</i>.reject! {| | block } <p></p> -> <i>arr</i> or <code>nil</code>")
m0047.addFragment(Paragraph.new("Equivalent to <code>Array\#delete_if</code>, but returns <code>nil</code> if no changes were made.\n"))
aClass.addMethod(m0047)
m0048 = MethodDesc.new("replace", "instance", "<i>arr</i>.replace( <i>anOtherArray</i> ) -> <i>arr</i>")
m0048.addFragment(Paragraph.new("Replaces the contents of <i>arr</i> with the contents of <i>anOtherArray</i>, truncating or expanding if necessary.\n"))
m0048.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\", \"e\" ]\na.replace( [ \"x\", \"y\", \"z\" ] )   \#=> [\"x\", \"y\", \"z\"]\na                                \#=> [\"x\", \"y\", \"z\"]\n"))
aClass.addMethod(m0048)
m0049 = MethodDesc.new("reverse", "instance", "<i>arr</i>.reverse -> <i>anArray</i>")
m0049.addFragment(Paragraph.new("Returns a new array using <i>arr</i>'s elements in reverse order.\n"))
m0049.addFragment(Verbatim.new("[ \"a\", \"b\", \"c\" ].reverse   \#=> [\"c\", \"b\", \"a\"]\n[ 1 ].reverse               \#=> [1]\n"))
aClass.addMethod(m0049)
m0050 = MethodDesc.new("reverse!", "instance", "<i>arr</i>.reverse! -> <i>arr</i> or <code>nil</code>")
m0050.addFragment(Paragraph.new("Same as <code>reverse</code>, but returns <code>nil</code> if <i>arr</i> is unchanged (<i>arr</i><code>.length</code> is zero or one).\n"))
m0050.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.reverse!       \#=> [\"c\", \"b\", \"a\"]\na                \#=> [\"c\", \"b\", \"a\"]\n[ 1 ].reverse!   \#=> nil\n"))
aClass.addMethod(m0050)
m0051 = MethodDesc.new("reverse_each", "instance", "<i>arr</i>.reverse_each {| | block } <p></p>")
m0051.addFragment(Paragraph.new("Same as <code>Array\#each</code>, but traverses <i>arr</i> in reverse order.\n"))
m0051.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.reverse_each {|x| print x, \" \" }"))
m0051.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0051.addFragment(Verbatim.new("c b a"))
aClass.addMethod(m0051)
m0052 = MethodDesc.new("rindex", "instance", "<i>arr</i>.rindex( <i>anObject</i> ) -> <i>anInteger</i> or <code>nil</code>")
m0052.addFragment(Paragraph.new("Returns the index of the last object in <i>arr</i> such that the object <code>==</code> <i>anObject</i>. Returns <code>nil</code> if no match is found.\n"))
m0052.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"b\", \"b\", \"c\" ]\na.rindex(\"b\")   \#=> 3\na.rindex(\"z\")   \#=> nil\n"))
aClass.addMethod(m0052)
m0053 = MethodDesc.new("shift", "instance", "<i>arr</i>.shift -> <i>anObject</i> or <code>nil</code>")
m0053.addFragment(Paragraph.new("Returns the first element of <i>arr</i> and removes it (shifting all other elements down by one). Returns <code>nil</code> if the array is empty.\n"))
m0053.addFragment(Verbatim.new("args = [ \"-m\", \"-q\", \"filename\" ]\nargs.shift   \#=> \"-m\"\nargs         \#=> [\"-q\", \"filename\"]\n"))
aClass.addMethod(m0053)
m0054 = MethodDesc.new("size", "instance", "<i>arr</i>.size -> <i>anInteger</i>")
m0054.addFragment(Paragraph.new("Synonym for <code>Array\#length</code>.\n"))
aClass.addMethod(m0054)
m0055 = MethodDesc.new("slice", "instance", "<i>arr</i>.slice( <i>anInteger</i> ) -> <i>anObject</i><br></br><i>arr</i>.slice( <i>start</i>, <i>length</i> ) -> <i>aSubArray</i><br></br><i>arr</i>.slice( <i>aRange</i> ) -> <i>aSubArray</i> <p></p>")
m0055.addFragment(Paragraph.new("Synonym for <code>Array\#[ ]</code>.\n"))
m0055.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\", \"d\", \"e\" ]\na.slice(2) + a.slice(0) + a.slice(1)   \#=> \"cab\"\na.slice(6)                             \#=> nil\na.slice(1, 2)                          \#=> [\"b\", \"c\"]\na.slice(1..3)                          \#=> [\"b\", \"c\", \"d\"]\na.slice(4..7)                          \#=> [\"e\"]\na.slice(6..10)                         \#=> nil\na.slice(-3, 3)                         \#=> [\"c\", \"d\", \"e\"]\n"))
aClass.addMethod(m0055)
m0056 = MethodDesc.new("slice!", "instance", "<i>arr</i>.slice!( <i>anInteger</i> ) -> <i>anObject</i> or <code>nil</code><br></br><i>arr</i>.slice!( <i>start</i>, <i>length</i> ) -> <i>aSubArray</i> or <code>nil</code><br></br><i>arr</i>.slice!( <i>aRange</i> ) -> <i>aSubArray</i> or <code>nil</code> <p></p>")
m0056.addFragment(Paragraph.new("Deletes the element(s) given by an index (optionally with a length) or by a range. Returns the deleted object, subarray, or <code>nil</code> if the index is out of range. Equivalent to:\n"))
m0056.addFragment(Verbatim.new("def slice!(*args)\n  result = self[*args]\n  self[*args] = nil\n  result\nend"))
m0056.addFragment(Verbatim.new("a = [ \"a\", \"b\", \"c\" ]\na.slice!(1)     \#=> \"b\"\na               \#=> [\"a\", \"c\"]\na.slice!(-1)    \#=> \"c\"\na               \#=> [\"a\"]\na.slice!(100)   \#=> nil\na               \#=> [\"a\"]\n"))
aClass.addMethod(m0056)
m0057 = MethodDesc.new("sort", "instance", "<i>arr</i>.sort -> <i>anArray</i> <br></br><i>arr</i>.sort {| a,b | block } <p></p> -> <i>anArray</i> <p></p>")
m0057.addFragment(Paragraph.new("Returns a new array created by sorting <i>arr</i>. Comparisons for the sort will be done using the <code><=></code> operator or using an optional code block. The block implements a comparison between <i>a</i> and <i>b</i>, returning -1, 0, or +1.\n"))
m0057.addFragment(Verbatim.new("a = [ \"d\", \"a\", \"e\", \"c\", \"b\" ]\na.sort                    \#=> [\"a\", \"b\", \"c\", \"d\", \"e\"]\na.sort {|x,y| y <=> x }   \#=> [\"e\", \"d\", \"c\", \"b\", \"a\"]\n"))
aClass.addMethod(m0057)
m0058 = MethodDesc.new("sort!", "instance", "<i>arr</i>.sort! -> <i>arr</i> <br></br><i>arr</i>.sort! {| a,b | block } <p></p> -> <i>arr</i> <p></p>")
m0058.addFragment(Paragraph.new("Same as <code>Array\#sort</code>, but modifies the receiver in place. <i>arr</i> is effectively frozen while a sort is in progress.\n"))
m0058.addFragment(Verbatim.new("a = [ \"d\", \"a\", \"e\", \"c\", \"b\" ]\na.sort!   \#=> [\"a\", \"b\", \"c\", \"d\", \"e\"]\na         \#=> [\"a\", \"b\", \"c\", \"d\", \"e\"]\n"))
aClass.addMethod(m0058)
m0059 = MethodDesc.new("to_a", "instance", "<i>arr</i>.to_a -> <i>arr</i>")
m0059.addFragment(Paragraph.new("Returns <i>arr</i>.\n"))
aClass.addMethod(m0059)
m0060 = MethodDesc.new("to_ary", "instance", "<i>arr</i>.to_ary -> <i>arr</i>")
m0060.addFragment(Paragraph.new("Synonym for <code>Array\#to_a</code>.\n"))
aClass.addMethod(m0060)
m0061 = MethodDesc.new("to_s", "instance", "<i>arr</i>.to_s -> <i>aString</i>")
m0061.addFragment(Paragraph.new("Returns <i>arr</i><code>.join</code>.\n"))
m0061.addFragment(Verbatim.new("[ \"a\", \"e\", \"i\", \"o\" ].to_s   \#=> \"aeio\"\n"))
aClass.addMethod(m0061)
m0062 = MethodDesc.new("uniq", "instance", "<i>arr</i>.uniq -> <i>anArray</i>")
m0062.addFragment(Paragraph.new("Returns a new array by removing duplicate values in <i>arr</i>.\n"))
m0062.addFragment(Verbatim.new("a = [ \"a\", \"a\", \"b\", \"b\", \"c\" ]\na.uniq   \#=> [\"a\", \"b\", \"c\"]\n"))
aClass.addMethod(m0062)
m0063 = MethodDesc.new("uniq!", "instance", "<i>arr</i>.uniq! -> <i>arr</i> or <code>nil</code>")
m0063.addFragment(Paragraph.new("Same as <code>Array\#uniq</code>, but modifies the receiver in place. Returns <code>nil</code> if no changes are made (that is, no duplicates are found).\n"))
m0063.addFragment(Verbatim.new("a = [ \"a\", \"a\", \"b\", \"b\", \"c\" ]\na.uniq!   \#=> [\"a\", \"b\", \"c\"]\nb = [ \"a\", \"b\", \"c\" ]\nb.uniq!   \#=> nil\n"))
aClass.addMethod(m0063)
m0064 = MethodDesc.new("unshift", "instance", "<i>arr</i>.unshift( <i>anObject</i> ) -> <i>arr</i>")
m0064.addFragment(Paragraph.new("Prepends <i>anObject</i> to the front of <i>arr</i>, and shifts all other elements up one.\n"))
m0064.addFragment(Verbatim.new("a = [ \"b\", \"c\", \"d\" ]\na.unshift(\"a\")   \#=> [\"a\", \"b\", \"c\", \"d\"]\n"))
aClass.addMethod(m0064)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
