#ifndef race_menu_options
#define race_menu_options

class OptionsSound;
class OptionsGraphics;
class OptionsCars;
class OptionsGame;
class OptionsKeys;
class OptionsThemes;

class OptionsMenu : public CL_Component
{
 public:
	OptionsMenu(CL_Component *parent, CL_StyleManager *style);
	~OptionsMenu();
	
// Callbacks:
private:
	void on_paint();
	void on_back();

	void on_graphics();
	void on_sound();
	void on_game();
	void on_network();
	void on_theme();
	void on_keys();
	void on_cars();

// Functions:
private:
	void hide_all_menus();

private:
	// SubMenus:
	OptionsSound    *opt_sound;
	OptionsGraphics *opt_graphics;
	OptionsCars     *opt_cars;
	OptionsGame     *opt_game;
	OptionsKeys     *opt_keys;
	OptionsThemes   *opt_themes;

	// slots
	CL_SlotContainer slots;
/*
	CL_Slot slot_paint;
	CL_Slot slot_back;
	CL_Slot slot_graphics;
	CL_Slot slot_sound;
	CL_Slot slot_game;
	CL_Slot slot_network;
	CL_Slot slot_theme;
	CL_Slot slot_keys;
	CL_Slot slot_cars;
*/
	// gui widgets
	CL_Button btn_back;
	CL_Button btn_graphics;
	CL_Button btn_sound;
	CL_Button btn_game;
	CL_Button btn_network;
	CL_Button btn_theme;
	CL_Button btn_keys;
	CL_Button btn_cars;
};

#endif
