#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "options_sound.h"
#include "options_graphics.h"
#include "options_cars.h"
#include "options_keys.h"
#include "options_themes.h"
#include "options_game.h"

#include "../menu_gfx.h"
#include "../../debug.h"
#include "options_menu.h"


OptionsMenu::OptionsMenu(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(0, 0, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		
		btn_back(     CL_Rect( 10, 100, 10 + 120, 100 + 30), "Back",     this, style),

		btn_game(     CL_Rect( 10, 160, 10 + 120, 160 + 30), "Game",     this, style),
		btn_theme(    CL_Rect( 10, 190, 10 + 120, 190 + 30), "Theme",    this, style),
		btn_graphics( CL_Rect( 10, 220, 10 + 120, 220 + 30), "Graphics", this, style),
		btn_sound(    CL_Rect( 10, 250, 10 + 120, 250 + 30), "Sound",    this, style),
		btn_keys(     CL_Rect( 10, 280, 10 + 120, 280 + 30), "Keys",     this, style),
		btn_network(  CL_Rect( 10, 310, 10 + 120, 310 + 30), "Network",  this, style),
		btn_cars(     CL_Rect( 10, 340, 10 + 120, 340 + 30), "Cars",     this, style)
{
	RaceDebug::print( "OptionMenu: constructor", 9 );

	opt_sound    = new OptionsSound( this, style );
	opt_graphics = new OptionsGraphics( this, style );
	opt_game     = new OptionsGame( this, style );
	opt_cars     = new OptionsCars( this, style );
	opt_keys     = new OptionsKeys( this, style );
	opt_themes   = new OptionsThemes( this, style );

	slots.connect( sig_paint(), this, &OptionsMenu::on_paint );
	slots.connect( btn_back.sig_clicked(), this, &OptionsMenu::on_back );
	slots.connect( btn_game.sig_clicked(), this, &OptionsMenu::on_game );
	slots.connect( btn_theme.sig_clicked(), this, &OptionsMenu::on_theme );
	slots.connect( btn_graphics.sig_clicked(), this, &OptionsMenu::on_graphics );
	slots.connect( btn_sound.sig_clicked(), this, &OptionsMenu::on_sound );
	slots.connect( btn_keys.sig_clicked(), this, &OptionsMenu::on_keys );
	slots.connect( btn_network.sig_clicked(), this, &OptionsMenu::on_network);
	slots.connect( btn_cars.sig_clicked(), this, &OptionsMenu::on_cars );

	RaceDebug::print( "OptionMenu: constructor -- done", 9 );
}


OptionsMenu::~OptionsMenu()
{
	delete opt_sound;
	delete opt_graphics;
	delete opt_game;
	delete opt_cars;
	delete opt_keys;
	delete opt_themes;
}


// .=======================< >=======================.
// | on_* functions                                  |
// '=======================< >======================='

// on_back
void OptionsMenu::on_back()
{
	std::cout << "on_back" << std::endl;

	CL_Component::quit();
}

// on_game
void OptionsMenu::on_game()
{
	hide_all_menus();
	opt_game->show(true);
}

// on_theme
void OptionsMenu::on_theme()
{
	hide_all_menus();
	opt_themes->show(true);
}

// on_graphics
void OptionsMenu::on_graphics()
{
	hide_all_menus();
	opt_graphics->show(true);
}


// on_sound
void OptionsMenu::on_sound()
{
	hide_all_menus();
	opt_sound->show(true);
}

// on_keys
void OptionsMenu::on_keys()
{
	hide_all_menus();
	opt_keys->show(true);
}

// on_network
void OptionsMenu::on_network()
{
	hide_all_menus();
}

// on_cars
void OptionsMenu::on_cars()
{
	hide_all_menus();
	opt_cars->show(true);
}



// .=======================< >=======================.
// | main on_paint                                   |
// '=======================< >======================='


void OptionsMenu::on_paint()
{
	RaceDebug::print( "OptionMenu: on_paint", 8 );

	MenuGfx::bg->put_screen(0,0);
	MenuGfx::title_options->put_screen(145,120);

	RaceDebug::print( "OptionMenu: on_paint -- done", 8 );
}




void OptionsMenu::hide_all_menus()
{
	RaceDebug::print( "OptionMenu: hide_all_menus", 8 );

	opt_game->show(false);
	opt_cars->show(false);
	opt_graphics->show(false);
	opt_keys->show(false);
	opt_sound->show(false);
	opt_themes->show(false);

	RaceDebug::print( "OptionMenu: hide_all_menus -- done", 8 );
}

