/*
 * Race is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999-2002,  Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "keyboard.h"
#include "game_config.h"
#include "game_data.h"

void Keyboard::init_keys()
{
	if( GameData::p1_vert_axis != NULL )
	{
		delete GameData::p1_vert_axis; GameData::p1_vert_axis = NULL;
		delete GameData::p1_hori_axis; GameData::p1_hori_axis = NULL;
	}
	
	GameData::p1_vert_axis = new CL_InputAxis_Group;
	GameData::p1_hori_axis = new CL_InputAxis_Group;
	
	GameData::p1_vert_axis->add( new CL_InputButtonToAxis_Digital
		 	(CL_Input::keyboards[0]->get_button(Config::one_player_key_gas.id),
			(CL_Input::keyboards[0]->get_button(Config::one_player_key_brakes.id) )));
	
	GameData::p1_hori_axis->add( new CL_InputButtonToAxis_Digital
			(CL_Input::keyboards[0]->get_button(Config::one_player_key_right.id),
			CL_Input::keyboards[0]->get_button(Config::one_player_key_left.id) ));
}
