#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include "pixel.h"
#include "emit_config.h"

#include "particle.h"

int Particle::num_particles = 0;

Particle::Particle( float x, float y, float angle, Pixel pixel )
{
	this->x = x;
	this->y = y;
	this->angle = angle + (((rand()%90)-45)/30); // looks better with some randomnes 
	this->pixel = pixel;

	birth_time = CL_System::get_time();
	destroy = false;

	speed_down = -0.0001f;
}

Particle::~Particle()
{
	
}

void Particle::update( float time_elapsed )
{
	move( time_elapsed );
	draw();
	kill();
}

void Particle::move( float time_elapsed )
{
	// normal movement...

	float dir_x = time_elapsed * EmitConfig::particle_speed * cos( angle /*+( rand()%10 - 5 )*/ );
	float dir_y = time_elapsed * EmitConfig::particle_speed * sin( angle /*+( rand()%10 - 5 )*/ );

	x += dir_x;
	y += dir_y;

	// gravity effect...

	speed_down += ( CL_System::get_time() - birth_time) / 50000;
	dir_y = time_elapsed * speed_down * sin( M_PI / 2 );

	y += dir_y;
}

void Particle::draw()
{
	int scr_x = int( x + 0.5 );
	int scr_y = int( y + 0.5 );

	CL_Display::fill_rect( scr_x, scr_y, scr_x+2, scr_y+2,
//						  pixel.r, pixel.g, pixel.b, 1.0f );
						  1.0f, 1.0f, 0.0f, 1.0f );
}

void Particle::kill()
{
	if( CL_System::get_time() - birth_time > EmitConfig::particle_life_time )
	{
		destroy = true;
	}

	if( x < 0 || x > 640 || y < 0 || y > 480 )
  		destroy = true;
}	

