/***************************************************************************
                          qscannersetupdlg.cpp  -  description
                             -------------------
    begin                : Thu Jun 29 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#include "qsanestatusmessage.h"
#include "qscannersetupdlg.h"
#include "qscanner.h"
#include "qxmlconfig.h"

#include <qapplication.h>
#include <qarray.h>
#include <qbuttongroup.h>
#include <qcursor.h>
#include <qcstring.h>
#include <qdatastream.h>
#include <qdir.h>
#include <qfile.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qheader.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qmessagebox.h>
#include <qnamespace.h>
#include <qpushbutton.h>
#include <qprinter.h>
#include <qradiobutton.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtextstream.h>
#include <qtranslator.h>
#include <qtoolbutton.h>
#include <qvaluelist.h>
#include <qwhatsthis.h>
#include <qwidget.h>

#ifndef DEV_SETTINGS_VERSION
#define DEV_SETTINGS_VERSION "1"
#endif

QScannerSetupDlg::QScannerSetupDlg(QScanner* scanner,QWidget *parent,const char* name)
                 : QDialog(parent,name,true)
{
  mIsSetup = false;
  mpScanner = scanner;
  mpScanDialog = 0;
  mQueryType = -1;
  setCaption(QString(tr("QuiteInsane-Plugin")));
  mpLastItem = 0L;
  initDialog();
}
QScannerSetupDlg::~QScannerSetupDlg()
{
}
/**  */
void QScannerSetupDlg::initDialog()
{
  QButtonGroup* DeviceButtonGroup = new QButtonGroup(this);
  DeviceButtonGroup->hide();
  DeviceButtonGroup->setRadioButtonExclusive(true);

  QGridLayout *qgl=new	QGridLayout (this,6,2);
  qgl->setSpacing(4);
  qgl->setMargin(6);

  QHBox* hb1 = new QHBox(this);
  QLabel* label1 = new QLabel(tr("Choose the device"),hb1);
  hb1->setStretchFactor(label1,1);
  QToolButton* tb = QWhatsThis::whatsThisButton(hb1);
	tb->setAutoRaise(false);	
  qgl->addMultiCellWidget(hb1,0,0,0,1);
  if(!xmlConfig->boolValue("ENABLE_WHATSTHIS_BUTTON",true))
    tb->hide();
  mpListView = new QListView(this);
  mpListView->addColumn(tr("Device name"));
  mpListView->addColumn(tr("Vendor"));
  mpListView->addColumn(tr("Model"));
  mpListView->addColumn(tr("Type"));
  mpListView->setAllColumnsShowFocus(true);
  mpListView->setRootIsDecorated(true);
	qgl->addMultiCellWidget(mpListView,1,1,0,1);

  QGroupBox* gb2 = new QGroupBox(1,Qt::Horizontal,
                                 tr("List mode"),this);

  mpAllDevicesRadio = new QRadioButton(tr("List &all devices"),gb2);

  mpLocalDevicesRadio = new QRadioButton(tr("List &local devices only"),gb2);

	qgl->addMultiCellWidget(gb2,2,4,0,0);

  DeviceButtonGroup->insert(mpAllDevicesRadio,0);
  DeviceButtonGroup->insert(mpLocalDevicesRadio,1);
  bool b = xmlConfig->boolValue("LOCAL_DEVICES_ONLY",true);
  if(b)
    DeviceButtonGroup->setButton(1);
  else
    DeviceButtonGroup->setButton(0);

  mpQuitButton=new QPushButton(tr("&Quit"),this);
  mpSelectButton=new QPushButton(tr("Select &device"),this);
  mpSelectButton->setDefault(TRUE);

	qgl->addWidget(mpSelectButton,2,1);
	qgl->addWidget(mpQuitButton,4,1);
  qgl->setRowStretch ( 1,1 );
  qgl->setColStretch ( 0,1 );
	qgl->activate();

  mpSelectButton->setEnabled(false);
	connect(mpQuitButton,SIGNAL(clicked()),SLOT(reject()));
	connect(mpSelectButton,SIGNAL(clicked()),SLOT(slotDeviceSelected()));
	connect(mpListView,SIGNAL(doubleClicked(QListViewItem*)),
          this,SLOT(slotDeviceSelected(QListViewItem*)));
	connect(mpListView,SIGNAL(clicked(QListViewItem*)),
          this,SLOT(slotListViewClicked(QListViewItem*)));
	connect(DeviceButtonGroup,SIGNAL(clicked(int)),
          this,SLOT(slotDeviceGroup(int)));
  mIsSetup=true;
}
/**  */
void QScannerSetupDlg::clearList()
{
	mpListView->clear();
}
/**  */
QString QScannerSetupDlg::device()
{
  QString qs;
  mOptionMap.clear();
  QListViewItem* li;
  li = mpListView->currentItem();
  if(li)
  {
    xmlConfig->setStringValue("LAST_DEVICE",li->text(0));
    xmlConfig->setStringValue("LAST_DEVICE_VENDOR",li->text(1));
    xmlConfig->setStringValue("LAST_DEVICE_MODEL",li->text(2));
    xmlConfig->setStringValue("LAST_DEVICE_TYPE",li->text(3));
    return li->text(0);
  }
  return QString::null;
}
/**  */
void QScannerSetupDlg::slotListViewClicked(QListViewItem*)
{
  if(mpListView->currentItem() != 0L)
    mpSelectButton->setEnabled(TRUE);
}
/**  */
void QScannerSetupDlg::slotDeviceSelected()
{
  if(mpAllDevicesRadio->isChecked())
      xmlConfig->setBoolValue("LOCAL_DEVICES_ONLY",false);
  else
      xmlConfig->setBoolValue("LOCAL_DEVICES_ONLY",true);
  xmlConfig->setStringValue("LAST_DEVICE",device());
  qApp->processEvents();
  accept();
}
/**  */
void QScannerSetupDlg::slotDeviceSelected(QListViewItem*)
{
	slotDeviceSelected();
}
/**  */
void QScannerSetupDlg::showEvent(QShowEvent * e)
{
  mpListView->setColumnWidth(0,mpListView->columnWidth(0)+5);
  mpListView->setColumnWidth(1,mpListView->columnWidth(1)+5);
  mpListView->setColumnWidth(2,mpListView->columnWidth(2)+5);
  mpListView->setColumnWidth(3,mpListView->columnWidth(3)+5);

  QRect qr1 = mpListView->frameRect();
  QRect qr2 = mpListView->contentsRect();

  if(mpListView->contentsWidth()< qApp->desktop()->width()*2/3)
    mpListView->setMinimumWidth(mpListView->contentsWidth()+
                                 qr1.width()-qr2.width()+20);
  if(mpListView->contentsHeight()< qApp->desktop()->height()*2/3)
    mpListView->setMinimumHeight(mpListView->contentsHeight()+
                                  qr1.height()-qr2.height()+
                                  mpListView->header()->height());
  if(mpLastItem)
  {
    mpListView->setSelected(mpLastItem,true);
    mpListView->ensureItemVisible(mpLastItem);
    mpSelectButton->setEnabled(true);
  }
  QDialog::showEvent(e);
}
/**  */
void QScannerSetupDlg::createContents(bool local_only)
{
  int i;
  QString qs;
  setCursor(Qt::waitCursor);
  clearList();
  mQueryType = 0;
  mpScanner->getDeviceList(local_only);
  if(mpScanner->deviceCount()<=0)
  {
    QMessageBox::critical(0,QObject::tr("No local devices found"),
    QObject::tr("No local devices were found."),
     QObject::tr("&OK"));
    setCursor(Qt::arrowCursor);
    return;
  }
  if(mpScanner->deviceCount()>0)
  {
    for(i=0;i<mpScanner->deviceCount();i++)
    {
	   	qs=mpScanner->name(i);
      new QListViewItem(mpListView,
                        QString(mpScanner->name(i)),
                        QString(mpScanner->vendor(i)),
                        QString(mpScanner->model(i)),
                        QString(mpScanner->type(i)));
    }
  }
  setCursor(Qt::arrowCursor);
}
/**  */
void QScannerSetupDlg::slotDeviceGroup(int id)
{
//  //save value to config file
xmlConfig->setIntValue("DEVICE_QUERY",id);
  if(id == 0)
    slotAllDevices();
  else
    slotLocalDevices();
}
/**  */
void QScannerSetupDlg::slotAllDevices()
{
  mpSelectButton->setEnabled(false);
  if(!mpScanner || (mpListView->childCount() <= 0))
  {
    initScanner();
  }
  createContents(false);
}
/**  */
void QScannerSetupDlg::slotLocalDevices()
{
  mpSelectButton->setEnabled(false);
  if(!mpScanner || (mpListView->childCount() <= 0))
  {
    initScanner();
  }
  createContents(true);
}
/**  */
void QScannerSetupDlg::show()
{
  resize(sizeHint());
  qApp->processEvents();
  //ensure that the dialog is centered on desktop
  int x,y;
  x = (qApp->desktop()->width()-sizeHint().width())/2;
  y = (qApp->desktop()->height()-sizeHint().height())/2;
  move(x,y);
  if(mpListView->childCount() <= 0)
    createContents(xmlConfig->boolValue("LOCAL_DEVICES_ONLY",true));
  QDialog::show();
}
/**  */
void QScannerSetupDlg::createWhatsThisHelp()
{
  QWhatsThis::add(mpAllDevicesRadio,tr("If you activate this radio button, "
              "all devices will be queried on the next program start."));
  QWhatsThis::add(mpLocalDevicesRadio,tr("If you activate this radio button, "
              "all local devices will be queried on the next program "
              "start."));
  QWhatsThis::add(mpQuitButton,tr("Click this button to quit QuiteInsane."));
  QWhatsThis::add(mpSelectButton,tr("Click this button to select the "
              "currently highlighted device."));
  QWhatsThis::add(mpListView,tr("Doubleclick on a listview item to "
              "select a device. You can also highlight an item with "
              "a single mouse click and click the Select device button."));
}
/**  */
QMap <QString,QString> QScannerSetupDlg::optionMap()
{
  return mOptionMap;
}
/**  */
void QScannerSetupDlg::slotProcessEvents()
{
  qApp->processEvents();
}

void QScannerSetupDlg::initScanner()
{
  if(!mpScanner)
    return;
	if(mpScanner->isInit())
    return;
  if(!mpScanner->initScanner())
  {
    QMessageBox::critical(0,tr("Initialisation failed"),
               tr("<center>A call to sane_init() failed.</center><br>"
	                "<center>Press Quit to quit QuiteInsane.</center>"),
               tr("&Quit"));
    slotQuit();
  }
}

/**  */
void QScannerSetupDlg::slotQuit()
{
  if(mpScanner)
    mpScanner->exitScanner();
  reject();
}
/** No descriptions */
void QScannerSetupDlg::loadBackendTranslation(QString name)
{
return;
  QString filename;
  QString dev_name;
  QString opts_name;
  QString sane_path;
  QString locale;

  QString inst_dir;
#ifdef INSTALL_DIR
  inst_dir = INSTALL_DIR;
#else
  inst_dir = "/usr/local/";
#endif
  bool opts_loaded;
  bool dev_loaded;
  opts_loaded = false;
  dev_loaded = false;
  if(!xmlConfig->boolValue("ENABLE_BACKEND_TRANSLATIONS",true))
    return;

  //locale e.g. de,ru,fr ...
  locale = QTextCodec::locale();
  locale = locale.left(2);

  dev_name = name;
  if(dev_name.contains(":"))
    dev_name = dev_name.left(dev_name.findRev(":"));
  if(dev_name.contains(":"))
    dev_name = dev_name.right(dev_name.length() - dev_name.findRev(":") - 1);
  dev_name += "."+locale+".qm";
  opts_name = "saneopts."+locale+".qm";

  //did the user set a path ?
  bool b = xmlConfig->boolValue("USE_BACKEND_TRANSLATIONS_PATH",false);
  if(b)
  {
    sane_path = xmlConfig->stringValue("BACKEND_TRANSLATIONS_PATH",QString::null);
    if(sane_path.right(1) != "/")
      sane_path += "/";
    if(!sane_path.isEmpty() && b)
    {
      filename = sane_path + dev_name;
      if(QFile::exists(filename))
      {
         QTranslator* translator = new QTranslator(0);
         if(translator)
         {
           translator->load(filename);
           qApp->installTranslator(translator);
           dev_loaded = true;
         }
      }
      filename = sane_path + opts_name;
      if(QFile::exists(filename))
      {
         QTranslator* translator = new QTranslator(0);
         if(translator)
         {
           translator->load(filename);
           qApp->installTranslator(translator);
           opts_loaded = true;
         }
      }
    }
  }
  //If a translation file isn't loaded, try again under default path
  sane_path = inst_dir;
  if(sane_path.right(1) != "/")
    sane_path += "/";
  sane_path += "share/quiteinsane/locale/";
  filename = sane_path + dev_name;
  if(QFile::exists(filename))
  {
     QTranslator* translator = new QTranslator(0);
     if(translator)
     {
       translator->load(filename);
       qApp->installTranslator(translator);
       dev_loaded = true;
     }
  }
  filename = sane_path + opts_name;
  if(QFile::exists(filename))
  {
     QTranslator* translator = new QTranslator(0);
     if(translator)
     {
       translator->load(filename);
       qApp->installTranslator(translator);
       opts_loaded = true;
     }
  }
}
