/***************************************************************************
                          qscandialog.cpp  -  description
                             -------------------
    begin                : Thu Jun 22 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "pics/setup.xpm"
#include "pics/quiteinsane_logo.xpm"
#include "pics/fileopen.xpm"
#include "previewwidget.h"
#include "qbooloption.h"
#include "qbuttonoption.h"
#include "qcombooption.h"
#include "qdevicesettings.h"
#include "qlistviewitemext.h"
#include "qextensionwidget.h"
#include "qimageioext.h"
#include "qoptionscrollview.h"
#include "qreadonlyoption.h"
#include "qscannersetupdlg.h"
#include "qscrollbaroption.h"
#include "qscandialog.h"
#include "qsanestatusmessage.h"
#include "qstringoption.h"
#include "qswitchoffmessage.h"
#include "qxmlconfig.h"
#include "qwordarrayoption.h"
#include "qwordcombooption.h"
#include "sanefixedoption.h"
#include "saneintoption.h"
#include "sanewidgetholder.h"
#include "scanarea.h"

#include <qapplication.h>
#include <qarray.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <qdatastream.h>
#include <qdialog.h>
#include <qdir.h>
#include <qfile.h>
#include <qframe.h>
#include <qfileinfo.h>
#include <qfontmetrics.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlist.h>
#include <qmessagebox.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdict.h>
#include <qobjectlist.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qprogressdialog.h>
#include <qpushbutton.h>
#include <qregexp.h>
#include <qrect.h>
#include <qscrollbar.h>
#include <qscrollview.h>
#include <qsizepolicy.h>
#include <qstringlist.h>
#include <qtabwidget.h>
#include <qtextstream.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qvbox.h>
#include <qvector.h>
#include <qwhatsthis.h>
#include <qwidgetlist.h>
#include <qwidgetstack.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>

extern "C"
{
#include <sane/sane.h>
}

extern int copy_to_gimp(QImage& image);

QScanDialog::QScanDialog(QScanner* s,QWidget *parent, const char *name)
            :QDialog(parent,name,false)
{
  mMultiSelectionMode = false;
  mpScanner = s;
  mShowCnt = 0;
  mOptionSubArray.resize(0);
  mpOptionScrollView = 0L;
  mpOptionTabWidget = 0L;
  mpOptionListWidget = 0L;
  mpOptionWidgetStack = 0L;
  mpPreviewWidget = 0L;
  mLayout = QIN::ScrollLayout;
  mImageList.setAutoDelete(true);
  mImageList.clear();
  mStatus = initDialog();
}

QScanDialog::~QScanDialog()
{
}

/**  */
void QScanDialog::slotScan()
{
  QArray <double> da;
  QImage image;
  QImage image2;
  QFile f;

  enableGUI(false,false);
  if(!scanImage(false,true,this))
  {
    enableGUI(true,false);
    return;
  }

  if(mMultiSelectionMode)
  {
    da = mpPreviewWidget->selectedRects();
    if(da.size() < 4)
    {
      enableGUI(true,false);
      return;
    }
    f.setName(xmlConfig->absConfDirPath()+".scantemp.pnm");
    if(!f.open(IO_ReadOnly))
    {
      enableGUI(true,false);
      return;
    }
    QImageIO iio((QIODevice*)&f,0);
    qis_read_pbm_image(&iio);
    image = iio.image();
    f.close();
    if(image.isNull())
    {
      enableGUI(true,false);
      return;
    }
    for(unsigned int ui=0;ui<da.size()-3;ui += 4)
    {
      int x,y,w,h;
      x = int(double(image.width())*da[ui]);
      y = int(double(image.height())*da[ui+1]);
      w = int(double(image.width())*da[ui+2]) - x;
      h = int(double(image.height())*da[ui+3]) - y;
      image2 = image.copy(x,y,w,h);
      image2.setDotsPerMeterX(image.dotsPerMeterX());
      image2.setDotsPerMeterY(image.dotsPerMeterY());
      copy_to_gimp(image2);
    }
  }
  else
  {
    f.setName(xmlConfig->absConfDirPath()+".scantemp.pnm");
    if(!f.open(IO_ReadOnly))
    {
      enableGUI(true,false);
      return;
    }
    QImageIO iio((QIODevice*)&f,0);
    qis_read_pbm_image(&iio);
    image2 = iio.image();
    f.close();
    if(image2.isNull())
    {
      enableGUI(true,false);
      return;
    }
    copy_to_gimp(image2);
  }
  enableGUI(true,false);
}
/**  */

QIN::Status QScanDialog::initDialog()
{
  if(!mpScanner) return QIN::InitFailed;
	int i;
  int groupcount;
	groupcount =0;
	bool valid_desc;
	valid_desc = false;

	QString qs;

  mDeviceName = mpScanner->name();

//////////
//main layout
	mpMainLayout=new QGridLayout(this,4,3);
  mpMainLayout->setMargin(3);
  mpMainLayout->setSpacing(5);
  mpMainLayout->setColStretch(0,1);
//create mpWhatsThisButton in a HBox
  mpInfoHBox = new QHBox(this);
  mpInfoHBox->setSpacing(2);
  mpLabelImageInfo = new QLabel("",mpInfoHBox);
  mpLabelImageInfo->setFrameStyle(QFrame::StyledPanel|QFrame::Sunken);
  mpInfoHBox->setStretchFactor(mpLabelImageInfo,1);

  mpWhatsThisButton = QWhatsThis::whatsThisButton(mpInfoHBox);
	mpWhatsThisButton->setAutoRaise(FALSE);	
  mpMainLayout->addWidget(mpInfoHBox,0,0);
  if(!xmlConfig->boolValue("ENABLE_WHATSTHIS_BUTTON",true))
    mpWhatsThisButton->hide();

	int c;
  int c2;
  c  = 0;
  c2 = 0;
  createOptionWidget();
  createPreviewWidget();

//first button row
  mpButtonHBox1 = new QHBox(this);
  mpButtonHBox1->setSpacing(2);

	mpAboutButton = new QPushButton(tr("&About..."),mpButtonHBox1);
  connect(mpAboutButton,SIGNAL(clicked()),this,SLOT(slotAbout()));
	mpOptionsButton = new QPushButton(tr("&Options..."),mpButtonHBox1);
  connect(mpOptionsButton,SIGNAL(clicked()),this,SLOT(slotShowOptionsWidget()));
	mpPreviewButton = new QPushButton(tr("&Hide preview..."),mpButtonHBox1);

//second button row
  mpButtonHBox2 = new QHBox(this);
  mpButtonHBox2->setSpacing(2);

  mpDeviceButton = new QPushButton(tr("&Device settings..."),mpButtonHBox2);
  connect(mpDeviceButton,SIGNAL(clicked()),this,SLOT(slotDeviceSettings()));
	mpScanButton = new QPushButton(tr("&Scan"),mpButtonHBox2);
  connect(mpScanButton,SIGNAL(clicked()),SLOT(slotScan()));
	mpQuitButton = new QPushButton(tr("&Close"),mpButtonHBox2);
  connect(mpQuitButton,SIGNAL(clicked()),this,SLOT(reject()));
	mpMainLayout->addWidget(mpButtonHBox1,2,0);
	mpMainLayout->addWidget(mpButtonHBox2,3,0);
	mpMainLayout->activate();
  slotReloadOptions();//check which options are active

  if(mpPreviewWidget)
	{
    //horizontal separator
    mpSeparator = new QVBox(this);
    QFrame* frame = new QFrame(mpSeparator);
    frame->setFrameStyle(QFrame::VLine|QFrame::Sunken);
    frame->setLineWidth(2);
    mpSeparator->setMargin(5);
	  mpMainLayout->addMultiCellWidget(mpSeparator,0,3,1,1);
    mpMainLayout->addMultiCellWidget(mpPreviewWidget,0,3,2,2);
    connect(mpPreviewWidget,SIGNAL(signalPreviewRequest(double,double,double,double,int)),
            this,SLOT(slotPreview(double,double,double,double,int)));
    connect(mpPreviewButton,SIGNAL(clicked()),this,SLOT(slotShowPreviewWidget()));
    if(mpTlxOption)
    {
      connect(this,SIGNAL(signalMetricSystem(QIN::MetricSystem)),
              mpPreviewWidget,SLOT(slotChangeMetricSystem(QIN::MetricSystem)));
      slotUserSize(0);
    }
  }
  else
  {
		mpPreviewButton->setEnabled(false);
  }
	createWhatsThisHelp();
  connect(mpScanner,SIGNAL(signalReloadOptions()),this,SLOT(slotReloadOptions()));
  slotImageInfo();
  connect(mpScanner,SIGNAL(signalReloadParams()),this,SLOT(slotImageInfo()));
  connect(mpScanner,SIGNAL(signalInfoInexact(int)),this,SLOT(slotInfoInexact(int)));
  setCaption("QuiteInsane GIMP Plugin - "+mDeviceName);
  i = xmlConfig->intValue("LAYOUT",0);
  switch(i)
  {
    case 0:
//      slotChangeLayout(QIN::ScrollLayout);
      break;
    case 1:
      changeLayout(QIN::TabLayout);
      break;
    case 2:
      changeLayout(QIN::ListLayout);
      break;
    default:
      changeLayout(QIN::ScrollLayout);
      break;
  }
//set metric system
  mMetricSystem = (QIN::MetricSystem) xmlConfig->intValue("METRIC_SYSTEM",0);
  emit signalMetricSystem(mMetricSystem);
  return QIN::ReadyToShow;
}
/**  */
void QScanDialog::slotUserSize(int)
{
	mpPreviewWidget->setRectSize(mpTlxOption->getPercentValue(),
                               mpTlyOption->getPercentValue(),
                               mpBrxOption->getPercentValue(),
                               mpBryOption->getPercentValue());
}
/**  */
void QScanDialog::slotPreview(double tlx,double tly,double brx,double bry,int res)
{
  qDebug("going to scan Preview");
  enableGUI(false,true);
  if(scanPreviewImage(tlx,tly,brx,bry,res))
  {
    mpPreviewWidget->loadPreviewPixmap(xmlConfig->absConfDirPath()+".previewtemp.pnm");
    if(xmlConfig->boolValue("AUTOSELECT_ENABLE",false) &&
       !(xmlConfig->boolValue("AUTOSELECT_TEMPLATE_DISABLE",true) &&
         (mMultiSelectionMode == true)))
    {
      mpPreviewWidget->slotAutoSelection();
    }
  }
  enableGUI(true,true);
  qDebug("Preview scanned");
}
/**  */
void QScanDialog::createOptionWidget()
{
	QGroupBox* qgb;
  int groupcount;
  int c;
	groupcount =0;

  mOptionWidgets.resize(0);
  mGroupBoxArray.resize(0);
//check whether there are options at all
	if(mpScanner->optionCount()>1)
	{
    mpOptionScrollView = new QOptionScrollView(this);
    mpOptionScrollView->setFrameStyle(QScrollView::StyledPanel | QScrollView::Raised);
    mpOptionScrollView->setHScrollBarMode(QScrollView::AlwaysOff);
    //check whether there are grouped options
    //and put them in a groupbox
    groupcount = mpScanner->getGroupCount();
		if(groupcount > 0)
	  {
		  for(c=1;c<=groupcount;c++)
		  {
		 	//create a group box with a QVBoxLayout
        qgb = createOptionGroupBox(mpScanner->getGroupTitle(c),
                                   mpScanner->firstGroupItem(c),
                                   mpScanner->lastGroupItem(c));
        mpOptionScrollView->addWidget(qgb);
		 }	
	  }
    //check whether there are options that don't belong
		//to a group and put them in a group box
    if(mpScanner->nonGroupOptionCount()>0)
		{
      qgb = createOptionGroupBox(tr("Other options"),1,mpScanner->nonGroupOptionCount());
      mpOptionScrollView->addWidget(qgb);
    }
    mpMainLayout->addWidget(mpOptionScrollView,1,0);
  }
}
/**Check all options visible in the dialog. Inactive options
   are disabled.  */
void QScanDialog::slotReloadOptions()
{
  SANE_Int i_val;
  SANE_Fixed f_val;
  SANE_Bool b_val;
  QArray<SANE_Word> array;
  QString stringval;
  QScrollBarOption* qsbo;
  QComboOption* qco;
  QBoolOption* qboolo;
  QButtonOption* qbutt;
  QStringOption* qso;
  QWordArrayOption* qwao;
  QWordComboOption* qwco;
  QReadOnlyOption* qroo;
  SaneIntOption* sint;
  SaneFixedOption* sfix;
  QWidget* visible_tab;
  visible_tab = 0;
  QWidget* stack_widget;
  visible_tab = 0;
  stack_widget = 0;
  int cnt;
//the hide/show counter, to ensure that we only use my "somewhat"
//flickering recalculation of this widget if necessary
  int hscnt = 0;
  int sane_opt_num = -1;
  bool scan_area_changed = false;
  int update_option = -1;

  for(cnt=0;cnt<int(mOptionWidgets.size());cnt++)
  {
    //check whether the widget must be re-created
    //this can happen, e.g. if the backend decides to
    //change the option value constraint from
    //SANE_CONSTRAINT_RANGE to SANE_CONSTRAINT_WORD_LIST
    //or vice versa
    checkOptionValidity(cnt);
    qsbo = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QScrollBarOption"))
      qsbo=(QScrollBarOption*)(mOptionWidgets[cnt]->saneOption());			
    if(qsbo)
    {
    //scrollbar option found
      sane_opt_num = qsbo->saneOptionNumber();
      if(mpScanner->isOptionActive(qsbo->saneOptionNumber()))
      {
        if(qsbo->getSaneType() == SANE_TYPE_INT)
        {
          int range_min;
          int range_max;
          range_min = int(mpScanner->getRangeMin(sane_opt_num));
          range_max = int(mpScanner->getRangeMax(sane_opt_num));
          if(range_max != qsbo->maxValue())
          {
            if((mOptionWidgets[cnt]->saneOption() == (void*)mpTlxOption) ||
               (mOptionWidgets[cnt]->saneOption() == (void*)mpTlyOption) ||
               (mOptionWidgets[cnt]->saneOption() == (void*)mpBrxOption) ||
               (mOptionWidgets[cnt]->saneOption() == (void*)mpBryOption))
            {
              scan_area_changed = true;
              update_option = cnt;
            }
          }
          i_val = (SANE_Int)mpScanner->saneWordValue(sane_opt_num);
          qsbo->setRange(range_min,range_max,
                         mpScanner->getRangeQuant(sane_opt_num));
          qsbo->setValue(i_val);
        }
        if(qsbo->getSaneType() == SANE_TYPE_FIXED)
        {
          int range_min;
          int range_max;
          range_min = int(mpScanner->getRangeMin(sane_opt_num));
          range_max = int(mpScanner->getRangeMax(sane_opt_num));
          if(range_max != qsbo->maxValue())
          {
            if((mOptionWidgets[cnt]->saneOption() == (void*)mpTlxOption) ||
               (mOptionWidgets[cnt]->saneOption() == (void*)mpTlyOption) ||
               (mOptionWidgets[cnt]->saneOption() == (void*)mpBrxOption) ||
               (mOptionWidgets[cnt]->saneOption() == (void*)mpBryOption))
            {
              scan_area_changed = true;
              update_option = cnt;
            }
          }
          qsbo->setRange(range_min,range_max,
                         mpScanner->getRangeQuant(sane_opt_num));
          f_val = (SANE_Fixed)mpScanner->saneWordValue(qsbo->saneOptionNumber());
          qsbo->setValue(f_val);
        }
        if(qsbo->isHidden())
        {
          qsbo->show();
          qsbo->layout()->activate();
          hscnt += 1;
        }
      }
      else
      {
        if(!qsbo->isHidden())
        {
          qsbo->hide();
          hscnt += 1;
        }
      }
    }
    qco = 0L;
    sint = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("SaneIntOption"))
      sint=(SaneIntOption*)(mOptionWidgets[cnt]->saneOption());			
    if(sint)
    {
    //int option found
      sane_opt_num = sint->saneOptionNumber();
      if(mpScanner->isOptionActive(sint->saneOptionNumber()))
      {
        i_val = (SANE_Int)mpScanner->saneWordValue(sane_opt_num);
        sint->setValue(i_val);
        if(sint->isHidden())
        {
          sint->show();
          sint->layout()->activate();
          hscnt += 1;
        }
      }
      else
      {
        if(!sint->isHidden())
        {
          sint->hide();
          hscnt += 1;
        }
      }
    }
    sint = 0L;
    sfix = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("SaneFixedOption"))
      sfix=(SaneFixedOption*)(mOptionWidgets[cnt]->saneOption());			
    if(sfix)
    {
    //fixed option found
      sane_opt_num = sfix->saneOptionNumber();
      if(mpScanner->isOptionActive(sfix->saneOptionNumber()))
      {
        i_val = (SANE_Int)mpScanner->saneWordValue(sane_opt_num);
        sfix->setValue(i_val);
        if(sfix->isHidden())
        {
          sfix->show();
          sfix->layout()->activate();
          hscnt += 1;
        }
      }
      else
      {
        if(!sfix->isHidden())
        {
          sfix->hide();
          hscnt += 1;
        }
      }
    }
    sfix = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QComboOption"))
   	  qco=(QComboOption*)(mOptionWidgets[cnt]->saneOption());			
		if(qco)
		{
			//always string type
			if(mpScanner->isOptionActive(qco->saneOptionNumber()))
      {
        QStringList slist = mpScanner->getStringList(qco->saneOptionNumber());
        qco->setStringList(slist);
   		  qco->setCurrentValue((const char*)mpScanner->saneStringValue(qco->saneOptionNumber()));
        if(qco->isHidden())
        {
          qco->show();
          qco->layout()->activate();
          hscnt += 1;
        }
      }
			else
      {
        if(!qco->isHidden())
        {
          qco->hide();
          hscnt += 1;
        }
      }
		}
    qwco = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QWordComboOption"))
      qwco=(QWordComboOption*)(mOptionWidgets[cnt]->saneOption());			
    if(qwco)
	  {
			if(mpScanner->isOptionActive(qwco->saneOptionNumber()))
      {
   		  qwco->setValue((SANE_Word)mpScanner->saneWordValue(qwco->saneOptionNumber()));
        if(qwco->isHidden())
        {
          qwco->show();
          qwco->layout()->activate();
          hscnt += 1;
        }
      }
			else
      {
        if(!qwco->isHidden())
        {
          qwco->hide();
          hscnt += 1;
        }
      }
    }
    qboolo = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QBoolOption"))
   	  qboolo=(QBoolOption*)(mOptionWidgets[cnt]->saneOption());			
		if(qboolo)
		{
			if(mpScanner->isOptionActive(qboolo->saneOptionNumber()))
      {
				b_val = (SANE_Bool)mpScanner->saneWordValue(qboolo->saneOptionNumber());
        qboolo->setState(b_val);
        if(qboolo->isHidden())
        {
          qboolo->show();
          qboolo->layout()->activate();
          hscnt += 1;
        }
      }
			else
      {
        if(!qboolo->isHidden())
        {
          qboolo->hide();
          hscnt += 1;
        }
      }
		}
    qbutt = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QButtonOption"))
   	  qbutt=(QButtonOption*)(mOptionWidgets[cnt]->saneOption());			
  	if(qbutt)
		{
			//has no value
			if(mpScanner->isOptionActive(qbutt->saneOptionNumber()))
      {
        if(qbutt->isHidden())
        {
          qbutt->show();
          qbutt->layout()->activate();
          hscnt += 1;
        }
      }
			else
      {
        if(!qbutt->isHidden())
        {
          qbutt->hide();
          hscnt += 1;
        }
      }
		}
    //check whether it's a string option
    qso = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QStringOption"))
   	  qso=(QStringOption*)(mOptionWidgets[cnt]->saneOption());			
    QString optionstring;
	  if(qso)
	  {
			//always string type
			if(mpScanner->isOptionActive(qso->saneOptionNumber()))
      {
				stringval = mpScanner->saneStringValue(qso->saneOptionNumber());
        qso->setText(stringval);
        if(qso->isHidden())
        {
          qso->show();
          qso->layout()->activate();
          hscnt += 1;
        }
      }
			else
      {
        if(!qso->isHidden())
        {
          qso->hide();
          hscnt += 1;
        }
      }
    }
    qwao = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QWordArrayOption"))
   	  qwao=(QWordArrayOption*)(mOptionWidgets[cnt]->saneOption());			
		if(qwao)
		{
			if(mpScanner->isOptionActive(qwao->saneOptionNumber()))
      {
				array = mpScanner->saneWordArray(qwao->saneOptionNumber());
        qwao->setValue(array);
        if(qwao->isHidden())
        {
          qwao->show();
          qwao->layout()->activate();
          hscnt += 1;
        }
        //switch to curve mode free
      }
			else
      {
        if(!qwao->isHidden())
        {
          qwao->hide();
          qwao->closeCurveWidget();
          hscnt += 1;
        }
      }
		}
    qroo = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QReadOnlyOption"))
   	  qroo=(QReadOnlyOption*)(mOptionWidgets[cnt]->saneOption());			
		if(qroo)
		{
			if(mpScanner->isOptionActive(qroo->saneOptionNumber()))
      {
        qroo->setText(mpScanner->saneReadOnly(qroo->saneOptionNumber()));
        if(qroo->isHidden())
        {
          qroo->show();
          qroo->layout()->activate();
          hscnt += 1;
        }
      }
			else
      {
        if(!qroo->isHidden())
        {
          qroo->hide();
          hscnt += 1;
        }
      }
		}
  }

  //If no option was shown/hidden we must not resize the layout.
  if(hscnt == 0) return;
  if(mLayout == QIN::TabLayout)
  {
    //stupid, but works (?)
    qApp->processEvents();
    QApplication::sendPostedEvents();
    mpOptionTabWidget->hide();
    qApp->processEvents();
    QApplication::sendPostedEvents();
    mpOptionTabWidget->show();
    qApp->processEvents();
    QApplication::sendPostedEvents();
    if(mpPreviewWidget)
    {
      if(scan_area_changed)
      {
          setPreviewRange();
      }
      if(height() < minimumSizeHint().height())
        resize(width(),minimumSizeHint().height());
    }
    else
      resize(width(),minimumSizeHint().height());
  }
  else if(mLayout == QIN::ListLayout)
  {
    qApp->processEvents();
    QApplication::sendPostedEvents();
    mpOptionWidgetStack->hide();
    qApp->processEvents();
    QApplication::sendPostedEvents();
    mpOptionWidgetStack->show();
    mpOptionListWidget->layout()->activate();
    mpOptionWidgetStack->resize(mpOptionWidgetStack->width(),
                              mpOptionWidgetStack->sizeHint().height());
    qApp->processEvents();
    QApplication::sendPostedEvents();
    if(mpPreviewWidget)
    {
      if(scan_area_changed)
      {
        setPreviewRange();
      }
      if(height() < minimumSizeHint().height())
        resize(width(),minimumSizeHint().height());
    }
    else
      resize(width(),minimumSizeHint().height());
  }
  //Did status of scan area change ?
  if(mpTlxOption && mpTlyOption && mpBrxOption && mpBryOption)
  {
     if(!mpScanner->isOptionActive(mpTlxOption->saneOptionNumber()) ||
        !mpScanner->isOptionActive(mpTlxOption->saneOptionNumber()) ||
        !mpScanner->isOptionActive(mpTlxOption->saneOptionNumber()) ||
        !mpScanner->isOptionActive(mpTlxOption->saneOptionNumber()))
     {
       mpPreviewWidget->setMetrics(QIN::NoMetricSystem,SANE_UNIT_NONE);
       mpPreviewWidget->setAspectRatio(1.0);
     }
     else
     {
       mpPreviewWidget->setMetrics(QIN::Millimetre,
                           mpScanner->getUnit(mpTlxOption->saneOptionNumber()));
       setPreviewRange();
     }
  }
}
/**  */
void QScanDialog::slotOptionChanged(int num)
{
  SANE_Int   si;
  SANE_Word  sw;
  SANE_Bool  sb;
  QScrollBarOption* qsbo;
  QComboOption*     qco;
  QButtonOption*    qbo;
  QBoolOption*      qboolo;
  QStringOption*    qso;
  QWordComboOption* qwco;
  QWordArrayOption* qwao;
  SaneFixedOption*  sfix;
  SaneIntOption*    sint;
  QString combostring;
  QString optionstring;
  void*             v;
  int i;
  QArray<SANE_Word> qa;
  v = 0L;
  i = 0;
  //check whether it's a bool option
  qboolo = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QBoolOption") == true)
    qboolo=(QBoolOption*)(mOptionWidgets[num]->saneOption());			
  if(qboolo)
  {
    i = qboolo->saneOptionNumber();
    sb = qboolo->state();
    mpScanner->setOption(i,&sb);
    qDebug("QScanDialog::slotOptionChanged - QBoolOption %i - %i",i,sb);
    return;
  }
  //check whether it's a button option
  qbo = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QButtonOption") == true)
    qbo=(QButtonOption*)(mOptionWidgets[num]->saneOption());			
  if(qbo)
  {
    i = qbo->saneOptionNumber();
    mpScanner->setOption(i,0L);
    return;
  }
  v = 0L;
  qco = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QComboOption") == true)
    qco=(QComboOption*)(mOptionWidgets[num]->saneOption());			
  if(qco)
  {
    //always string type
    i = qco->saneOptionNumber();
    combostring = qco->getCurrentText();
    v = (SANE_String*)combostring.latin1();
    if(v)mpScanner->setOption(i,v);
    return;
  }
  //check whether it's a word combo option
  qwco = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QWordComboOption") == true)
    qwco=(QWordComboOption*)(mOptionWidgets[num]->saneOption());			
  if(qwco)
  {
    i = qwco->saneOptionNumber();
    si = qwco->getCurrentValue();
    mpScanner->setOption(i,&si);
    return;
  }
  //check whether it's a word array option
  qwao = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QWordArrayOption") == true)
    qwao=(QWordArrayOption*)(mOptionWidgets[num]->saneOption());			
  if(qwao)
  {
    i = qwao->saneOptionNumber();
    qa = qwao->getValue();
    mpScanner->setOption(i,qa.data());
    return;
  }
  //check whether it's a scrollbaroption
  qsbo = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QScrollBarOption") == true)
    qsbo=(QScrollBarOption*)(mOptionWidgets[num]->saneOption());			
  if(qsbo)
  {
    i = qsbo->saneOptionNumber();
    sw = (SANE_Int)qsbo->getValue();
    mpScanner->setOption(i,&sw);
    return;
  }
  //check whether it's a sanefixedoption
  sfix = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("SaneFixedOption") == true)
    sfix=(SaneFixedOption*)(mOptionWidgets[num]->saneOption());
  if(sfix)
  {
    i = sfix->saneOptionNumber();
    sw = (SANE_Fixed)sfix->value();
    mpScanner->setOption(i,&sw);
  }
  //check whether it's a sanefixedoption
  sint = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("SaneIntOption") == true)
    sint=(SaneIntOption*)(mOptionWidgets[num]->saneOption());
  if(sint)
  {
    i = sint->saneOptionNumber();
    sw = (SANE_Int)sint->value();
    mpScanner->setOption(i,&sw);
  }
  //check whether it's a string option
  qso = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QStringOption") == true)
    qso=(QStringOption*)(mOptionWidgets[num]->saneOption());
  if(qso)
  {
    v = 0L;
    //always string type
    i = qso->saneOptionNumber();
    optionstring = qso->text();
    v = (SANE_String*)optionstring.latin1();
    if(v)mpScanner->setOption(i,v);
  }
}
/**  */
void QScanDialog::setAllOptions()
{
  SANE_Int si;
  SANE_Fixed sf;
  QScrollBarOption* qsbo;
  QComboOption* qco;
  void* v;
  QString combostring;
  int i;
  v = 0L;
  i = 0;

//don't set button options
  for(i=0;i<int(mOptionWidgets.size());i++)
  {
    //check whether it's a combo option
    qco = 0L;
    if(((QObject*)(mOptionWidgets[i]->saneOption()))->isA("QComboOption") == true)
      qco=(QComboOption*)(mOptionWidgets[i]->saneOption());			
    if(qco)
    {
      v = 0L;
      combostring = qco->getCurrentText();
      v = (SANE_String*)combostring.latin1();
      if(v)mpScanner->setOption(i,v);
    }
    //check whether it's a scrollbaroption
    qsbo = 0L;
    if(((QObject*)(mOptionWidgets[i]->saneOption()))->isA("QScrollBarOption") == true)
      qsbo=(QScrollBarOption*)(mOptionWidgets[i]->saneOption());			
    if(qsbo)
    {
      switch(qsbo->getSaneType())
      {
        case SANE_TYPE_INT:
          si = (SANE_Int)qsbo->getValue();
          mpScanner->setOption(i,&si);
          break;
        case SANE_TYPE_FIXED:
          sf = (SANE_Fixed)qsbo->getValue();
          mpScanner->setOption(i,&sf);
          break;
        default:;
      }
    }
  }


//  SANE_Int   si;
//	SANE_Fixed sf;
//  QScrollBarOption* qsbo;
//	QComboOption*     qco;
//  void*             v;
//  QString combostring;
//	int i;
//  v = 0L;
//	i = 0;
//
////don't set button options
//	for(i=0;i<int(mOptionWidgets.size());i++)
//	{
//		//check whether it's a combo option
//    qco = 0L;
//    if(((QObject*)mOptionWidgets[i])->isA("QComboOption") == TRUE)
// 	    qco=(QComboOption*)mOptionWidgets[i];			
//    if(qco)
//    {
//      v = 0L;
//			combostring = qco->getCurrentText();
//	  	v = (SANE_String*)combostring.latin1();
//			if(v)mpScanner->setOption(i,v);
//		}
//    //check whether it's a scrollbaroption
//    qsbo = 0L;
//    if(((QObject*)mOptionWidgets[i])->isA("QScrollBarOption") == TRUE)
// 	    qsbo=(QScrollBarOption*)mOptionWidgets[i];			
//    if(qsbo)
//		{
//			switch(qsbo->getSaneType())
//			{
//       	case SANE_TYPE_INT:
//          si = (SANE_Int)qsbo->getValue();
//      		mpScanner->setOption(i,&si);
//          break;
//        case SANE_TYPE_FIXED:
//          sf = (SANE_Fixed)qsbo->getValue();
//       	  mpScanner->setOption(i,&sf);
//          break;
//	      default:;
//     }
//	 }
//  }
}
/**  */
void QScanDialog::slotShowOptionsWidget()
{
  QIN::Layout l;
  QIN::MetricSystem ms;
  QExtensionWidget ew(this);
  if(ew.exec())
  {
    //check whether the layout must be changed
    l = (QIN::Layout)xmlConfig->intValue("LAYOUT",0);
    if(l != mLayout) changeLayout(l);
    //check whether the metric system changed
    ms = (QIN::MetricSystem)xmlConfig->intValue("METRIC_SYSTEM",0);
    if(ms != mMetricSystem) emit signalMetricSystem(ms);
    mMetricSystem = ms;
  }
}
/**  */
void QScanDialog::slotShowPreviewWidget()
{
  if(!mpPreviewWidget->isVisible())
  {
    int w = xmlConfig->intValue("SCANDIALOG_INTEGRATED_PREVIEW_WIDTH",0);
    int h = xmlConfig->intValue("SCANDIALOG_INTEGRATED_PREVIEW_HEIGHT",0);
    if(w < width())
      w = width();
    if(h < height())
      h = height();
    resize(w,h);
    mpPreviewWidget->show();
    mpSeparator->show();
    mpPreviewButton->setText(tr("&Hide preview..."));
  }
  else
  {
    mpPreviewWidget->hide();
    mpSeparator->hide();
    qApp->processEvents();
    resize(sizeHint());
    mpPreviewButton->setText(tr("Show &preview..."));
  }
}
/**  */
void QScanDialog::createWhatsThisHelp()
{
//about button
  QWhatsThis::add(mpAboutButton,tr("Shows the about dialog, which "
															"displays more information "
															"about QuiteInsane."));
//options button
  QWhatsThis::add(mpOptionsButton,tr("Shows a dialog, which "
															"lets you choose between several "
															"options, e.g. save mode or view mode."));
//preview button
  QWhatsThis::add(mpPreviewButton,tr("Shows the preview window, which "
															  "allows you to do a preview scan and "
															  "to presicesly select the scan area."
                                "This button is only active if the "
                                "selected device allows to adjust the "
                                "scan area options."));
//scan button
  QWhatsThis::add(mpScanButton,tr("Starts scanning with the current "
															"settings."));
//quit button
  QWhatsThis::add(mpQuitButton,tr("Click this button to quit QuiteInsane."));
//device button
  QWhatsThis::add(mpDeviceButton,tr("Click this button to show the device "
                        "settings dialog. You can use it to load, save "
                        "and delete device settings."));
}
/**  */
void QScanDialog::slotAbout()
{
	QPixmap qp((const char **)quiteinsane_logo_xpm);
  QString text;
  text =
  tr("<center><b><h1>QuiteInsane GIMP Plugin V%1</h1></b></center>"
     "<center>&copy 2002-2004 Michael Herder http://quiteinsane.sf.net/contact.html</center><br>"
     "<center><b>QuiteInsane GIMP Plugin</b> is a graphical SANE-frontend</center><br>"
 	   "<center>This program is free software; you can redistribute it and/or</center>"
     "<center>modify it under the terms of the GNU General Public License version 2</center>"
     "<center>as published by the Free Software Foundation.</center><br>"
     "<center>The program is provided AS IS with NO WARRANTY OF ANY KIND,</center>"
     "<center>INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY AND</center>"
     "<center>FITNESS FOR A PARTICULAR PURPOSE.</center><br>"
    ).arg(VERSION);

  QMessageBox qmb(tr("About QuiteInsane GIMP Plugin"),text,
               QMessageBox::NoIcon,QMessageBox::Ok | QMessageBox::Default |
               QMessageBox::Escape , QMessageBox::NoButton,QMessageBox::NoButton,
               this);
  qmb.setIconPixmap(qp);
  qmb.exec();
}
/** No descriptions */
QSaneOption* QScanDialog::createSaneOptionWidget(QWidget* parent,int opt_num)
{
  QSaneOption* ret = 0;
  QScrollBarOption*  qsb = 0;
  QScrollBarOption*  qsf = 0;
  QStringOption*     qso = 0;
  QComboOption*      qcb = 0;
  QButtonOption*     qbo = 0;
  QBoolOption*       qbool = 0;
  QWordArrayOption*  qwao = 0;
  QWordComboOption*  qwco = 0;
  QReadOnlyOption*   qroo = 0;
  SaneIntOption*     sint = 0;
  SaneFixedOption*   sfix = 0;
  SANE_Int           i_val;
  SANE_Fixed         f_val;
  QString            stringval;
  int                groupcount;
  groupcount=0;
  bool        valid_desc;
  valid_desc = false;

  int c;
  int c2;
  c  = 0;
  c2 = 0;
  qDebug("create saneoption widget: %i ",opt_num);
  if((mpScanner->isOptionSettable(opt_num)))
  {
    switch(mpScanner->getOptionType(opt_num))
    {
      case SANE_TYPE_BUTTON:
        qbo = new QButtonOption(mpScanner->getOptionTitle(opt_num),parent,//qvbox,
                                (const char*)mpScanner->getOptionName(opt_num));
        qbo->setOptionDescription(mpScanner->getOptionDescription(opt_num));
        qbo->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
        qbo->setSaneValueType(mpScanner->getOptionType(opt_num));
        qbo->setSaneOptionNumber(opt_num);
        qbo->setOptionSize(mpScanner->optionSize(opt_num));
        QWhatsThis::add(qbo,qbo->optionDescription());
        connect(qbo,SIGNAL(signalOptionChanged(int)),this,
                SLOT(slotOptionChanged(int)));
        ret = (QSaneOption*)qbo;
        break;
      case SANE_TYPE_BOOL:
        //don't add preview option
        if(mpScanner->previewOption() == opt_num) break;
        qbool = new QBoolOption(mpScanner->getOptionTitle(opt_num),parent,//qvbox,
                                (const char*)mpScanner->getOptionName(opt_num));
        qbool->setOptionDescription(mpScanner->getOptionDescription(opt_num));
        qbool->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
        qbool->setSaneValueType(mpScanner->getOptionType(opt_num));
        qbool->setSaneOptionNumber(opt_num);
        qbool->setOptionSize(mpScanner->optionSize(opt_num));
        //CAP_AUTOMATIC ?
        if(mpScanner->automaticOption(opt_num))
        {
          qbool->enableAutomatic(true);
          connect(qbool,SIGNAL(signalAutomatic(int,bool)),
                  this,SLOT(slotAutoMode(int,bool)));
        }
        QWhatsThis::add(qbool,qbool->optionDescription());
        connect(qbool,SIGNAL(signalOptionChanged(int)),this,
                SLOT(slotOptionChanged(int)));
        ret = (QSaneOption*)qbool;
        break;
      case SANE_TYPE_INT:
        if(mpScanner->optionSize(opt_num) == sizeof(SANE_Word))
        {
          i_val = (SANE_Int) mpScanner->saneWordValue(opt_num);
          if(mpScanner->getConstraintType(opt_num)==SANE_CONSTRAINT_RANGE)
          {
            qsb = new QScrollBarOption(mpScanner->getOptionTitle(opt_num),parent,
                                       SANE_TYPE_INT,(const char*)mpScanner->getOptionName(opt_num));
            qsb->setSaneOptionNumber(opt_num);
            qsb->setOptionSize(mpScanner->optionSize(opt_num));
            qsb->setRange(int(mpScanner->getRangeMin(opt_num)),
                          int(mpScanner->getRangeMax(opt_num)),
                          int(mpScanner->getRangeQuant(opt_num)));
            qsb->setUnit(mpScanner->getUnit(opt_num));
            //if unit mm then connect to signalMetricSystem
            if(mpScanner->getUnit(opt_num) == SANE_UNIT_MM)
               connect(this,
                       SIGNAL(signalMetricSystem(QIN::MetricSystem)),
                       qsb,
                       SLOT(slotChangeMetricSystem(QIN::MetricSystem)));
            qsb->setValue(i_val);
            qsb->setOptionDescription(mpScanner->getOptionDescription(opt_num));
            qsb->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
            qsb->setSaneValueType(mpScanner->getOptionType(opt_num));
            QWhatsThis::add(qsb,qsb->optionDescription());
            connect(qsb,SIGNAL(signalOptionChanged(int)),this,
                    SLOT(slotOptionChanged(int)));
            ret = (QSaneOption*)qsb;
          }
          else if(mpScanner->getConstraintType(opt_num)==SANE_CONSTRAINT_NONE)
          {
            sint = new SaneIntOption(mpScanner->getOptionTitle(opt_num),parent,
                                      SANE_TYPE_INT,(const char*)mpScanner->getOptionName(opt_num));
            sint->setSaneOptionNumber(opt_num);
            sint->setOptionSize(mpScanner->optionSize(opt_num));
            sint->setUnit(mpScanner->getUnit(opt_num));
            sint->setValue(i_val);
            sint->setOptionDescription(mpScanner->getOptionDescription(opt_num));
            sint->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
            sint->setSaneValueType(mpScanner->getOptionType(opt_num));
            QWhatsThis::add(sint,sint->optionDescription());
            connect(sint,SIGNAL(signalOptionChanged(int)),this,
                    SLOT(slotOptionChanged(int)));
            ret = (QSaneOption*)sint;
          }
          else if(mpScanner->getConstraintType(opt_num)==SANE_CONSTRAINT_WORD_LIST)
          {
            qwco = new QWordComboOption(mpScanner->getOptionTitle(opt_num),parent,
                                SANE_TYPE_INT,(const char*)mpScanner->getOptionName(opt_num));
            //if unit mm then connect to option widget
            qwco->appendArray(mpScanner->saneWordList(opt_num));
            qwco->setSaneOptionNumber(opt_num);
            qwco->setOptionSize(mpScanner->optionSize(opt_num));
            //CAP_AUTOMATIC ?
            if(mpScanner->automaticOption(opt_num))
            {
              qwco->enableAutomatic(true);
              connect(qwco,SIGNAL(signalAutomatic(int,bool)),
                      this,SLOT(slotAutoMode(int,bool)));
            }
            qwco->setOptionDescription(mpScanner->getOptionDescription(opt_num));
            qwco->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
            qwco->setSaneValueType(mpScanner->getOptionType(opt_num));
            qwco->setSaneWordArray(mpScanner->saneWordList(opt_num));
            QWhatsThis::add(qwco,qwco->optionDescription());
            connect(qwco,SIGNAL(signalOptionChanged(int)),this,
                    SLOT(slotOptionChanged(int)));
            ret = (QSaneOption*)qwco;
          }
        }
        else if(mpScanner->optionSize(opt_num) > int(sizeof(SANE_Word)))//we have a vector
        {
          if(mpScanner->getConstraintType(opt_num)==SANE_CONSTRAINT_RANGE)
          {
            qwao = new QWordArrayOption(mpScanner->getOptionTitle(opt_num),parent,
                                        SANE_TYPE_INT,(const char*)mpScanner->getOptionName(opt_num));
            qwao->setSaneOptionNumber(opt_num);
            qwao->setOptionSize(mpScanner->optionSize(opt_num));
            qwao->setRange(int(mpScanner->getRangeMin(opt_num)),
                             int(mpScanner->getRangeMax(opt_num)));
            qwao->setQuant(mpScanner->getRangeQuant(opt_num));
            qwao->setValue(mpScanner->saneWordArray(opt_num));
            qwao->setOptionDescription(mpScanner->getOptionDescription(opt_num));
            qwao->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
            qwao->setSaneValueType(mpScanner->getOptionType(opt_num));
            QWhatsThis::add(qwao,qwao->optionDescription());
            connect(qwao,SIGNAL(signalOptionChanged(int)),this,
                    SLOT(slotOptionChanged(int)));
            ret = (QSaneOption*)qwao;
          }
        }
        break;
      case SANE_TYPE_FIXED:
        if(mpScanner->optionSize(opt_num) == sizeof(SANE_Word))
        {
          f_val = (SANE_Fixed)mpScanner->saneWordValue(opt_num);
          if(mpScanner->getConstraintType(opt_num) == SANE_CONSTRAINT_RANGE)
          {
            qsf = new QScrollBarOption(mpScanner->getOptionTitle(opt_num),parent,
                                       SANE_TYPE_FIXED,(const char*)mpScanner->getOptionName(opt_num));
            qsf->setSaneOptionNumber(opt_num);
            qsf->setOptionSize(mpScanner->optionSize(opt_num));
            qsf->setRange(mpScanner->getRangeMin(opt_num),
                          mpScanner->getRangeMax(opt_num),
                          mpScanner->getRangeQuant(opt_num));
            qsf->setUnit(mpScanner->getUnit(opt_num));
            //if unit mm then connect to signalMetricSystem
            if(mpScanner->getUnit(opt_num) == SANE_UNIT_MM)
            {
              connect(this,
                      SIGNAL(signalMetricSystem(QIN::MetricSystem)),
                      qsf,
                      SLOT(slotChangeMetricSystem(QIN::MetricSystem)));
            }
            qsf->setValue(f_val);
            qsf->setOptionDescription(mpScanner->getOptionDescription(opt_num));
            qsf->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
            qsf->setSaneValueType(mpScanner->getOptionType(opt_num));
            QWhatsThis::add(qsf,qsf->optionDescription());
            connect(qsf,SIGNAL(signalOptionChanged(int)),this,
                    SLOT(slotOptionChanged(int)));
            ret = (QSaneOption*)qsf;
          }
          else if(mpScanner->getConstraintType(opt_num)==SANE_CONSTRAINT_NONE)
          {
            sfix = new SaneFixedOption(mpScanner->getOptionTitle(opt_num),parent,
                                       SANE_TYPE_INT,(const char*)mpScanner->getOptionName(opt_num));
            sfix->setSaneOptionNumber(opt_num);
            sfix->setOptionSize(mpScanner->optionSize(opt_num));
            sfix->setUnit(mpScanner->getUnit(opt_num));
            sfix->setValue(f_val);
            sfix->setOptionDescription(mpScanner->getOptionDescription(opt_num));
            sfix->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
            sfix->setSaneValueType(mpScanner->getOptionType(opt_num));
            QWhatsThis::add(sfix,sfix->optionDescription());
            connect(sfix,SIGNAL(signalOptionChanged(int)),this,
                    SLOT(slotOptionChanged(int)));
            ret = (QSaneOption*)sfix;
          }
          else if(mpScanner->getConstraintType(opt_num)==SANE_CONSTRAINT_WORD_LIST)
          {
            qwco = new QWordComboOption(mpScanner->getOptionTitle(opt_num),parent,
                                        SANE_TYPE_FIXED,(const char*)mpScanner->getOptionName(opt_num));
            qwco->setSaneOptionNumber(opt_num);
            qwco->setOptionSize(mpScanner->optionSize(opt_num));
            //if unit mm then connect to option widget
            qwco->appendArray(mpScanner->saneWordList(opt_num));
            //CAP_AUTOMATIC ?
            if(mpScanner->automaticOption(opt_num))
            {
              qwco->enableAutomatic(true);
              connect(qwco,SIGNAL(signalAutomatic(int,bool)),
                      this,SLOT(slotAutoMode(int,bool)));
            }
            qwco->setOptionDescription(mpScanner->getOptionDescription(opt_num));
            qwco->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
            qwco->setSaneValueType(mpScanner->getOptionType(opt_num));
            qwco->setSaneWordArray(mpScanner->saneWordList(opt_num));
            QWhatsThis::add(qwco,qwco->optionDescription());
            connect(qwco,SIGNAL(signalOptionChanged(int)),this,
                    SLOT(slotOptionChanged(int)));
            ret = (QSaneOption*)qwco;
          }
        }
        break;
      case SANE_TYPE_STRING:
        if(mpScanner->getConstraintType(opt_num) == SANE_CONSTRAINT_STRING_LIST)
        {
          qcb = new QComboOption((const char*)mpScanner->getOptionTitle(opt_num),parent,//qvbox,
                                 (const char*)mpScanner->getOptionName(opt_num));
          qcb->setSaneOptionNumber(opt_num);
          qcb->setOptionSize(mpScanner->optionSize(opt_num));
          QStringList slist = mpScanner->getStringList(opt_num);
          qcb->setStringList(slist);
          //CAP_AUTOMATIC ?
          if(mpScanner->automaticOption(opt_num))
          {
            qcb->enableAutomatic(true);
            connect(qcb,SIGNAL(signalAutomatic(int,bool)),
                    this,SLOT(slotAutoMode(int,bool)));
          }
          qcb->setOptionDescription(mpScanner->getOptionDescription(opt_num));
          qcb->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
          qcb->setSaneValueType(mpScanner->getOptionType(opt_num));
          qcb->setStrList(mpScanner->getStrList(opt_num));
          QWhatsThis::add(qcb,qcb->optionDescription());
          stringval = mpScanner->saneStringValue(opt_num);
          qcb->setCurrentValue((const char*)stringval);
          connect(qcb,SIGNAL(signalOptionChanged(int)),this,
                  SLOT(slotOptionChanged(int)));
          ret = (QSaneOption*)qcb;
        }
        if(mpScanner->getConstraintType(opt_num) == SANE_CONSTRAINT_NONE)
        {
          qso = new QStringOption((const char*)mpScanner->getOptionTitle(opt_num),parent,//qvbox,
                                  (const char*)mpScanner->getOptionName(opt_num));
          qso->setSaneOptionNumber(opt_num);
          qso->setOptionSize(mpScanner->optionSize(opt_num));
          qso->setOptionDescription(mpScanner->getOptionDescription(opt_num));
          qso->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
          qso->setSaneValueType(mpScanner->getOptionType(opt_num));
          QWhatsThis::add(qso,qso->optionDescription());
          qso->setMaxLength(mpScanner->optionSize(opt_num)-1);
          stringval = mpScanner->saneStringValue(opt_num);
          qso->setText((const char*)stringval);
          connect(qso,SIGNAL(signalOptionChanged(int)),this,
                  SLOT(slotOptionChanged(int)));
          ret=(QSaneOption*)qso;
        }
        break;
      default:;
    }
  }
  //check whether it's a read only option
  else if(mpScanner->isReadOnly(opt_num))
  {
    qroo = new QReadOnlyOption((const char*)mpScanner->getOptionTitle(opt_num),parent,//qvbox,
                               (const char*)mpScanner->getOptionName(opt_num));
    qroo->setSaneOptionNumber(opt_num);
    qroo->setOptionSize(mpScanner->optionSize(opt_num));
    qroo->setOptionDescription(mpScanner->getOptionDescription(opt_num));
    qroo->setSaneConstraintType(mpScanner->getConstraintType(opt_num));
    qroo->setSaneValueType(mpScanner->getOptionType(opt_num));
    QWhatsThis::add(qroo,qroo->optionDescription());
    qroo->setText(mpScanner->saneReadOnly(opt_num));
//    if(qroo->optionName() == "button-state")
//      mpButtonOption = qroo;
    ret=(QSaneOption*)qroo;
  }
  qDebug("create saneoption widget - leave");
  return ret;
}
/** No descriptions */
QGroupBox* QScanDialog::createOptionGroupBox(QString title,int firstoption,int lastoption)
{
  QGroupBox* qgb       = 0;
  QSaneOption* widget_pointer = 0;
  QString stringval    = QString::null;
  int c2               = 0;
  //create a group box with a QVBoxLayout
  qgb = new QGroupBox(lastoption-firstoption+1,Qt::Vertical,
                      mpOptionScrollView->getMainWidget());
  qgb->setFrameStyle(QGroupBox::StyledPanel);
  qgb->setTitle(title);
  for(c2=firstoption;c2<=lastoption;c2++)
  {
    SaneWidgetHolder* swh = new SaneWidgetHolder(qgb);
    widget_pointer = createSaneOptionWidget(swh,c2);
    if(widget_pointer)
    {
      swh->addWidget(widget_pointer);
      mOptionWidgets.resize(mOptionWidgets.size()+1);
      mOptionWidgets[mOptionWidgets.size()-1] = swh;
      widget_pointer->setOptionNumber(mOptionWidgets.size()-1);
    }
    else
      delete swh;
  }
  mGroupBoxArray.resize(mGroupBoxArray.size()+1);
  mGroupBoxArray[mGroupBoxArray.size()-1] = qgb;
  return qgb;
}
/**  */
void QScanDialog::createPreviewWidget()
{
//Currently the size widget is only created
//if all scan area options are available
  int cnt;
  QScrollBarOption* qsbo;
  SANE_Unit unit;

	mpPreviewWidget = 0L;
//at the moment the preview widget is only supported
//if the scan area options can be represented by
//scrollbars
  mpTlxOption = 0L;
  mpTlyOption = 0L;
  mpBrxOption = 0L;
  mpBryOption = 0L;
  for(cnt=0;cnt<int(mOptionWidgets.size());cnt++)
  {
    qsbo = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QScrollBarOption") == true)
 	    qsbo=(QScrollBarOption*)(mOptionWidgets[cnt]->saneOption());			
    if(qsbo)
		{
	  	if(qsbo->optionName()=="tl-x") mpTlxOption = qsbo;
			if(qsbo->optionName()=="tl-y") mpTlyOption = qsbo;
			if(qsbo->optionName()=="br-x")	mpBrxOption = qsbo;
			if(qsbo->optionName()=="br-y")	mpBryOption = qsbo;
    }
  }
//check whether all scan area options are present
	if((mpTlxOption) && (mpTlyOption) &&
     (mpBrxOption) && (mpBryOption))
	{
   //check whether unit is of type SANE_UNIT_MM
   //or SANE_UNIT_PIXEL
   //it's sufficient to check one option
   //since all scan area option must have the same unit
    unit = mpScanner->getUnit(mpTlxOption->saneOptionNumber());
    if((unit == SANE_UNIT_MM) || (unit == SANE_UNIT_PIXEL))
    {
      mpPreviewWidget = new PreviewWidget(this,"",0);
      mpMainLayout->setColStretch(0,0);
      mpMainLayout->setColStretch(2,1);
      setPreviewRange();
      mpPreviewWidget->setMetrics(QIN::Millimetre,unit);
      connect(mpPreviewWidget,SIGNAL(signalTlxPercent(double)),
              mpTlxOption,SLOT(slotSetPercentValue(double)));
      connect(mpPreviewWidget,SIGNAL(signalTlyPercent(double)),
              mpTlyOption,SLOT(slotSetPercentValue(double)));
      connect(mpPreviewWidget,SIGNAL(signalBrxPercent(double)),
              mpBrxOption,SLOT(slotSetPercentValue(double)));
      connect(mpPreviewWidget,SIGNAL(signalBryPercent(double)),
              mpBryOption,SLOT(slotSetPercentValue(double)));
      connect(mpTlxOption,SIGNAL(signalValuePercent(double)),
              mpPreviewWidget,SLOT(slotSetTlxPercent(double)));
      connect(mpTlyOption,SIGNAL(signalValuePercent(double)),
              mpPreviewWidget,SLOT(slotSetTlyPercent(double)));
      connect(mpBrxOption,SIGNAL(signalValuePercent(double)),
              mpPreviewWidget,SLOT(slotSetBrxPercent(double)));
      connect(mpBryOption,SIGNAL(signalValuePercent(double)),
              mpPreviewWidget,SLOT(slotSetBryPercent(double)));
      connect(mpPreviewWidget,SIGNAL(signalPredefinedSize(ScanArea*)),
              this,SLOT(slotSetPredefinedSize(ScanArea*)));
      connect(mpPreviewWidget,SIGNAL(signalMultiSelectionMode(bool)),
              this,SLOT(slotMultiSelectionMode(bool)));
      connect(mpPreviewWidget,SIGNAL(signalEnableScanAreaOptions(bool)),
              this,SLOT(slotEnableScanAreaOptions(bool)));
    }
  }
  else
	{
    //create preview widget
    mpPreviewWidget = new PreviewWidget(this,"",0);
    mpMainLayout->setColStretch(0,0);
    mpMainLayout->setColStretch(2,1);
//    setPreviewRange();
    mpPreviewWidget->setMetrics(QIN::NoMetricSystem,SANE_UNIT_NONE);
  }
}
/**  */
void QScanDialog::slotPreviewSize(QRect rect)
{
  int i1;
  int i2;
  int i3;
  int i4;
  SANE_Word tlx1;
  SANE_Word tly1;
  SANE_Word brx1;
  SANE_Word bry1;
  SANE_Word tlx2;
  SANE_Word tly2;
  SANE_Word brx2;
  SANE_Word bry2;

  i1 = mpTlxOption->saneOptionNumber();
  tlx1 = (SANE_Word) rect.left();
  tlx2 = tlx1;
  mpTlxOption->setValueExt(tlx1);

  i2 = mpTlyOption->saneOptionNumber();
  tly1 = (SANE_Word) rect.top();
  tly2 = tly1;
  mpTlyOption->setValueExt(tly1);

  i3 = mpBrxOption->saneOptionNumber();
  brx1 = (SANE_Word) rect.right();
  brx2 = brx1;
  mpBrxOption->setValueExt(brx1);

  i4 = mpBryOption->saneOptionNumber();
  bry1 = (SANE_Word) rect.bottom();
  bry2 = bry1;
  mpBryOption->setValueExt(bry1);
//reset, just to be sure
  mpTlxOption->setValueExt(tlx1);
  mpTlyOption->setValueExt(tly1);
}
/**  */
void QScanDialog::slotResizeScanRect()
{
	double tlx,tly,brx,bry;
  tlx = mpTlxOption->getPercentValue();
  tly = mpTlyOption->getPercentValue();
  brx = mpBrxOption->getPercentValue();
  bry = mpBryOption->getPercentValue();
  mpPreviewWidget->setRectSize(tlx,tly,brx,bry);
}
/**  */
void QScanDialog::slotSetPredefinedSize(ScanArea* sca)
{
	double tlx,tly,brx,bry;

  if(!sca->isValid()) return;
  tlx = sca->tlx();
  tly = sca->tly();
  brx = sca->brx();
  bry = sca->bry();

//change scrollbar options
  mpTlxOption->slotSetPercentValue(tlx);
  mpTlyOption->slotSetPercentValue(tly);
  mpBrxOption->slotSetPercentValue(brx);
  mpBryOption->slotSetPercentValue(bry);
//set tlx/tly option again (to be sure)
  mpTlxOption->slotSetPercentValue(tlx);
  mpTlyOption->slotSetPercentValue(tly);
}

/**  */
void QScanDialog::changeLayout(QIN::Layout l)
{
  //check whether a change is necessary at all
  QString titlestring;
  if(mLayout == l) return;
  unsigned int c;
  mLayout = l;
  QGroupBox* qgb;
  QWidget* qw;
  QVBoxLayout* qvbl2;
  QPoint p(0,0);
  if(mLayout == QIN::ScrollLayout)
  {
    mpOptionScrollView = new QOptionScrollView(this);
    mpOptionScrollView->setFrameStyle(QScrollView::StyledPanel | QScrollView::Raised);
    mpOptionScrollView->setHScrollBarMode(QScrollView::AlwaysOff);
    //reparent the groupboxes in mGroupBoxArray
    //this way there's no need to requery the device
    for(c=0;c<mGroupBoxArray.size();c++)
    {
      qgb=(QGroupBox*)mGroupBoxArray[c];
      qgb->reparent(mpOptionScrollView->getMainWidget(),p,FALSE);
      qgb->setFrameStyle(QGroupBox::StyledPanel);
      mpOptionScrollView->addWidget(qgb);
    }
    if(mpOptionTabWidget)
    {
      delete mpOptionTabWidget;
      mpOptionTabWidget = 0;
    }
    if(mOptionSubArray.size() > 0)
    {
      for(c=0;c<mOptionSubArray.size();c++)
        delete mOptionSubArray[c];
      mOptionSubArray.resize(0);
    }
    if(mpOptionListWidget)
    {
      delete mpOptionListWidget;
      mpOptionListWidget = 0;
    }
    mpMainLayout->addWidget(mpOptionScrollView,1,0);
    mpOptionScrollView->show();
    //hack to get it correctly resized
    resize(width()+1,height()+1);
    qApp->processEvents();
    resize(width()-1,height()-1);
  }
  if(mLayout == QIN::TabLayout)
  {
    mpOptionTabWidget = new QTabWidget(this);
    mpMainLayout->addWidget(mpOptionTabWidget,1,0);
    //reparent the groupboxes in mGroupBoxArray
    //this way there's no need to requery the device
    for(c=0;c<mGroupBoxArray.size();c++)
    {
      qw = new QWidget(mpOptionTabWidget);
      qvbl2 = new QVBoxLayout(qw,2,2);
      qgb=(QGroupBox*)mGroupBoxArray[c];
      qgb->reparent(qw,p,FALSE);
      qgb->setFrameStyle(QGroupBox::NoFrame);
      qvbl2->addWidget(qgb,0,0);
      qvbl2->addStretch(1);
      titlestring = tr("&%1. ").arg(c+1);
      titlestring += qgb->title();
      mpOptionTabWidget->addTab(qw,titlestring);
    }
    if(mpOptionScrollView)
    {
      delete mpOptionScrollView;
      mpOptionScrollView = 0;
    }
    if(mOptionSubArray.size() > 0)
    {
      for(c=0;c<mOptionSubArray.size();c++)
        delete mOptionSubArray[c];
      mOptionSubArray.resize(0);
    }
    if(mpOptionListWidget)
    {
      delete mpOptionListWidget;
      mpOptionListWidget = 0;
    }
    //stupid, but works (?)
    qApp->processEvents();
    QApplication::sendPostedEvents();
    mpOptionTabWidget->hide();
    mpOptionTabWidget->show();
    qApp->processEvents();
    QApplication::sendPostedEvents();
    mpOptionTabWidget->resize(mpOptionTabWidget->sizeHint().width(),
                              mpOptionTabWidget->height());
    //hack to get it correctly resized
    resize(width()+1,height()+1);
    qApp->processEvents();
    resize(width()-1,height()-1);
  }
  if(mLayout == QIN::ListLayout)
  {
    mpOptionListWidget = new QWidget(this);
    QGridLayout* listgrid = new QGridLayout(mpOptionListWidget,1,2);
    listgrid->setSpacing(5);
    listgrid->setColStretch(1,1);
    mpOptionListView = new QListView(mpOptionListWidget);
    mpOptionListView->addColumn(tr("SANE Options"));
    mpOptionListView->setSorting(-1);
    mpOptionWidgetStack = new QWidgetStack(mpOptionListWidget);
    listgrid->addWidget(mpOptionListView,0,0);
    listgrid->addWidget(mpOptionWidgetStack,0,1);
    QListViewItemExt* nlv = 0;
    for(c=0;c<mGroupBoxArray.size();c++)
    {
      titlestring = mGroupBoxArray[c]->title();
      if(!nlv)
      {
        nlv = new QListViewItemExt(mpOptionListView,titlestring);
        nlv->setIndex(c);
        mpOptionListView->setSelected(nlv,true);
      }
      else
      {
        nlv = new QListViewItemExt(mpOptionListView,(QListViewItem*)nlv,
                                        titlestring);
        nlv->setIndex(c);
      }
      qgb=(QGroupBox*)mGroupBoxArray[c];
      qgb->setFrameStyle(QGroupBox::StyledPanel);
      //this also reparents the widgets
      mpOptionWidgetStack->addWidget(qgb,c);
    }
    if(mOptionSubArray.size() > 0)
    {
      for(c=0;c<mOptionSubArray.size();c++)
        delete mOptionSubArray[c];
      mOptionSubArray.resize(0);
    }
    if(mpOptionTabWidget)
    {
      delete mpOptionTabWidget;
      mpOptionTabWidget = 0;
    }
    if(mpOptionScrollView)
    {
      delete mpOptionScrollView;
      mpOptionScrollView = 0;
    }
    mpMainLayout->addWidget(mpOptionListWidget,1,0);
    connect(mpOptionListView,SIGNAL(selectionChanged(QListViewItem*)),
            this,SLOT(slotRaiseOptionWidget(QListViewItem*)));
    mpOptionListView->setMinimumWidth(mpOptionListView->sizeHint().width()+8);
    mpOptionListWidget->show();
    //stupid, but works (?)
    qApp->processEvents();
    QApplication::sendPostedEvents();
//    mpOptionWidgetStack->hide();
//    mpOptionWidgetStack->show();
    mpOptionWidgetStack->resize(mpOptionWidgetStack->width(),
                              mpOptionWidgetStack->sizeHint().height());
    mpOptionWidgetStack->raiseWidget(0);
    qApp->processEvents();
    QApplication::sendPostedEvents();
    mpOptionListView->setColumnWidthMode(0,QListView::Manual);
    mpOptionListView->setColumnWidth(0,mpOptionListView->viewport()->width());
  }
}
/**  */
QIN::Status QScanDialog::status()
{
  return mStatus;
}
/**  */
void QScanDialog::slotImageInfo()
{
  double mbsize;
  QString qs;
  qs = mpScanner->imageInfo();
  int warn_size = xmlConfig->intValue("SCAN_SIZE_WARNING",2);
  mbsize = mpScanner->imageInfoMB();
  if(mbsize > warn_size)
  {
    mpLabelImageInfo->setPalette( QPalette( QColor(240, 30, 30) ) );
    qs = "<b>" + qs +" !" + "<b>";
  }
  else
    mpLabelImageInfo->setPalette(palette());
  mpLabelImageInfo->setText(qs);
}
/** This slot is called, when setting an option results
in an return value SANE_INFO_INEXACT.
This normally happens, when the value set in
the backend  is different from the requested value. */
void QScanDialog::slotInfoInexact(int num)
{
  SANE_Int i_val;
  SANE_Fixed f_val;
  SANE_Bool b_val;
  QString stringval;
  QScrollBarOption* qsbo;
  QBoolOption* qboolo;
  QWordComboOption* qwco;
  QStringOption* qso;
  int cnt;
  for(cnt=0;cnt<int(mOptionWidgets.size());cnt++)
  {
    qsbo = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QScrollBarOption") == true)
    qsbo=(QScrollBarOption*)(mOptionWidgets[cnt]->saneOption());			
    if(qsbo)
    {
    //scrollbar option found
      if(qsbo->saneOptionNumber() == num)
      {
        if(qsbo->getSaneType() == SANE_TYPE_INT)
        {
          i_val = (SANE_Int)mpScanner->saneWordValue(qsbo->saneOptionNumber());
          qsbo->setValue(i_val);
          break;
        }
        if(qsbo->getSaneType() == SANE_TYPE_FIXED)
        {
          f_val = (SANE_Fixed)mpScanner->saneWordValue(qsbo->saneOptionNumber());
          qsbo->setValue(f_val);
          break;
        }
      }
    }
    qwco = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QWordComboOption") == true)
      qwco=(QWordComboOption*)(mOptionWidgets[cnt]->saneOption());			
    if(qwco)
    {
      if(qwco->saneOptionNumber() == num)
      {
        i_val = (SANE_Int)mpScanner->saneWordValue(qwco->saneOptionNumber());
        qwco->setValue(i_val);
        break;
      }
    }
    qboolo = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QBoolOption") == true)
      qboolo=(QBoolOption*)(mOptionWidgets[cnt]->saneOption());			
    if(qboolo)
    {
      if(qboolo->saneOptionNumber() == num)
      {
        b_val = (SANE_Bool)mpScanner->saneWordValue(qboolo->saneOptionNumber());
        qboolo->setState(b_val);
        break;
      }
    }
    //check whether it's a string option
    qso = 0L;
    if(((QObject*)(mOptionWidgets[cnt]->saneOption()))->isA("QStringOption") == true)
      qso=(QStringOption*)(mOptionWidgets[cnt]->saneOption());			
    QString optionstring;
    if(qso)
    {
      //always string type
      if(qso->saneOptionNumber() == num)
      {
        stringval = mpScanner->saneStringValue(qso->saneOptionNumber());
        qso->setText(stringval);
        break;
      }
    }
  }


//  SANE_Int i_val;
//  SANE_Fixed f_val;
//  SANE_Bool b_val;
//  QString stringval;
//	QScrollBarOption* qsbo;
//	QBoolOption* qboolo;
//	QWordComboOption* qwco;
//	QStringOption* qso;
//	int cnt;
//  for(cnt=0;cnt<int(mOptionWidgets.size());cnt++)
//	{
//    qsbo = 0L;
//    if(((QObject*)mOptionWidgets[cnt])->isA("QScrollBarOption") == TRUE)
//   	  qsbo=(QScrollBarOption*)mOptionWidgets[cnt];			
//    if(qsbo)
//		{
//    //scrollbar option found
//			if(qsbo->saneOptionNumber() == num)
//      {
//        if(qsbo->getSaneType() == SANE_TYPE_INT)
//        {
// 					i_val = (SANE_Int)mpScanner->saneWordValue(qsbo->saneOptionNumber());
//          qsbo->setValue(i_val);
//          break;
//        }
//        if(qsbo->getSaneType() == SANE_TYPE_FIXED)
//        {
// 					f_val = (SANE_Fixed)mpScanner->saneWordValue(qsbo->saneOptionNumber());
//          qsbo->setValue(f_val);
//          break;
//        }
//      }
//    }
//    qwco = 0L;
//    if(((QObject*)mOptionWidgets[cnt])->isA("QWordComboOption") == TRUE)
//   	  qwco=(QWordComboOption*)mOptionWidgets[cnt];			
//    if(qwco)
//		{
//			if(qwco->saneOptionNumber() == num)
//      {
//				i_val = (SANE_Int)mpScanner->saneWordValue(qwco->saneOptionNumber());
//        qwco->setValue(i_val);
//        break;
//      }
//    }
//    qboolo = 0L;
//    if(((QObject*)mOptionWidgets[cnt])->isA("QBoolOption") == TRUE)
//   	  qboolo=(QBoolOption*)mOptionWidgets[cnt];			
//		if(qboolo)
//		{
//			if(qboolo->saneOptionNumber() == num)
//      {
//				b_val = (SANE_Bool)mpScanner->saneWordValue(qboolo->saneOptionNumber());
//        qboolo->setState(b_val);
//        break;
//      }
//		}
//    //check whether it's a string option
//    qso = 0L;
//    if(((QObject*)mOptionWidgets[cnt])->isA("QStringOption") == TRUE)
//   	  qso=(QStringOption*)mOptionWidgets[cnt];			
//    QString optionstring;
//	  if(qso)
//	  {
//			//always string type
//			if(qso->saneOptionNumber() == num)
//      {
//				stringval = mpScanner->saneStringValue(qso->saneOptionNumber());
//        qso->setText(stringval);
//        break;
//      }
//    }
//  }
}
/** Do a scan with the current settings. Return false
if an error occurs. Otherwise true is returned and the
image is saved to .scantemp.pnm.*/
bool QScanDialog::scanImage(bool pre,bool adf_warning,QWidget* parent)
{
  bool b;
  QString statusstring;
  SANE_Status status;
  b=true;
  if(!pre)
    status = mpScanner->scanImage(xmlConfig->absConfDirPath()+".scantemp.pnm",parent);
  else
    status = mpScanner->scanPreview(xmlConfig->absConfDirPath()+".previewtemp.pnm",
                                    parent);
  if(mpScanner->appCancel())
  {
    return false;
  }
	if(status != SANE_STATUS_GOOD)
  {
    QSaneStatusMessage statusmsg(status,this);
    statusmsg.exec();
    b = false;
  }
  return b;
}
bool QScanDialog::scanPreviewImage(double tlx,double tly,double brx,double bry,int res)
{
  bool b;
  QString statusstring;
  SANE_Status status;
  b=true;

  mpPreviewWidget->clearPreview();
  mpPreviewWidget->enablePreviewMode(true);
  qApp->processEvents();
  status = mpScanner->scanPreview(xmlConfig->absConfDirPath()+".previewtemp.pnm",
                                  mpPreviewWidget,tlx,tly,brx,bry,res);
  mpPreviewWidget->enablePreviewMode(false);
  if(mpScanner->appCancel())
  {
    return false;
  }
  if(status != SANE_STATUS_GOOD)
  {
    QSaneStatusMessage statusmsg(status,mpPreviewWidget);
    statusmsg.exec();
    b = false;
  }
  return b;
}
/**  */
void QScanDialog::slotAutoMode(int num,bool b)
{
  SANE_Int   si;
  QBoolOption*      qboolo;
  QComboOption*     qco;
  QWordComboOption* qwco;
  QString combostring;
  void*             v;
  int i;
  SANE_Bool sb;
  v = 0L;
  i = 0;
  v = 0L;
  qco = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QComboOption") == true)
    qco=(QComboOption*)(mOptionWidgets[num]->saneOption());			
  if(qco)
  {
    //always string type
    i = qco->saneOptionNumber();
    if(!b)
    {
      combostring = qco->getCurrentText();
      v = (SANE_String*)combostring.latin1();
      if(v)mpScanner->setOption(i,v);
    }
    else
      mpScanner->setOption(i,0L,true);
    return;
  }
  qboolo = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QBoolOption") == true)
    qboolo=(QBoolOption*)(mOptionWidgets[num]->saneOption());			
  if(qboolo)
  {
    //always string type
    i = qboolo->saneOptionNumber();
    if(!b)
    {
      sb = qboolo->state();
      mpScanner->setOption(i,&sb);
    }
    else if(mpScanner->setOption(i,0L,true) == SANE_STATUS_GOOD)
      qboolo->setState((SANE_Word)mpScanner->saneWordValue(i));
    return;
  }
  //check whether it's a word combo option
  qwco = 0L;
  if(((QObject*)(mOptionWidgets[num]->saneOption()))->isA("QWordComboOption") == true)
    qwco=(QWordComboOption*)(mOptionWidgets[num]->saneOption());			
  if(qwco)
  {
    i = qwco->saneOptionNumber();
    if(!b)
    {
      si = qwco->getCurrentValue();
      mpScanner->setOption(i,&si);
    }
    else if(mpScanner->setOption(i,0L,true) == SANE_STATUS_GOOD)
      qwco->setValue((SANE_Word)mpScanner->saneWordValue(i));
    return;
  }


//  SANE_Int   si;
//	QComboOption*     qco;
//	QWordComboOption* qwco;
//  QString combostring;
//  void*             v;
//	int i;
//  v = 0L;
//	i = 0;
//  v = 0L;
//  qco = 0L;
//  if(((QObject*)mOptionWidgets[num])->isA("QComboOption") == TRUE)
// 	  qco=(QComboOption*)mOptionWidgets[num];			
//  if(qco)
//  {
//		//always string type
//    i = qco->saneOptionNumber();
//    if(!b)
//    {
//		  combostring = qco->getCurrentText();
//  	  v = (SANE_String*)combostring.latin1();
//		  if(v)mpScanner->setOption(i,v);
//    }
//    else
//		  mpScanner->setOption(i,0L,true);
//    return;
//  }
//	//check whether it's a word combo option
//  qwco = 0L;
//  if(((QObject*)mOptionWidgets[num])->isA("QWordComboOption") == TRUE)
//    qwco=(QWordComboOption*)mOptionWidgets[num];			
//  if(qwco)
//	{
//    i = qwco->saneOptionNumber();
//    if(!b)
//    {
//      si = qwco->getCurrentValue();
//	    mpScanner->setOption(i,&si);
//    }
//    else
//    {
//		  if(mpScanner->setOption(i,0L,true) == SANE_STATUS_GOOD)
//   		  qwco->setValue((SANE_Word)mpScanner->saneWordValue(i));
//    }
//    return;
//  }
}
/**  */
void QScanDialog::showEvent(QShowEvent* se)
{
  QDialog::showEvent(se);
  //make sure that the window isn't heigher than the desktop
  //right after program start, at least in scrollview mode
  //and therefore also if the user starts Qis for the first time
  if((mLayout == QIN::ScrollLayout) && mShowCnt == 0)
  {
    qApp->processEvents();
    mpOptionScrollView->hide();
    qApp->processEvents();
    mpOptionScrollView->show();
    qApp->processEvents();
    resize(sizeHint().width(),sizeHint().height());
    if(height()>qApp->desktop()->height()*5/6)
      resize(width(),qApp->desktop()->height()*5/6);
    mShowCnt += 1;
  }
  if(!mpPreviewWidget)
    return;
  int w = xmlConfig->intValue("SCANDIALOG_INTEGRATED_PREVIEW_WIDTH",0);
  int h = xmlConfig->intValue("SCANDIALOG_INTEGRATED_PREVIEW_HEIGHT",0);
  if(mpPreviewWidget->isVisible())
  {
    if(w < width())
      w = width();
    if(h < height())
      h = height();
    resize(w,h);
  }
}
/**  */
void QScanDialog::slotDeviceSettings()
{
  QDeviceSettings devset(mpScanner,this);
  devset.exec();
}
/**  */
void QScanDialog::slotRaiseOptionWidget(QListViewItem* lvi)
{
  if(!lvi) return;
  QListViewItemExt* nlv;
  //to be sure
  if(!mpOptionListWidget || !mpOptionWidgetStack) return;
  nlv = (QListViewItemExt*) lvi;
  mpOptionWidgetStack->raiseWidget(nlv->index());
}
/**  */
void QScanDialog::slotImageSettings()
{
  QExtensionWidget ew(this);
  ew.setPage(5);
  ew.exec();
}
/**  */
void QScanDialog::slotChangeFilename()
{
}
/** No descriptions */
void QScanDialog::slotMultiSelectionMode(bool state)
{
  mMultiSelectionMode = state;
  slotEnableScanAreaOptions(!state);
}
/** No descriptions */
void QScanDialog::slotEnableScanAreaOptions(bool on)
{
  //the scan area options are disabled in multi selection mode
  if(mpTlxOption)
    mpTlxOption->setEnabled(on);
  if(mpTlyOption)
    mpTlyOption->setEnabled(on);
  if(mpBrxOption)
    mpBrxOption->setEnabled(on);
  if(mpBryOption)
    mpBryOption->setEnabled(on);
}
/** No descriptions */
void QScanDialog::resizeScanArea()
{
}
/** No descriptions */
void QScanDialog::setPreviewRange()
{
  if((!mpTlxOption) || (!mpTlyOption) ||
     (!mpBrxOption) || (!mpBryOption))
    return;

  SANE_Unit unit;
  unit = mpScanner->getUnit(mpTlxOption->saneOptionNumber());
  SANE_Value_Type type;
  type = mpScanner->getOptionType(mpTlxOption->saneOptionNumber());
  //normally 0, but you never know
  int x_min = mpTlxOption->minValue();
  int y_min = mpTlyOption->minValue();
  //max vals
  int x_max = mpBrxOption->maxValue();
  int y_max = mpBryOption->maxValue();

  if(unit == SANE_UNIT_MM)
  {
    //If unit is MM, then we can simply check for the min and max
    //values of the scan area options, since they won't change if
    //the resolution changes (unless some drunken backend author
    //has better ideas :-)
    double ar;
    ar = double(x_max-x_min)/double(y_max-y_min);
    mpPreviewWidget->setAspectRatio(ar);
    if(type == SANE_TYPE_INT)
    {
      mpPreviewWidget->setRange(double(x_min),double(x_max),
                                double(y_min),double(y_max));
    }
    else if(type == SANE_TYPE_FIXED)
    {
      mpPreviewWidget->setRange(SANE_UNFIX(x_min),SANE_UNFIX(x_max),
                                SANE_UNFIX(y_min),SANE_UNFIX(y_max));
    }
  }
  else if(unit == SANE_UNIT_PIXEL)
  {
    int resx,resy;
    //try to find xresolution
    resx = mpScanner->xResolution();
    if(resx > 0)
    {
       //try to find yresolution
       resy = mpScanner->yResolution();
       if(resy <= 0)
       {
         //no yres, use xres instead
         resy = resx;
       }
    }
    else
    {
      //no resolution settings at all
      resx = 1;
      resy = 1;
    }
    //This should normally be of SANE_TYPE_INT, but again: you
    //never know ...
    double d_minx,d_maxx,d_miny,d_maxy;
    d_minx = 0.0;
    d_maxx = 0.0;
    d_miny = 0.0;
    d_maxy = 0.0;
    if(type == SANE_TYPE_INT)
    {
      d_minx = double(x_min);
      d_maxx = double(x_max);
      d_miny = double(y_min);
      d_maxy = double(y_max);
    }
    else if(type == SANE_TYPE_FIXED)
    {
      d_minx = SANE_UNFIX(x_min);
      d_maxx = SANE_UNFIX(x_max);
      d_miny = SANE_UNFIX(y_min);
      d_maxy = SANE_UNFIX(y_max);
    }
    double ar;
    ar = ((d_maxx-d_minx)/double(resx))/((d_maxy-d_miny)/double(resy));
    mpPreviewWidget->setAspectRatio(ar);
    mpPreviewWidget->setRange(d_minx,d_maxx,d_miny,d_maxy);
  }
}
/** No descriptions */
void QScanDialog::resizeEvent(QResizeEvent* e)
{
  QWidget::resizeEvent(e);
  if(!mpPreviewWidget || !isVisible())
    return;
  if(mpPreviewWidget->isVisible())
  {
    xmlConfig->setIntValue("SCANDIALOG_INTEGRATED_PREVIEW_WIDTH",width());
    xmlConfig->setIntValue("SCANDIALOG_INTEGRATED_PREVIEW_HEIGHT",height());
  }
}
/** No descriptions */
QList<QImage> QScanDialog::imageList()
{
  return mImageList;
}
/** No descriptions */
void QScanDialog::accept()
{
  QDeviceSettings ds(mpScanner);
  ds.saveDeviceSettings("Last settings");
  mpScanner->setAppCancel(true);
  mpScanner->cancel();
  QDialog::accept();
}
/** No descriptions */
void QScanDialog::reject()
{
  QDeviceSettings ds(mpScanner);
  ds.saveDeviceSettings("Last settings");
  mpScanner->setAppCancel(true);
  mpScanner->cancel();
  QDialog::reject();
}
/** No descriptions */
void QScanDialog::enableMultiSelection(bool state)
{
  if(mpPreviewWidget)
    mpPreviewWidget->enableMultiSelection(state);
}
/**  */
void QScanDialog::enableGUI(bool enable,bool preview_scan)
{
  mpInfoHBox->setEnabled(enable);
  mpButtonHBox1->setEnabled(enable);
  mpButtonHBox2->setEnabled(enable);
  switch(mLayout)
  {
    case QIN::ScrollLayout:
      mpOptionScrollView->setEnabled(enable);
      break;
    case QIN::TabLayout:
      mpOptionTabWidget->setEnabled(enable);
      break;
    case QIN::ListLayout:
      mpOptionListWidget->setEnabled(enable);
      break;
  }
  if(mpPreviewWidget && (preview_scan != true))
    mpPreviewWidget->setEnabled(enable);
  if(mMultiSelectionMode)
    slotEnableScanAreaOptions(false);
}
/** No descriptions */
void QScanDialog::checkOptionValidity(int opt_num)
{
  bool visible=false;
  QSaneOption* new_widget_pointer;
  QSaneOption* so = mOptionWidgets[opt_num]->saneOption();
  visible = so->isVisible();
  int so_number = so->saneOptionNumber();
  //compare some values with the current values from the QScanner class
//  if((so->saneConstraintType() != mpScanner->getConstraintType(so_number)) ||
//     (so->saneValueType() != mpScanner->getOptionType(so_number)))
  if(mpScanner->optionDescriptorChanged(so) == true)
  {
    qDebug("QScanDialog::checkOptionValidity - must recreate sane option %i",so_number);
    qDebug("QScanDialog::checkOptionValidity - opt_num %i",opt_num);
    //create new option
    new_widget_pointer = createSaneOptionWidget(mOptionWidgets[opt_num],so_number);
    if(!new_widget_pointer)
    {
      qDebug("QScanDialog::checkOptionValidity - could not create new widget");
      return;
    }
    new_widget_pointer->setOptionNumber(opt_num);
    //insert new option
    mOptionWidgets[opt_num]->replaceWidget(new_widget_pointer);
    if(visible)
     mOptionWidgets[opt_num]->show();
    qDebug("QScanDialog::checkOptionValidity - success");
  }
}


