/* $Header: d:/cvsroot/tads/tads3/VMINIT.H,v 1.2 1999/05/17 02:52:28 MJRoberts Exp $ */

/* 
 *   Copyright (c) 1999, 2002 Michael J. Roberts.  All Rights Reserved.
 *   
 *   Please see the accompanying license file, LICENSE.TXT, for information
 *   on using and copying this software.  
 */
/*
Name
  vminit.h - initialize and terminate a VM session
Function
  
Notes
  VM initialization is configurable via the linker.  To select a
  configuration, link in exactly one of the vmcfgxxx.cpp object files.
Modified
  04/06/99 MJRoberts  - Creation
*/

#ifndef VMINIT_H
#define VMINIT_H

#include "vmglob.h"

/*
 *   Generic initialization function.  Client code calls this function to
 *   initialize the VM.  The actual implementation of this function is
 *   selected at link time from the several provided configurations.
 *   
 *   'charset' is the name of the display character mapping that we should
 *   use.  If 'charset' is null, we'll use the default character set
 *   obtained from the OS layer.  
 */
void vm_initialize(struct vm_globals **vmg, class CVmHostIfc *hostifc,
                   class CVmMainClientIfc *clientifc,
                   const char *charset);

/*
 *   Initialization, phase 2 - just before loading the image file 
 */
void vm_init_before_load(VMG_ const char *image_filename);

/*
 *   Initialization, phase 3 - just after loading the image file 
 */
void vm_init_after_load(VMG0_);

/*
 *   Terminate the VM.  Deletes all objects created by vm_init().  This
 *   can be used to clean up memory after a program has finished
 *   executing.  
 */
void vm_terminate(struct vm_globals *vmg, class CVmMainClientIfc *clientifc);


/* ------------------------------------------------------------------------ */
/*
 *   Private interface.  Client code does not call any of the following
 *   routines; they're for use internally by the initialization mechanism
 *   only. 
 */

/*
 *   Initialize the VM with in-memory pools.  Creates all global objects
 *   necessary for the VM to run.  
 */
void vm_init_in_mem(struct vm_globals **vmg, class CVmHostIfc *hostifc,
                    class CVmMainClientIfc *clientifc,
                    const char *charset);

/* initialize the VM with the "flat" memory pool manager */
void vm_init_flat(struct vm_globals **vmg, class CVmHostIfc *hostifc,
                  class CVmMainClientIfc *clientifc,
                  const char *charset);

/*
 *   Initialize the VM with swapping pools with the given maximum number
 *   of pages in memory.  
 */
void vm_init_swap(struct vm_globals **vmg, size_t max_mem_pages,
                  class CVmHostIfc *hostifc,
                  class CVmMainClientIfc *clientifc,
                  const char *charset);

/*
 *   Internal base initialization routine.  Clients do not call this
 *   routine directly; it's for use by vm_init_in_mem(), vm_init_swap(),
 *   and any other vm_init_xxx routines.
 */
void vm_init_base(struct vm_globals **vmg, class CVmHostIfc *hostifc,
                  class CVmMainClientIfc *clientifc,
                  const char *charset);

/*
 *   Initialize debugger-related objects.  For non-debug versions, this
 *   doesn't need to do anything.  
 */
void vm_init_debugger(VMG0_);

/*
 *   Termination - shut down the debugger.  Notifies the debugger UI that
 *   we're terminating the executable.  
 */
void vm_terminate_debug_shutdown(VMG0_);

/*
 *   termination - delete debugger-related objects, if any were allocated
 *   in vm_init_debugger() 
 */
void vm_terminate_debug_delete(VMG0_);


#endif /* VMINIT_H */

