/***************************************************************************
                          txwindow.h  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef txwindow_included
#define txwindow_included
#include <qmainwindow.h>
#include <qtoolbar.h>
#include <qprinter.h>
#include <qpopupmenu.h>
#include <qlayout.h>
#include <qfile.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qspinbox.h>

class imageFrame;
class VUMeter;

class txWindow : public QMainWindow
{
    Q_OBJECT
public:
    txWindow(QWidget *p=0 ,const char *n=0, WFlags f=0);
    ~txWindow();
    void setupBanners();
    QComboBox *txBanners;
    bool load(const char *s,bool showError=TRUE);
    void modeChange(int mc);
    

protected  slots:
    void slotSave();
    void slotPrint();
    void slotLoad();
    virtual void slotStart()=0;
    virtual void slotStop()=0;
    virtual void slotSend1750()=0;
    virtual void slotDump()=0;
    virtual void slotCWsend()=0;
    virtual void slotTestFrequency()=0;
    virtual void slotPlayback()=0;
    void slotErase();
    void slotEdit();
    void slotZoom();
    void slotBrowsetx();
    void slotReplay();
    void slotPosition();
    void slotCW(bool c);
    void slotBanner(bool c);
    void slotTimestamp(bool c);
    void slotVox(bool c);
    void slotModeChange(int mc);
    void slotBannerChange(int mc);
    virtual void slotSSTVFAX(int i);
		void slotFaxTypeChanged(int);
 protected:
    void setCanvasSize(int x,int y);
    int canvasX,canvasY;
    void initMode();
    virtual void closeEvent(QCloseEvent *e);
    imageFrame  *canvas;
    VUMeter *progress;
    QFile ftemp;
    QLabel *fsd;
    void buildLayoutFAX(int,int);
    void buildLayoutSSTV();

protected:
    QComboBox *txMode;
    int px,py;
    QPrinter *printer;
    QToolBar *mainTools;
    QToolBar *sstvTools;
    QToolBar *faxTools;
    QPopupMenu *options;

    QComboBox *sstvfax;
    QSpinBox *lpmSpinBox;
    QSpinBox *iocSpinBox;
    QComboBox *faxTypeComboBox;
    QComboBox *selectBox;
    QComboBox *colorComboBox;
    QSpinBox *linesSpinBox;
};
#endif










