

#include "slantadjust.h"
#include <qpixmap.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qwmatrix.h>

#include "qsstvglobal.h"
#include "sstvparam.h"
#include "imageframe.h"

slantAdjust::slantAdjust (QWidget* parent,const char* name):
	QDialog( parent, name,TRUE,0)
{
	pmSave=NULL;
  canvas = new imageFrame( this, "slantCanvas" );
  canvas->setGeometry( 10, 5, 320, 256 );
  canvas->setMinimumSize( 320, 256 );
  canvas->setMaximumSize( 320, 256 );
  canvas->setFocusPolicy( QWidget::NoFocus );
  canvas->setBackgroundMode( QWidget::PaletteBackground );
//  canvas->setFontPropagation( QWidget::NoChildren );
//  canvas->setPalettePropagation( QWidget::NoChildren );
  slantEdit = new QLineEdit( this, "LineEdit_1" );
  slantEdit->setGeometry( 5, 298, 107, 25 );
  slantEdit->setMinimumSize( 0, 25 );
  slantEdit->setMaximumSize( 32000, 25 );
  slantEdit->setFocusPolicy( QWidget::StrongFocus );
  slantEdit->setBackgroundMode( QWidget::PaletteBase );
//  slantEdit->setFontPropagation( QWidget::NoChildren );
//  slantEdit->setPalettePropagation( QWidget::NoChildren );
  slantEdit->setText( "" );
  slantEdit->setMaxLength( 32767 );
  slantEdit->setFrame( QLineEdit::Normal );
  slantEdit->setFrame( TRUE );
  QSlider* slider = new QSlider( this, "Slider_1" );
  slider->setGeometry( 5, 266, 330, 25 );
  slider->setMinimumSize( 0, 25 );
  slider->setMaximumSize( 32767, 25 );

  slider->setFocusPolicy( QWidget::TabFocus );
  slider->setBackgroundMode( QWidget::PaletteMid );
//  slider->setFontPropagation( QWidget::NoChildren );
//  slider->setPalettePropagation( QWidget::NoChildren );
  slider->setOrientation( QSlider::Horizontal );
  slider->setRange( -50, 50 );
  slider->setSteps( 1, 10 );
  slider->setValue( 0 );
  slider->setTracking( TRUE );
  slider->setTickmarks( QSlider::Below );
  slider->setTickInterval( 0 );
  connect( slider, SIGNAL(valueChanged(int)), SLOT(valueChanged(int)) );
  slider->setValue( 0 );
  QPushButton* okPushButton;
  okPushButton = new QPushButton( this, "PushButton_1" );
  okPushButton->setGeometry( 117, 298, 106, 25 );
  okPushButton->setMinimumSize( 0, 25 );
  okPushButton->setMaximumSize( 32767, 25 );
  connect( okPushButton, SIGNAL(clicked()), SLOT(okClicked()) );
  okPushButton->setFocusPolicy( QWidget::TabFocus );
  okPushButton->setBackgroundMode( QWidget::PaletteBackground );
//  okPushButton->setFontPropagation( QWidget::NoChildren );
//  okPushButton->setPalettePropagation( QWidget::NoChildren );
  okPushButton->setText( "OK" );
  okPushButton->setAutoRepeat( FALSE );
  okPushButton->setAutoResize( FALSE );
  okPushButton->setToggleButton( FALSE );
  okPushButton->setDefault( FALSE );
  okPushButton->setAutoDefault( FALSE );
  okPushButton->setIsMenuButton( FALSE );
  
  QPushButton* cancelPushButton;
  cancelPushButton = new QPushButton( this, "PushButton_2" );
  cancelPushButton->setGeometry( 228, 298, 107, 25 );
  cancelPushButton->setMinimumSize( 0, 25 );
  cancelPushButton->setMaximumSize( 32767, 25 );
  connect( cancelPushButton, SIGNAL(clicked()), SLOT(cancelClicked()) );
  cancelPushButton->setFocusPolicy( QWidget::TabFocus );
  cancelPushButton->setBackgroundMode( QWidget::PaletteBackground );
//  cancelPushButton->setFontPropagation( QWidget::NoChildren );
//  cancelPushButton->setPalettePropagation( QWidget::NoChildren );
  cancelPushButton->setText( "Cancel" );
  cancelPushButton->setAutoRepeat( FALSE );
  cancelPushButton->setAutoResize( FALSE );
  cancelPushButton->setToggleButton( FALSE );
  cancelPushButton->setDefault( FALSE );
  cancelPushButton->setAutoDefault( FALSE );
  cancelPushButton->setIsMenuButton( FALSE );
  QBoxLayout* slantLayout = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, NULL );
  slantLayout->addStrut( 0 );
  slantLayout->addWidget( canvas, 1, 0 );
  slantLayout->addWidget( slider, 1, 0 );
  QBoxLayout* slantLayout_3 = new QBoxLayout( QBoxLayout::LeftToRight, 5, NULL );
  slantLayout->addLayout( slantLayout_3, 1 );
  slantLayout_3->addStrut( 0 );
  slantLayout_3->addWidget( slantEdit, 1, 36 );
  slantLayout_3->addWidget( okPushButton, 1, 36 );
  slantLayout_3->addWidget( cancelPushButton, 1, 36 );
  resize( 340,330 );
  setMinimumSize( 0, 0 );
  setMaximumSize( 32767, 32767 );
  canvas->createImage(sstvparam.numberOfPixels,sstvparam.numberOfLines,32,sstvparam.numberOfPixels,sstvparam.numberOfLines);
  sprintf(temp,"%4.4f",fRXsamplingrate);
  slantEdit->setText(temp);
  newSamplingrate=fRXsamplingrate;
}


slantAdjust::~slantAdjust()
{

}

void slantAdjust::valueChanged(int pix)
{
  float lttemp;
  float timePerPixel;
  //calculate pixelTime
  restoreOriginal();
  lttemp=lineTimeTable[1]-lineTimeTable[0]
    -sstvparam.hs.t -sstvparam.bp.t-sstvparam.f1.t 
    -sstvparam.f2.t-sstvparam.f3.t -sstvparam.f4.t-sstvparam.f5.t-sstvparam.fp.t;
  
  timePerPixel=lttemp/((float)sstvparam.numberOfPixels*3.);
  switch(sstvparam.colorScheme)
    {
    case GBR:
    case GBR2:
      { 
	timePerPixel=lttemp/((float)sstvparam.numberOfPixels*3.); 
      }
      break;
    case RGB:
      {
	timePerPixel=lttemp/((float)sstvparam.numberOfPixels*2.); 
      }
      break;
    case XYZOE:
      {
	timePerPixel=2*lttemp/((float)sstvparam.numberOfPixels*3.); 
	
      }
      break;
    case XYZOE2:
      {
	timePerPixel=lttemp/((float)sstvparam.numberOfPixels*2.); 
      }
      break;
    }
  newTime=sstvparam.imageTime+(float)pix*timePerPixel;
  newSamplingrate=fRXsamplingrate*(sstvparam.imageTime/newTime);
  sprintf(temp,"%4.4f",newSamplingrate);
  slantEdit->setText(temp);
  im=new QImage();
  *im=*pmSave;
   for (int i=0;i<sstvparam.numberOfLines;i++)
    {
      pdst=(char *)canvas->getLineAddress(i);
      psrc=(char *)im->scanLine(i);
      if(psrc==NULL)
				{
	  			qsstvDebug("psrc NULL");
				}
      if(pdst==NULL)
				{
	  			qsstvDebug("pdst NULL");
				}
      if (pix>=0)
	{
	  shift=(((int)((pix*i*10)/(sstvparam.numberOfLines-1))+5)/10)*sizeof(uint);
	  memmove(pdst+shift,psrc,sstvparam.numberOfPixels*sizeof(uint)-shift);
	  memmove(pdst,psrc+(sstvparam.numberOfPixels-1)*sizeof(uint)-shift,shift);
	}
      else
	{ 
	  shift=(((int)((pix*i*10)/(sstvparam.numberOfLines-1))-5)/10)*sizeof(uint);
     	  memmove(pdst,psrc-shift,sstvparam.numberOfPixels*sizeof(uint)+shift);
	  memmove(pdst+((int)(sstvparam.numberOfPixels-1))*sizeof(uint)+shift,psrc,-shift);
	}
    }
   
   canvas->imageToPixmap(); 
   canvas->fullDrawContents();
}


void slantAdjust::okClicked()
{
  fRXsamplingrate= newSamplingrate;
  configFile.setOption("RXSamplingRate",fRXsamplingrate);
  fTXsamplingrate= newSamplingrate;
  configFile.setOption("TXSamplingRate",fTXsamplingrate);
  accept();
}

void slantAdjust::cancelClicked()
{
   reject();
}

void slantAdjust::restoreOriginal()
{
	if (pmSave)
		{
  		canvas->copyPixmap(*pmSave);
		}
}

void slantAdjust::transferImage(QPixmap *ipm)
{
  pmSave=ipm;
  restoreOriginal();
  canvas->repaint(FALSE);
}




