/***************************************************************************
                          debugger.cpp  -  qsstv debugger
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Johan Maes
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "debugger.h"
#include <qglobal.h>
#include <qfiledialog.h>

const char *stateString[NUMSTATES]={"P0  ","P1  ","P2  ","P3  ","P4  ",
				    "P5  ","P6  ","P7  ","P8  ","P9  ",
				    "PA  ","PB  ","PC  ","PD  ","PE  ",
				    "NXTR","NXTZ","NXZ2","STPI","HUNT",
				    "F19A","VSTA","VDAT","VSTP",
				    "SCWS","SDCW","SCWN",
				    "ABTX","F19B","F12A","F12B","ENTX","REPT"};
const char *faxStateString[NUMFAXSTATES]= {"FXIDL","FXFRC","FXSTB","FXSTW",
								"FXSTA","FXTO1","FXTO2","FXTO3","FXTO4","FXIMA","FXSTO","FXEND"};

debugger::debugger()
{
	dinput=new QFile();
	doutput=new QFile();
}

debugger::~debugger()
{
	stop();
}

void debugger::stop()
{
	dinput->close();
	doutput->close();
}

void debugger::rewind(uint len)
{
	 doutput->at(doutput->at()-len*sizeof(sdebug));
}

bool debugger::openForRead(QString fileName)
{
	QFileInfo finfo(fileName);
	QString t=finfo.baseName()+".dmp";
	finfo.setFile(finfo.dir(TRUE),t);
	dinput->setName(finfo.filePath());
	return(dinput->open(IO_Raw|IO_ReadOnly)); 	
}

unsigned int debugger::numberOfEntries()
{
	return dinput->size()/sizeof(sdebug);
}

bool debugger::openForWrite(QString fileName,const char *s)
{
	QFileInfo finfo(fileName);
	QString t=finfo.baseName()+s;
	finfo.setFile(finfo.dir(TRUE),t);
	doutput->setName(finfo.filePath());
	return(doutput->open(IO_Raw|IO_WriteOnly|IO_Truncate));
}

int  debugger::save()
{
	return(doutput->writeBlock((char *)&debugFields,sizeof(sdebug)));
}

int debugger::read()
{
	return(dinput->readBlock((char *)&debugFields,sizeof(sdebug)));
}
