// details.h				emacs, this is written in -*-c++-*-
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef DETAILS_H
#define DETAILS_H

#include "config.h"

#include <qtabbar.h>
#include <qintdict.h>

#include "htable.h"
#include "proc.h"
#include "lookup.h"

// abstract interface class for clients to the details window
class Pane
{
public:
    Pane(QWidget *qw) : w(qw) {};
    virtual void config_change();
    virtual void refresh() = 0;
    QWidget *asQWidget() { return w; };

private:
    QWidget *w;			// myself as QWidget (alas!)
};

class Qps;

class Details : public QWidget
{
    Q_OBJECT
public:
    Details(Procinfo *p, Qps *qps, Proc *proc);
    ~Details();

    void refresh();
    void config_change();
    void process_gone();
    Procinfo *procinfo() { return pi; };
    Proc *proc() { return pr; };
    void set_procinfo(Procinfo *p) { pi = p; };

signals:
    void closed(Details *);

public slots:
    void dismiss();
    void tab_change(int id);

protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void resizeEvent(QResizeEvent *);
    virtual void closeEvent(QCloseEvent *);
    
    void addPane(Pane *pane, const char *label);

private:
    static const int top_spc = 8;	// above tab bar
    static const int mid_spc = 4;	// between tab bar and pane
    static const int left_spc = 8;	// to the left of tab bar

    QTabBar *tbar;

    Svec<Pane *> panes;		// vector index == QTabBar id
    Procinfo *pi;
    Proc *pr;
};

struct TableField
{
    const char *name;
    int width;
    int gap;
    int align;
    const char *tooltip;
};

// SimpleTable: a HeadedTable with fixed number of columns

class SimpleTable : public HeadedTable
{
    Q_OBJECT
public:
    SimpleTable(QWidget *parent, int nfields, TableField *f, int options = 0);

protected:
    virtual QString title(int col);
    virtual QString text(int row, int col) = 0;
    virtual int colWidth(int col);
    virtual int alignment(int col);
    virtual int leftGap(int col);
    virtual QString tipText(int col);

private:
    const TableField *fields;
};

class Sockets : public SimpleTable, public Pane
{
    Q_OBJECT
public:
    Sockets(QWidget *parent);
    ~Sockets();

    void refresh();
    void refresh_window();
    bool refresh_sockets();
    const char *servname(unsigned port);
    QString ipAddr(unsigned addr);
    QString hostname(unsigned addr);
    void config_change();

public slots:
    void update_hostname(unsigned addr);

protected:
    virtual QString text(int row, int col);

private:
    Procinfo *procinfo() { return ((Details *)parent())->procinfo(); };

    enum {
	FD, PROTO, RECVQ, SENDQ, LOCALADDR, LOCALPORT, REMOTEADDR, REMOTEPORT,
	STATE,
	SOCKFIELDS
    };
    static TableField fields[SOCKFIELDS];

    bool doing_lookup;		// if table painted with host lookup

    static Lookup *lookup;
    static bool have_services;	// true if we have tried reading services
    static QIntDict<char> servdict;
};

class Maps : public SimpleTable, public Pane
{
public:
    Maps(QWidget *parent);
    ~Maps();

    void refresh();
    void refresh_window();
    bool refresh_maps();

protected:
    virtual QString text(int row, int col);

private:
    Procinfo *procinfo() { return ((Details *)parent())->procinfo(); };

    enum {
	ADDRESS, SIZE, PERM, OFFSET, DEVICE, INODE, FILENAME,
	MAPSFIELDS
    };
    static TableField fields[MAPSFIELDS];
};

class Files : public SimpleTable, public Pane
{
public:
    Files(QWidget *parent);
    ~Files();

    void refresh();
    void refresh_window();
    bool refresh_fds();

protected:
    virtual QString text(int row, int col);

private:
    Procinfo *procinfo() { return ((Details *)parent())->procinfo(); };

    enum {
	FILEDESC,
#ifdef LINUX
	FILEMODE,
#endif
	FILENAME,
	FILEFIELDS
    };
    static TableField fields[FILEFIELDS];
};

class Environ : public SimpleTable, public Pane
{
    Q_OBJECT
public:
    Environ(QWidget *parent);
    ~Environ();

    void refresh();
    void refresh_window();
    bool refresh_environ();

public slots:
    void sort_change(int);

protected:
    virtual QString text(int row, int col);

    void sort();
    static int compare(const NameValue *a, const NameValue *b);

private:
    Procinfo *procinfo() { return ((Details *)parent())->procinfo(); };
    enum {
	ENVNAME, ENVVALUE,
	ENVFIELDS
    };
    bool rev;			// sorting reversed
    static Environ *static_env;	// for sorting, must have static pointer
    static TableField fields[ENVFIELDS];
};

class AllFields : public SimpleTable, public Pane
{
public:
    AllFields(QWidget *parent);
    ~AllFields();

    void refresh();
    void refresh_window();

protected:
    virtual QString text(int row, int col);

private:
    Procinfo *procinfo() { return ((Details *)parent())->procinfo(); };
    enum {
	FIELDNAME, FIELDDESC, FIELDVALUE,
	FIELDSFIELDS
    };
    static TableField fields[FIELDSFIELDS];
};

#endif	// DETAILS_H
