// ttystr.h
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#ifndef TTYSTR_H
#define TTYSTR_H

#include "config.h"

#ifdef LINUX
#include <sys/sysmacros.h>
#endif
#include <qstring.h>
#ifdef SOLARIS
#include <qintdict.h>
#endif

class Ttystr {
public:
    static QString name(int devnr);

#ifdef SOLARIS
private:
    static void read_devs();
    static void scandevdir(const char *prefix);

    static QIntDict<char> dict;
    static bool scanned;
#endif
};

#endif	// TTYSTR_H
