/* *************************************************************************
  Module:        errors.c
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000
  Description:
                 Error messages for pup.

  Changes:

****************************************************************************
                 COPYRIGHT (C) 2000 Matt Simpson
                 GNU General Public License
                 See lexgui.c for full notice.
**************************************************************************** */
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <string.h> /* for strerror() */
#include "lexgui.h"

/* -------------------------------------------------------------------------
        explain_CB() I've always thought error messages were too
                     cryptic. In the spirit of this, I've included
                     further explanation for those that want it,
                     at the exact spot they would want it in (a
                     novel idea?) I am assumming the user has at
                     least some Unix experience, like how to check
                     permissions and do a chmod.
   ------------------------------------------------------------------------- */
void explain_CB(GtkWidget *widget, msgbox_struct *msgbox)
{
  GtkWidget *fixedcon, *label;
  static gchar message[2048]; /* bump these up if a longer message is used*/
  static gchar sysmessage[150];
  static gchar fmessage[1200];
  extern gchar *output;
  extern int open_file_errno;

  /* In case it already exists. Note when destroyed, it must be set to NULL */
  if(GTK_IS_WIDGET(msgbox->explain_dialog))
    return; 

  msgbox->explain_dialog = gtk_dialog_new ();
  gtk_window_set_title(GTK_WINDOW(msgbox->explain_dialog), "Explanation");
  gtk_window_set_position(GTK_WINDOW(msgbox->explain_dialog), 
                          GTK_WIN_POS_MOUSE);

  fixedcon = gtk_fixed_new();
  gtk_container_border_width(GTK_CONTAINER(fixedcon), 10);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (msgbox->explain_dialog)->vbox),
                      fixedcon, TRUE, TRUE, 5);
  set_color(&fixedcon, BEIGE, BG, NORMAL);
  gtk_widget_show(fixedcon);

  /* strerror() returns the system error message */
  sprintf(sysmessage, "System returned error: %s.\n\n", 
          strerror(open_file_errno));

  /* fmessage is shared */
  sprintf(fmessage,
        "Unable to open output '%s'. \n"
        "%s"
        "If the system returned error is 'Permission "
        "denied' or 'Device not configured' and "
        "the output is a device, check for its "
        "existence (e.g. 'ls /dev/lp0') and make "  
        "sure the correct device is used (e.g. lp0, "
        "lp1, etc). Also make sure the printer is "
        "hooked up to the correct port for this device.\n\n"
        "If the error is 'Input/output error' or 'Interrupted "
        "system call', make sure the printer has power and "
        "it is connected to the output you specified. If "
        "connected through a switchbox, make sure the switch "
        "is on the correct setting.\n\n"
        "If the error is 'Resource busy', "
        "the device may already be open from another "
        "process, such as a separate print job or "
        "a previous Pup command not being finished. "
        "Try again to see if the resource has become "
        "available. Check your print queue. If a job is "
        "listed, it is still downloading to the printer; "
        "the device cannot be opened until the queue is "
        "empty.\n\n", output, sysmessage);
  switch(msgbox->explain)
  {
    case 1: /* Open output file or device failure */
      sprintf(message, "%s"
        "If the output is a file, make sure "
        "you have the correct permissions to write to "
        "this file and the specified directory.\n\n"
        "Click the 'Output' box and change the text. "
        "Pup's menu selections will become available "
        "again.\n", fmessage);
      break;
    case 2: /* Open device failure */
      sprintf(message, "%s", fmessage);
      break;
    case 3: /* Error reading device. */
      sprintf(message, 
              "Error reading device. \n"
               "%s"
              "The device was opened but could not be read. "
              "For Linux, you must have a kernel compiled with "
              "CONFIG_PRINTER_READBACK = y. If not, the system "
              "returned error may say 'Invalid argument'.\n\n"
              "For other platforms such as SGI you may have to " 
              "configure it for bi-directional communication. Try "
              "doing a man on the device, or consult the platform " 
              "specific documentation. Email me (matthewsimpson@home.com) "
              "once you figure this out so I can document the procedure.\n\n"
              "Other things to check:\n"
              "Did the printer suddenly lose power? Was the printer "
              "cable disconnected? Was a switchbox switch flipped?",
              sysmessage);
      break;
    case 4: /* start read timeout */
      sprintf(message, 
              "Timeout. Could not start. \n\n"
              "This occurrs after the device is opened but after "
              "waiting %d seconds Pup could not find an expected "
              "start test string which was sent when you pressed "
              "the query button. Perhaps your device is not "
              "configured for bi-directional communication. \n\n"
              "For Linux, you must have a kernel compiled with "
              "CONFIG_PRINTER_READBACK = y.\n\n" 
              "If you do not have bi-directional communication "
              "configured, you may use Pup's output-only commands "
              "such as the 'Print the menu settings page' to view "
              "some of the printer's settings.\n\n"
              "If you recently submitted a print job and it finishes "
              "downloading to your printer (i.e. the print queue "
              "is empty), there is a period where the printer is "
              "interpreting the PostScript code and is not available "
              "for status readback. This happens before the printer "
              "starts printing. If this is the case, try again to "
              "see if readback becomes available.\n\n" 
              "Other things to check:\n"
              "Pup queries using PJL commands. Is your printer "
              "compatible with PJL? Was a switchbox switch flipped "
              "to a non PJL printer?", QUERY_TIMEOUT);
      break;
    case 5: /* close device failure */
      sprintf(message,
              "Error closing device. \n"
              "%s"
              "Beats me. I never had this error so "
              "don't know what to suggest.", sysmessage);
      break;
    case 6: /* end read timeout */
      sprintf(message,
              "Timeout. Could not finish. \n\n"
              "This occurrs after the device is opened and "
              "after reading some of the data but Pup could "
              "never find an expected end test string which "
              "was sent when you pressed the query button. "
              "Whenever Pup stops seeing data it waits up to "
              "%d seconds either for more data or for the "
              "expected end test string. The partial data it "
              "did read is displayed in the text window. It "
              "would seem your printer hung up for some reason "
              "or is so slow that %d seconds is not enough.\n\n"
              "Note there is a possibility of garbage characters "
              "(although most are filtered out) or an incomplete "
              "string appearing on the last line. This would "
              "happen if the failure occurred on a moment the "
              "device was being read. This will not adversely "
              "affect Pup, however.",
              QUERY_TIMEOUT, QUERY_TIMEOUT);
      break;
    case 7: /* memory allocation error */
      sprintf(message,
              "Error: Cannot Initialize Memory. \n\n"
              "Pup received an error when it tried to "
              "initially allocate some memory for "
              "storing the query results. Because this "
              "initial amount is relatively small, the "
              "probability of this error occurring is "
              "rare. For Linux, do a cat on /proc/meminfo "
              "to see how much memory you are using. "
              "Look at your swap space usage as well. "
              "Perhaps you should add more memory "
              "or swap space.");
      break;
    case 8:
      sprintf(message,
              "Error: Cannot Allocate Memory. \n\n"
              "Pup received an error when it tried to "
              "reallocate more memory for storing more "
              "query results. Note this memory is re-used "
              "so subsequent queries will not keep allocating "
              "more unless it is necessary. \n\n"
              "Either you just ran out of swap space or "
              "Pup is reading an awlful lot of data from "
              "the printer, e.g. the read is caught in "
              "an infinite loop. For Linux, do "
              "a cat on /dev/lp0 (or whatever your output "
              "device is set to). This will flush whatever "
              "is remaining of what Pup was reading and "
              "display it in the shell. Note the things "
              "being displayed should be normal strings. \n\n"
              "Also for Linux, do a cat on /proc/meminfo "
              "to see how much memory and swap space you "
              "are using.");
      break;
    case 9:
      sprintf(message,
              "Error: Cannot build list -- Output not a device.\n\n"
              "To build a dynamic list of choices, Pup needs to "
              "query the printer. Pup can only query a device "
              "and not a network (for now) or a file. If this "
              "is not an option for you, try the (more limited) "
              "fixed choices menu item. But be aware the fixed "
              "choices are printer dependent.");
      break;
    case 10:
      sprintf(message,
              "Error: Cannot Allocate Memory. \n\n"
              "Pup received an error when it tried to "
              "allocate or reallocate memory for storing choices. "
              "Try Pup's Query Printer Settings command, which "
              "shows everything being read from the printer without "
              "using the extra memory needed for setting up dynamic "
              "choices. The query should yield normal text and not "
              "be excessive. If it also gives a memory allocation error, "
              "read that explanation for more info. Also check your "
              "swap space.");
      break;
    case 11:
      /* This error should never occur. */
      sprintf(message,
              "Error: $HOME not defined.\n\n"
              "This is set by your shell and should be your home "
              "directory. Try a different shell.\n"); 
      break;
    case 12:
      sprintf(message,
        "Unable to open $HOME/.puprc\n"
        "%s\n", sysmessage);
      break;
    case 13:
      sprintf(message,
        "Printing the configuration page through PJL is not available "
        "for the HP 4000 and LJ4 series printers. However, you may "
        "generate this page through the printer's control panel.\n"
        "\n"
        "On the 4000, access the Information Menu on the control panel, "
        "then select Menu Map. On the LJ4, select Test Menu, then Self "
        "Test. A page will print showing most of the printer's current "
        "settings which you can verify after you use Pup to change "
        "desired settings. This page shows all settings listed in Pup's "
        "fixed choices window. On the 4000, however, Pup also gives "
        "LANGUAGE as a choice which does not show on the printed menu page.\n"
        "\n"
        "Note if you had printer readback available on your computer "
        "you could use Pup's dynamic settings page which will offer "
        "more choices for this printer ;o)");
      break;
    default:
      sprintf(message, "%s", " ");
  }
  label = gtk_label_new (message);
  gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_FILL);
  gtk_container_add(GTK_CONTAINER(fixedcon), label);
  gtk_widget_show (label);
  close_ibutton(&(GTK_DIALOG(msgbox->explain_dialog)->action_area), 
                &(msgbox->explain_dialog));
  /* For the X delete */
  gtk_signal_connect(GTK_OBJECT(msgbox->explain_dialog), "delete_event",
                     GTK_SIGNAL_FUNC(close_iwindowX),
                     (gpointer)&(msgbox->explain_dialog));
  gtk_widget_show(msgbox->explain_dialog);
}
/* -------------------------------------------------------------------------
        pop_pref_note() Popup window with predefined dialog message.
   ------------------------------------------------------------------------- */
void pop_pref_note(gint mnum)
{
  static GtkWidget *dialog;
  GtkWidget *fixedcon, *vbox, *hbox, *label, *okbox, *okbutton;
  extern int open_file_errno;
  static gchar sysmessage[150];
  static gchar message0[] = 
    {
      "Warning: Cannot look for preferences file. "
      "$HOME not defined. Default settings used instead.\n"
    };
  static gchar message1[] =
    {
      "Warning: Cannot read preferences file. "
      "Default settings used instead.\n\n"
    };
  static gchar message2[] =
    {
      "Warning: Unfamiliar with printer model listed in $HOME/.puprc. "
      "Default setting used instead.\n\n"
    };

  dialog = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_title(GTK_WINDOW(dialog), "Pup Warning");

  fixedcon = gtk_fixed_new();
  gtk_container_border_width(GTK_CONTAINER(fixedcon), 10);
  gtk_container_add(GTK_CONTAINER(dialog), fixedcon);
  set_color(&fixedcon, BEIGE, BG, NORMAL);
  gtk_widget_show(fixedcon);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(fixedcon), vbox);
  gtk_widget_show(vbox);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);

  label = gtk_label_new("");
  gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_FILL);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  switch(mnum)
  {
    case 0:
      gtk_label_set_text(GTK_LABEL(label), message0);
      break;
    case 1:
      gtk_label_set_text(GTK_LABEL(label), message1);
      hbox = gtk_hbox_new(FALSE, 0);
      gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
      gtk_widget_show(hbox);

      label = gtk_label_new("");
      gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
      gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_FILL);
      gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

      sprintf(sysmessage, "System returned error:\n%s.\n",
              strerror(open_file_errno));
      gtk_label_set_text(GTK_LABEL(label), sysmessage);
      gtk_widget_show(label);
      break;
    case 2:
      gtk_label_set_text(GTK_LABEL(label), message2);
      break;
  }
  
  okbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_end(GTK_BOX(vbox), okbox, FALSE, FALSE, 6);
  gtk_widget_show(okbox);

  okbutton = gtk_button_new_with_label("Okay");
  gtk_box_pack_start(GTK_BOX(okbox), okbutton, TRUE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT (okbutton), "clicked",
                     GTK_SIGNAL_FUNC(close_iwindow), (gpointer)&dialog);
  gtk_widget_show(okbutton);

  /* For the X delete */
  gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                     GTK_SIGNAL_FUNC(close_iwindowX), (gpointer)&dialog);

  gtk_widget_show(dialog);
}
