#ifndef AVATARS_H
#define AVATARS_H

#include <qpixmap.h>
#include <qstring.h>

#include "xmpp.h"

using namespace XMPP;

class PsiAccount;
class Avatar;
class VCardAvatar;
class FileAvatar;
class ClientAvatar;

//------------------------------------------------------------------------------

class AvatarFactory : public QObject
{
	Q_OBJECT

public:
	AvatarFactory(PsiAccount* pa);

	QPixmap getAvatar(const Jid& jid, const QString& client);
	PsiAccount* account() const
		{ return pa_; }
	QPixmap getSelfAvatar();

	void importManualAvatar(const Jid& j, const QString& fileName);
	void removeManualAvatar(const Jid& j);
	bool hasManualAvatar(const Jid& j);

	static QString getAvatarsDir();
	static QString getManualDir();

signals:
	void avatarChanged(const Jid&);

public slots:
	void updateAvatar(const Jid&);

protected:
	Avatar* retrieveAvatar(const Jid& jid, const QString& resource);

private:
	QMap<QString,Avatar*> active_avatars_;
	QMap<QString,FileAvatar*> file_avatars_;
	QMap<QString,ClientAvatar*> client_avatars_;
	QMap<QString,VCardAvatar*> vcard_avatars_;
	PsiAccount* pa_;
};

//------------------------------------------------------------------------------

class Avatar
{
public:
	Avatar();
	virtual ~Avatar();
	virtual QPixmap getPixmap()
		{ return pixmap(); }
	virtual bool isEmpty()
		{ return getPixmap().isNull(); }
	static int maxSize();

protected:
	virtual const QPixmap& pixmap() const 
		{ return pixmap_; }

	virtual void setImage(const QImage&);
	virtual void setImage(const QByteArray&);
	virtual void setImage(const QPixmap&);
	virtual void resetImage();

private:
	QPixmap pixmap_;
};


#endif
