# $Id: ViewAttachment.pm,v 1.2 2001/02/03 16:22:54 muhri Exp $
# -*- perl -*-
package Pronto::ViewAttachment;
use strict;
use SelfLoader;
1;
__DATA__
sub view_attachment {
  	my ($widget, $source, $type, $use_db) = @_;
  	my($window,$vbox,$type_entry,$command_entry,$icon_entry,$button,$button2,$hbox,$label,$sql,$query,@row,@command);
  	if($use_db eq 'y') {
  		$sql = "select id,mime,command,icon from mimetypes where mime=?";
  		$query = $main::conn->prepare($sql);
  		$query->execute($type);
  		if(@row=$query->fetchrow_array) {
    			@command = split(/ /,$row[2]); 
			if(-f $command[0]) {
				my $child;
				$row[2] =~ s/\%f/\"$source\"/g;
        			unless ($child = fork) {
  					die "cannot fork: $~" unless defined $child;
       					exec($row[2]);
        			}
			}
		else {
			&main::err_dialog(_("You must specify an executalbe that exists for "). $row[1]);
		}
		return 1;
  	}
  }
  	$window = new Gtk::Window("toplevel");
  	$window->set_position("mouse");
  	$window->set_title(_("View Attachment"));
  	$window->set_default_size('130','80');
  	$window->signal_connect("destroy" => sub{$window->destroy;});
  	$window->signal_connect("delete_event" => \&Gtk::false);
  	$vbox = new Gtk::VBox(1,1);
  	$window->add($vbox);
  	$vbox->show;
  	$hbox = new Gtk::HBox(0,0);
  	$vbox->pack_start($hbox,0,0,0);
  	$hbox->show;
  	$label = new Gtk::Label(_("Mime-Type:"));
  	$hbox->pack_start($label,0,0,0);
  	$label->show;
  	$type_entry = new Gtk::Entry();
       	$type_entry->set_text($type);
  	$hbox->pack_start($type_entry,0,0,0);
  	$type_entry->show;
       	$hbox = new Gtk::HBox(0,0);
  	$vbox->pack_start($hbox,0,0,0);
  	$hbox->show;
  	$label = new Gtk::Label(_("Command:"));
  	$hbox->pack_start($label,0,0,0);
  	$label->show;
  	$command_entry = new Gtk::Entry();
  	$hbox->pack_start($command_entry,0,0,0);
  	$command_entry->show;
  	$button=new Gtk::Button(_("Browse"));
  	$button->signal_connect("clicked" => \&init_browse_dlg, $command_entry, "attachment_command");
  	$button->set_usize(55,25);
  	$hbox->pack_start($button,0,0,0);
  	$button->show;
  	if($use_db eq 'y') {
  		$hbox = new Gtk::HBox(0,0);
  		$vbox->pack_start($hbox,0,0,0);
		$hbox->show;
        	$label = new Gtk::Label(_("Icon:"));
        	$hbox->pack_start($label,0,0,0);
        	$label->show;
       	 	$icon_entry = new Gtk::Entry();
        	$hbox->pack_start($icon_entry,0,0,0);
        	$icon_entry->show;
        	$button=new Gtk::Button(_("Browse"));
        	$button->signal_connect("clicked" => \&init_browse_dlg, $icon_entry, "attachment_icon");
        	$button->set_usize(55,25);
               	$hbox->pack_start($button,0,0,0);
  		$button->show;
  	}
  	$button = new Gtk::Button(_("Execute"));
  	$button->signal_connect('clicked' =>
        				sub {
	      				my $command = $command_entry->get_text();
	      				@command = split(/ /,$command);
              				if(-f $command[0]) {
						if($use_db eq 'y') {
						my $id = &main::newid("mimetypes",$main::conn);
						$sql = "insert into mimetypes (id,mime,command,icon)
							values (?,?,?,?)";
						$query = $main::conn->prepare($sql);
						$query->execute($id,$type,$command_entry->get_text(),$icon_entry->get_text());
						}
	               			$command =~ s/\%f/$source/g;
					my $child;
	               			unless ($child = fork) {
	                       			die "cannot fork: $~" unless defined $child;
	                       			exec("$command");
	               			}
	               			$window->destroy;
					}
        				});
  	$vbox->pack_start($button,0,0,0);
  	$button->show;
  	$window->show;
  	return 1;
}


sub init_browse_dlg {
	my ($widget, $entry, $dlg_type) = @_;
	my ($fs_window);
	$fs_window = new Gtk::FileSelection _("Choose Directory...");
	$fs_window->position(-mouse);
	$fs_window->signal_connect("destroy", sub {$fs_window->destroy;});
	$fs_window->signal_connect("delete_event" => \&Gtk::false);
	if($dlg_type eq "attachment_command") {
		$fs_window->set_title(_("Select Viewer ..."));
		$fs_window->ok_button->signal_connect("clicked", \&check_view_attachment, $fs_window, $entry);
	}elsif($dlg_type eq "attachment_icon") {
                $fs_window->set_title(_("Select Icon ..."));
                $fs_window->ok_button->signal_connect("clicked", \&check_icon_attachment, $fs_window, $entry);
      	}
	$fs_window->cancel_button->signal_connect("clicked", sub {$fs_window->destroy;});
	$fs_window->show;
	return 1;
}

sub check_view_attachment {
        my ($widget, $fs_window, $entry) = @_;
        if (-f $fs_window->get_filename) {
                $entry->set_text($fs_window->get_filename . " \%f");
                $fs_window->destroy;
                return 1;
        } else {
                &main::err_dialog(_("You must select a Viewer"));
                return 1;
        }
}

sub check_icon_attachment {
        my ($widget, $fs_window, $entry) = @_;
        if ((-f $fs_window->get_filename) && ($fs_window->get_filename =~ /(bmp|gif|jpg|jpeg|png)$/i)) {
                $entry->set_text($fs_window->get_filename());
                $fs_window->destroy;
                return 1;
        } else {
                &main::err_dialog(_("You must select a Icon"));
                return 1;
        }
}
