/***************************************************************************
                          gui.h  -  description
                             -------------------
    begin                : Wed May 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_H
#define GUI_H

#include "prokyon.h"

#include "gui_selector.h"
#include "gui_sourcer.h"
#include "gui_listing.h"
#include "gui_taglisting.h"
#include "gui_playlist.h"

#include <qwidget.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qlabel.h>
#include <qtoolbar.h>
#include <qevent.h>
#include <qsplitter.h>

class GUI : public QMainWindow  {
  Q_OBJECT
    public: 
  GUI(QWidget *parent=0, const char *name=0);
  
  void notifyEstablishedConnection();
  void notifyLostConnection(); 

  GUI_Selector*   getSelector()   { return selector; }
  GUI_Sourcer*    getSourcer()    { return sourcer; }
  GUI_Listing*    getListing()    { return listing; }
  GUI_TagListing* getTagListing() { return taglisting; }
  GUI_Playlist*   getPlaylisting()   { return playlisting; }

  QToolBar* getSwitchBar() { return switchbar; }
						
  void setStatusInfo(QString message, int i);

  bool getConnectionState() { return connectionState; }  

  static QPixmap fadeOutIcon(QString file);
	
  ~GUI();

 public slots:
  void slot_WELCOME();

 protected:
 void GUI::closeEvent(QCloseEvent* e);

 private:
  void setConnectionState(bool);

  bool connectionState;

  GUI_Selector   *selector;
  GUI_Sourcer    *sourcer;
  GUI_Listing    *listing;
  GUI_TagListing *taglisting;
  GUI_Playlist   *playlisting;

  QToolBar *switchbar;
  
  QAction *action_disconnect, *action_connect, *action_createdb, *action_about, *action_welcome, *action_documentation;

  QLabel *status1, *status2, *status3, *status4, *status5, *labelpix;

  QAction *action_toggleleft, *action_togglebottom, *action_toggleright;

  QSplitter *hsplit, *vsplitr, *vsplitm, *vsplitl;
  
 private slots:
  void slot_connectToDB();
  void slot_disconnectFromDB();
  void slot_QUIT();
  void slot_PREF();
  void slot_CREATEDB();
  void slot_INITDB();
  void slot_ABOUT();
  void slot_DOCUMENTATION();
  void slot_toggleleft(bool);
  void slot_togglebottom(bool);
  void slot_toggleright(bool);
  void polish();
};

#endif
