#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "psgui.h"
#include "interface.h"
#include "support.h"
#include "prismstumbler.h"
#include "helpwindow.h"

#define MENU_ITEM_SCAN 1
#define MENU_ITEM_DUMP 2
#define MENU_ITEM_CONNECT 3
#define MENU_ITEM_TRACK 4
#define MENU_ITEM_JUMP 4

#define ICONFILE PREFIX "/share/pixmaps/prism-icon4.png"

GtkWidget *tree = NULL;
GtkTreeStore *store = NULL;

  GtkWidget *rbCSpecific;
  GtkWidget *eDevice;
#ifdef WLAN_NG  
  GtkWidget *rbDriverNG;
#endif  
  GtkWidget *rbDriverOR;
  GtkWidget *rbDriverHA;
  GtkWidget *rbDriverSC;
  GtkWidget *cbDevice;
  GtkWidget *lpsum;
  GtkWidget *lpdata;
  GtkWidget *lpiiv;
  GtkWidget *llong;
  GtkWidget *llat;
  GtkWidget *notebook1;
  GtkWidget *eSChannel;
  GtkWidget *txLog;
  GtkWidget *lPosLong;
  GtkWidget *lPosLat;
  GtkWidget *lFix;
  GtkWidget *fMain;
  GtkWidget *gpbSignal;
  GtkWidget *gclDetail;
  GtkWidget *uiScan;
  GtkWidget *uiDump;
  GtkWidget *bScanner;
  GtkWidget *mMain;
  GtkWidget *miScan;
  GtkWidget *miDump;
  GtkWidget *miJumpTo;
  


static GtkItemFactoryEntry mMain_items[] = {
  { N_("/_File"),         NULL,         NULL,           0, "<Branch>" },
  { N_("/File/Load config"), "", on_preferences_load_from_clicked,    0, "<Item>"},
  { N_("/File/Save config as..."), "", on_preferences_save_as_clicked,    0, "<StockItem>", GTK_STOCK_SAVE_AS},
  { N_("/File/_Load default config"), "", on_preferences_load_clicked,    0, "<StockItem>", GTK_STOCK_OPEN},
  { N_("/File/_Save default config"), "", on_preferences_save_clicked,    0, "<StockItem>", GTK_STOCK_SAVE},
  { N_("/File/s1"), NULL , NULL,    0, "<Separator>"},
  { N_("/File/_Close"),  NULL, on_fMain_destroy,    0, "<StockItem>", GTK_STOCK_QUIT },
  { N_("/_Controls"),         NULL,         NULL,           0, "<Branch>" },
  { N_("/Controls/Scanner active"), "<Control> S", on_toggle_scanner_clicked,    MENU_ITEM_SCAN, "<CheckItem>"},
  { N_("/Controls/Dump active"), "<Control> D", on_dump_file_clicked,    MENU_ITEM_DUMP, "<CheckItem>"},
  { N_("/Controls/Try Connect"), "<Control> T", do_try_connect, MENU_ITEM_CONNECT, "<Item>"},
  { N_("/Controls/Track"), "<Control> R", do_track_net, MENU_ITEM_TRACK, "<Item>"},
  { N_("/Controls/s2"), NULL , NULL,    0, "<Separator>"},
  { N_("/Controls/Jump to active"), "<Control> S", on_toggle_jump_clicked,    MENU_ITEM_JUMP, "<CheckItem>"},
  { N_("/Controls/s3"), NULL , NULL,    0, "<Separator>"},
  { N_("/Controls/Preferences"), "<Control> P", on_preferences_clicked,    0, "<StockItem>", GTK_STOCK_PREFERENCES},
  { N_("/_Help"),         NULL,         NULL,           0, "<Branch>" },
  { N_("/_Help/Index"),   "F1",       ps_do_help,    0, "<StockItem>", GTK_STOCK_HELP },
  { N_("/_Help/About"),   NULL,       ps_do_about,    0, "<Item>" },
};

int mMain_items_count = sizeof(mMain_items) / sizeof(GtkItemFactoryEntry);

/* create menus from description */
GtkWidget *
create_mMain(GtkWidget  *window)
{
	GtkItemFactory *itemfactory;
	GtkAccelGroup *accelgroup;

	accelgroup = gtk_accel_group_new ();

	itemfactory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
                                       accelgroup);
	gtk_item_factory_create_items (itemfactory, mMain_items_count, 
		mMain_items, NULL);
	gtk_window_add_accel_group (GTK_WINDOW (window), accelgroup);

	miScan = gtk_item_factory_get_item_by_action(itemfactory,MENU_ITEM_SCAN);
	miDump = gtk_item_factory_get_item_by_action(itemfactory,MENU_ITEM_DUMP);
	miJumpTo = gtk_item_factory_get_item_by_action(itemfactory,MENU_ITEM_JUMP);
	return (gtk_item_factory_get_widget (itemfactory, "<main>"));
}


GtkWidget*
create_fMain (void)
{
  GtkWidget *vbox1;
  GtkWidget *vbox2;
  GtkWidget *scrolledwindow4;
  GtkWidget *label36;
  GtkWidget *label37;
  GtkWidget *table1;
  GtkWidget *label25;
  GtkWidget *label24;
  GtkWidget *label26;
  GtkWidget *label28;
  GtkWidget *label29;
  GtkWidget *label3;
  GtkWidget *scrolledwindow2;
  GtkWidget *viewport1;
  GtkWidget *vbox3;
  GtkWidget *cbNight;
  GSList *rgc_group = NULL;
  GtkWidget *rbCAll;
  GtkWidget *hbox2;
  GtkWidget *cbFakeAP;
  GtkWidget *hbox3;
  GtkWidget *label39;
  GtkWidget *label40;
  GtkWidget *hbox4;
  GSList *hbox4_group = NULL;
  GtkWidget *bStartScan;
  GtkWidget *label4;
  GtkWidget *vbox4;
  GtkWidget *scrolledwindow3;
  GtkWidget *label38;
  GtkWidget *sw, *tw;
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GtkWidget *toolbar;
  GtkWidget *lConfig, *lDetail;
	GtkStyle *astyle;
	GtkRcStyle *rc_style;
	static const GdkColor blue = { 0, 0, 0x0000, 0xFFFF };
	static const GdkColor white = { 0, 0xFFFF, 0xFFFF, 0xFFFF };
  int size_x, size_y;

  size_x = gdk_screen_width() / 2;
  size_y = gdk_screen_height() * 2 / 3;  
  if (size_x < 240) size_x = 240;
  if (size_y < 320) size_y = 320;

  /* main window */
  fMain = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (fMain), VERSIONSTR);
  gtk_window_set_default_size (GTK_WINDOW (fMain), size_x, size_y);
  gtk_window_set_policy (GTK_WINDOW (fMain), TRUE, TRUE, FALSE);
  gtk_window_set_icon_from_file(GTK_WINDOW(fMain),ICONFILE,NULL);
	
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (fMain), vbox1);
	
  /* main menu */
  mMain = create_mMain(fMain);  
  gtk_box_pack_start(GTK_BOX(vbox1),mMain, FALSE, TRUE, 0);

  /* main toolbar */
  toolbar = gtk_toolbar_new();
  gtk_toolbar_set_icon_size(GTK_TOOLBAR(toolbar),GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_toolbar_set_style(GTK_TOOLBAR(toolbar),GTK_TOOLBAR_ICONS);
  gtk_toolbar_set_orientation (GTK_TOOLBAR (toolbar),
			       GTK_ORIENTATION_HORIZONTAL);  
  gtk_box_pack_start(GTK_BOX(vbox1),toolbar, FALSE, TRUE, 0);
  
  tw = gtk_image_new_from_stock(GTK_STOCK_PREFERENCES,GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),_("Settings"),_("Settings"),
  	NULL,tw,(GtkSignalFunc)on_preferences_clicked,NULL);
  tw = gtk_image_new_from_stock(GTK_STOCK_JUMP_TO,GTK_ICON_SIZE_SMALL_TOOLBAR);
  uiDump = tw;
  gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),_("Dump to file"),_("Dump to file"),
  	NULL,tw,(GtkSignalFunc)on_dump_file_clicked,NULL);
  tw = gtk_image_new_from_file(PIC_SCANNER_OFF);
  uiScan = tw;
  bScanner = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),_("Toggle scanner"),
  	_("Toggle scanner"),NULL,tw,(GtkSignalFunc)on_toggle_scanner_clicked,NULL);
  gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
  gtk_toolbar_insert_stock(GTK_TOOLBAR(toolbar),GTK_STOCK_QUIT,_("Exit"),
  	NULL,(GtkSignalFunc)on_fMain_destroy,NULL,-1);
  

  notebook1 = gtk_notebook_new ();
  gtk_box_pack_start (GTK_BOX (vbox1), notebook1, TRUE, TRUE, 0);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (notebook1), FALSE);
  gtk_notebook_set_tab_hborder (GTK_NOTEBOOK (notebook1), 1);
  gtk_notebook_set_tab_vborder (GTK_NOTEBOOK (notebook1), 1);


// ------------

  sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
						GTK_POLICY_AUTOMATIC,
						GTK_POLICY_AUTOMATIC);
   gtk_container_add (GTK_CONTAINER (notebook1), sw);

  tw = gtk_label_new (_("Browser"));
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), 
  gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), tw);
  gtk_label_set_justify (GTK_LABEL (tw), GTK_JUSTIFY_LEFT);
  
	/* init tree storage stuff */
	store = gtk_tree_store_new (N_COLUMNS,
				    G_TYPE_OBJECT,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_INT,
				    G_TYPE_INT,
					G_TYPE_POINTER,
					G_TYPE_STRING,
				    G_TYPE_INT);
					
						
  tree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  gtk_tree_view_set_reorderable(GTK_TREE_VIEW(tree),FALSE);
  
		gtk_container_add (GTK_CONTAINER (sw), tree);
		  gtk_widget_show (tree);

		g_signal_connect (G_OBJECT (tree), "cursor-changed",
				  G_CALLBACK (tv_row_clicked), NULL);

/*  gtk_signal_connect (GTK_OBJECT (tree), "row-activated",
                      GTK_SIGNAL_FUNC (on_tree_select_row),
                      NULL);
*/		renderer = gtk_cell_renderer_pixbuf_new ();
		column = gtk_tree_view_column_new_with_attributes (_("IC"),
								   renderer,
								   "pixbuf",
								   COL_ICON,
								   "cell-background",
								   COL_COLOR,
								   NULL);
		gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);

		renderer = gtk_cell_renderer_text_new ();
		column = gtk_tree_view_column_new_with_attributes (_("Name"),
								   renderer,
								   "text",
								   COL_NAME,
								   "background",
								   COL_COLOR,
								   NULL);
		gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column),TRUE);
		gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);

		renderer = gtk_cell_renderer_text_new ();
		column = gtk_tree_view_column_new_with_attributes (_("C"),
								   renderer,
								   "text",
								   COL_CHANNEL,
								   "background",
								   COL_COLOR,
								   NULL);
		gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column),TRUE);
		gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);
		
		renderer = gtk_cell_renderer_text_new ();
		column = gtk_tree_view_column_new_with_attributes (_("Mac / BSSID"),
								   renderer,
								   "text",
								   COL_BINID,
								   "background",
								   COL_COLOR,
								   NULL);
		gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column),TRUE);
		gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);
		
		renderer = gtk_cell_renderer_text_new ();
		column = gtk_tree_view_column_new_with_attributes (_("Sig"),
								   renderer,
								   "text",
								   COL_SIGNAL,
								   "background",
								   COL_COLOR,
								   NULL);
		gtk_tree_view_column_set_resizable(GTK_TREE_VIEW_COLUMN(column),TRUE);
		gtk_tree_view_append_column (GTK_TREE_VIEW (tree), column);
// -------------


  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox2);

  scrolledwindow4 = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolledwindow4),GTK_SHADOW_IN);

  lDetail = gtk_label_new(NULL);
  gtk_misc_set_alignment(GTK_MISC(lDetail),0.0,0.5);
  gtk_label_set_markup(GTK_LABEL(lDetail),"<b>Network Details</b>");
  gtk_box_pack_start (GTK_BOX (vbox2), lDetail, FALSE, FALSE, 0);
  
  gtk_box_pack_start (GTK_BOX (vbox2), scrolledwindow4, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow4), 
  	GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  
  gclDetail = gtk_clist_new (2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow4), gclDetail);
  gtk_widget_set_usize (gclDetail, 224, 134);
  gtk_clist_set_column_width (GTK_CLIST (gclDetail), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (gclDetail), 1, 80);
  gtk_clist_column_titles_hide (GTK_CLIST (gclDetail));
  gtk_clist_set_shadow_type (GTK_CLIST (gclDetail), GTK_SHADOW_NONE);

  label36 = gtk_label_new (_("label36"));
  gtk_clist_set_column_widget (GTK_CLIST (gclDetail), 0, label36);

  label37 = gtk_label_new (_("label37"));
  gtk_clist_set_column_widget (GTK_CLIST (gclDetail), 1, label37);

  table1 = gtk_table_new (3, 4, FALSE);
  gtk_box_pack_start (GTK_BOX (vbox2), table1, TRUE, TRUE, 0);

  label25 = gtk_label_new (_("Packets total"));
  gtk_table_attach (GTK_TABLE (table1), label25, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label25), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label25), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label25), 3, 0);

  label24 = gtk_label_new (_("Packets data"));
  gtk_widget_show (label24);
  gtk_table_attach (GTK_TABLE (table1), label24, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label24), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label24), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label24), 3, 0);

  label26 = gtk_label_new (_("Packets IIV"));
  gtk_widget_show (label26);
  gtk_table_attach (GTK_TABLE (table1), label26, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label26), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label26), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label26), 3, 0);

  label28 = gtk_label_new (_("Longitude"));
  gtk_widget_show (label28);
  gtk_table_attach (GTK_TABLE (table1), label28, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label28), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label28), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label28), 3, 0);

  label29 = gtk_label_new (_("Latitude"));
  gtk_widget_show (label29);
  gtk_table_attach (GTK_TABLE (table1), label29, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label29), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label29), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label29), 3, 0);

  lpdata = gtk_label_new (_("0"));
  gtk_widget_show (lpdata);
  gtk_table_attach (GTK_TABLE (table1), lpdata, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lpdata), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lpdata), 1, 0.5);
  gtk_misc_set_padding (GTK_MISC (lpdata), 3, 0);

  lpiiv = gtk_label_new (_("0"));
  gtk_widget_show (lpiiv);
  gtk_table_attach (GTK_TABLE (table1), lpiiv, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lpiiv), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lpiiv), 1, 0.5);
  gtk_misc_set_padding (GTK_MISC (lpiiv), 3, 0);

  llong = gtk_label_new ("-");
  gtk_widget_show (llong);
  gtk_table_attach (GTK_TABLE (table1), llong, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (llong), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (llong), 1, 0.5);
  gtk_misc_set_padding (GTK_MISC (llong), 3, 0);

  llat = gtk_label_new ("-");
  gtk_widget_show (llat);
  gtk_table_attach (GTK_TABLE (table1), llat, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (llat), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (llat), 1, 0.5);
  gtk_misc_set_padding (GTK_MISC (llat), 3, 0);

  lpsum = gtk_label_new (_("0"));
  gtk_widget_show (lpsum);
  gtk_table_attach (GTK_TABLE (table1), lpsum, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lpsum), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lpsum), 1, 0.5);
  gtk_misc_set_padding (GTK_MISC (lpsum), 3, 0);

  label3 = gtk_label_new (_("Detail"));
  gtk_widget_show (label3);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label3);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_container_add (GTK_CONTAINER (notebook1), scrolledwindow2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_NEVER);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), viewport1);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (viewport1), vbox3);

  lConfig = gtk_label_new(NULL);
  gtk_misc_set_alignment(GTK_MISC(lConfig),0.0,0.5);
  gtk_label_set_markup(GTK_LABEL(lConfig),"<b>Scanner Controls</b>");
  gtk_box_pack_start (GTK_BOX (vbox3), lConfig, FALSE, FALSE, 0);

  cbNight = gtk_check_button_new_with_label (_("night design"));
  gtk_widget_show (cbNight);
  gtk_box_pack_start (GTK_BOX (vbox3), cbNight, FALSE, FALSE, 0);
  gtk_widget_set_usize (cbNight, 99, 24);

  rbCAll = gtk_radio_button_new_with_label (rgc_group, _("all channels"));
  rgc_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rbCAll));
  gtk_widget_show (rbCAll);
  gtk_box_pack_start (GTK_BOX (vbox3), rbCAll, FALSE, FALSE, 0);
  gtk_widget_set_usize (rbCAll, 93, 24);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rbCAll), TRUE);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox2, FALSE, FALSE, 0);

  rbCSpecific = gtk_radio_button_new_with_label (rgc_group, _("specific channel"));
  rgc_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rbCSpecific));
  gtk_widget_show (rbCSpecific);
  gtk_box_pack_start (GTK_BOX (hbox2), rbCSpecific, FALSE, FALSE, 0);
  gtk_widget_set_usize (rbCSpecific, -2, 16);

  eSChannel = gtk_spin_button_new_with_range(1.0,14.0,1);
  gtk_widget_show (eSChannel);
  gtk_box_pack_start (GTK_BOX (hbox2), eSChannel, FALSE, TRUE, 3);
  gtk_widget_set_usize (eSChannel, 30, 20);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(eSChannel),1.0);

  cbFakeAP = gtk_check_button_new_with_label (_("fake ap filter"));
  gtk_widget_show (cbFakeAP);
  gtk_box_pack_start (GTK_BOX (vbox3), cbFakeAP, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox3, FALSE, TRUE, 0);  
  
  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox3, FALSE, FALSE, 0);

  label39 = gtk_label_new (_("Capture\ndevice"));
  gtk_misc_set_padding (GTK_MISC (label39), 3, 0);
  gtk_widget_show (label39);
  gtk_box_pack_start (GTK_BOX (hbox3), label39, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label39), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (label39), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label39), 0, 0.1);
  gtk_misc_set_padding (GTK_MISC (label39), 3, 0);

  cbDevice = gtk_combo_new ();
  gtk_widget_set_size_request(cbDevice,60,-1);
  gtk_widget_show (cbDevice);
  gtk_box_pack_start (GTK_BOX (hbox3), cbDevice, FALSE, TRUE, 3);
  gtk_container_set_border_width (GTK_CONTAINER (cbDevice), 3);

  eDevice = GTK_COMBO (cbDevice)->entry;
  gtk_widget_show (eDevice);
  gtk_entry_set_editable (GTK_ENTRY (eDevice), FALSE);
  gtk_entry_set_text (GTK_ENTRY (eDevice), _("wlan0"));

  label40 = gtk_label_new (_("Driver type"));
  gtk_widget_show (label40);
  gtk_box_pack_start (GTK_BOX (vbox3), label40, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label40), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label40), 3, 3);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox4, FALSE, FALSE, 0);

  rbDriverOR = gtk_radio_button_new_with_label (hbox4_group, _("Orinoco"));
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rbDriverOR));
  
  gtk_widget_show (rbDriverOR);
  gtk_box_pack_start (GTK_BOX (hbox4), rbDriverOR, FALSE, FALSE, 1);

  rbDriverHA = gtk_radio_button_new_with_label (hbox4_group, _("HostAP"));
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rbDriverHA));

  gtk_widget_show (rbDriverHA);
  gtk_box_pack_start (GTK_BOX (hbox4), rbDriverHA, FALSE, FALSE, 1);

  rbDriverSC = gtk_radio_button_new_with_label (hbox4_group, _("Scan"));
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rbDriverSC));
  
  gtk_widget_show (rbDriverSC);
  gtk_box_pack_start (GTK_BOX (hbox4), rbDriverSC, FALSE, FALSE, 1);
  
  bStartScan = gtk_button_new_from_stock(GTK_STOCK_APPLY);
  
#ifdef WLAN_NG
  rbDriverNG = gtk_radio_button_new_with_label (hbox4_group, _("Wl. NG"));
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rbDriverNG));
  gtk_widget_show (rbDriverNG);
  gtk_box_pack_start (GTK_BOX (hbox4), rbDriverNG, FALSE, FALSE, 1);
#endif

  gtk_widget_show (bStartScan);
  gtk_box_pack_start (GTK_BOX (vbox3), bStartScan, FALSE, FALSE, 0);

  label4 = gtk_label_new (_("Control"));
  
  gtk_widget_show (label4);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label4);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);


  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox4);

  tw = gtk_label_new (NULL);
  gtk_label_set_markup(GTK_LABEL(tw),_("<b>GPS</b>"));
  gtk_widget_show (tw);
  gtk_label_set_justify (GTK_LABEL (tw), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tw), 0, 0.5);
  gtk_box_pack_start (GTK_BOX (vbox4), tw, FALSE, TRUE, 3);
  
  lPosLong = gtk_label_new (_("0.0"));
  gtk_widget_show (lPosLong);
  gtk_label_set_justify (GTK_LABEL (lPosLong), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lPosLong), 0, 0.5);
  gtk_box_pack_start (GTK_BOX (vbox4), lPosLong, FALSE, TRUE, 0);

  lPosLat = gtk_label_new (_("0.0"));
  gtk_widget_show (lPosLat);
  gtk_label_set_justify (GTK_LABEL (lPosLat), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lPosLat), 0, 0.5);
  gtk_box_pack_start (GTK_BOX (vbox4), lPosLat, FALSE, TRUE, 0);
  
  lFix = gtk_label_new (_("0.0"));
  gtk_widget_show (lFix);
  gtk_label_set_justify (GTK_LABEL (lFix), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lFix), 0, 0.5);
  gtk_box_pack_start (GTK_BOX (vbox4), lFix, FALSE, TRUE, 0);

  tw = gtk_label_new (NULL);
  gtk_label_set_markup(GTK_LABEL(tw),_("<b>Eventlog</b>"));
  gtk_widget_show (tw);
  gtk_label_set_justify (GTK_LABEL (tw), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (tw), 0, 0.5);
  gtk_box_pack_start (GTK_BOX (vbox4), tw, FALSE, TRUE, 3);
  
  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolledwindow3),GTK_SHADOW_IN);
  gtk_widget_show (scrolledwindow3);
  gtk_box_pack_start (GTK_BOX (vbox4), scrolledwindow3, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  
  txLog = gtk_text_view_new ();
  gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(txLog),GTK_WRAP_WORD);
  gtk_widget_show (txLog);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), txLog);

  label38 = gtk_label_new (_("Status"));
  gtk_widget_show (label38);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 3), label38);

  gpbSignal = gtk_progress_bar_new ();
  gtk_widget_show (gpbSignal);
  gtk_box_pack_start (GTK_BOX (vbox1), gpbSignal, FALSE, TRUE, 0);
  gtk_widget_set_usize (gpbSignal, -1, 17);
  gtk_progress_configure (GTK_PROGRESS (gpbSignal), 0, 0, 255);
  gtk_progress_set_show_text (GTK_PROGRESS (gpbSignal), TRUE);
  gtk_progress_set_format_string (GTK_PROGRESS (gpbSignal), _("Signal %v %"));
  gtk_progress_set_text_alignment (GTK_PROGRESS (gpbSignal), 0.5, 0.15);

  gtk_signal_connect (GTK_OBJECT (fMain), "destroy",
                      GTK_SIGNAL_FUNC (on_fMain_destroy),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fMain), "show",
                      GTK_SIGNAL_FUNC (on_fMain_show),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (fMain), "key_press_event",
                      GTK_SIGNAL_FUNC (on_fMain_key_press_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (notebook1), "switch_page",
                      GTK_SIGNAL_FUNC (on_notebook1_switch_page),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (cbNight), "toggled",
                      GTK_SIGNAL_FUNC (on_cbNight_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (rbCAll), "toggled",
                      GTK_SIGNAL_FUNC (on_rbCAll_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (rbCSpecific), "toggled",
                      GTK_SIGNAL_FUNC (on_rbCSpecific_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (cbFakeAP), "toggled",
                      GTK_SIGNAL_FUNC (on_cbFakeAP_toggled),
                      NULL);
  gtk_signal_connect_after (GTK_OBJECT (bStartScan), "clicked",
                            GTK_SIGNAL_FUNC (on_bStartScan_clicked),
                            NULL);
  gtk_signal_connect_after (GTK_OBJECT(eSChannel),"change-value", 
                      GTK_SIGNAL_FUNC(on_eSChannel_value_changed),NULL);
					  
  /* set signal gauge color */
	astyle = gtk_widget_get_style (gpbSignal);
	rc_style = gtk_rc_style_new ();
	rc_style->bg[GTK_STATE_PRELIGHT] = blue;
	rc_style->base[GTK_STATE_PRELIGHT] = blue;
	rc_style->base[GTK_STATE_SELECTED] = blue;
	rc_style->bg[GTK_STATE_SELECTED] = blue;

	rc_style->color_flags[GTK_STATE_PRELIGHT] |= GTK_RC_BG;
	rc_style->color_flags[GTK_STATE_PRELIGHT] |= GTK_RC_BASE;
	rc_style->color_flags[GTK_STATE_SELECTED] |= GTK_RC_BASE;
	rc_style->color_flags[GTK_STATE_SELECTED] |= GTK_RC_BG;

	rc_style->fg[GTK_STATE_SELECTED] = white;
	rc_style->text[GTK_STATE_SELECTED] = white;
	rc_style->color_flags[GTK_STATE_SELECTED] |= GTK_RC_FG;
	rc_style->color_flags[GTK_STATE_SELECTED] |= GTK_RC_TEXT;
	rc_style->text[GTK_STATE_PRELIGHT] = white;
	rc_style->fg[GTK_STATE_PRELIGHT] = white;
	rc_style->color_flags[GTK_STATE_PRELIGHT] |= GTK_RC_FG;
	rc_style->color_flags[GTK_STATE_PRELIGHT] |= GTK_RC_TEXT;

	gtk_widget_modify_style (gpbSignal, rc_style);
	gtk_widget_ensure_style (gpbSignal);
 	gtk_rc_style_unref(rc_style);					  
	
  return fMain;
}

GtkWidget*
create_menu1 (void)
{
  GtkWidget *menu1;
  GtkWidget *view_detail1;
  GtkWidget *delete1;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new ();

  menu1 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (menu1), "menu1", menu1);

  view_detail1 = gtk_menu_item_new_with_label (_("view detail"));
  gtk_widget_show (view_detail1);
  gtk_container_add (GTK_CONTAINER (menu1), view_detail1);
  gtk_widget_add_accelerator (view_detail1, "activate", accel_group,
                              GDK_i, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  delete1 = gtk_menu_item_new_with_label (_("delete"));
  gtk_widget_show (delete1);
  gtk_container_add (GTK_CONTAINER (menu1), delete1);
  gtk_widget_add_accelerator (delete1, "activate", accel_group,
                              GDK_d, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  gtk_signal_connect (GTK_OBJECT (view_detail1), "activate",
                      GTK_SIGNAL_FUNC (on_view_detail1_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (delete1), "activate",
                      GTK_SIGNAL_FUNC (on_delete1_activate),
                      NULL);

  gtk_menu_set_accel_group (GTK_MENU (menu1), accel_group);

  return menu1;
}
