/*
 * Copyright (C) 2003 Philip Blundell <philb@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <stdio.h>
#include <sys/socket.h>
#include <linux/wireless.h>
#include <glib.h>
#include <string.h>
#include <ctype.h>
#include <sys/ioctl.h> 
#include <unistd.h>

#include "cards.h"

static int
open_socket (void)
{
  return socket (AF_INET, SOCK_DGRAM, 0);
}

GSList *
find_wireless_cards (void)
{
  GSList *list = NULL;
  FILE *fp;
  int fd;
  struct iwreq wrq;

  fd = open_socket ();
  if (fd < 0)
    return NULL;

  fp = fopen ("/proc/net/dev", "r");
  if (fp)
    {
      char buf[1024];

      /* ignore headers */
      fgets (buf, sizeof (buf), fp);
      fgets (buf, sizeof (buf), fp);

      while (fgets (buf, sizeof (buf), fp))
	{
	  char *p = buf, *ifname, *q;
	  struct ps_card *c;

	  while (isspace (*p))
	    p++;

	  if (*p == 0)
	    continue;

	  ifname = p;

	  do
	    {
	      q = strchr (p + 1, ':');
	      if (q)
		p = q;
	    } while (q);

	  *p = 0;

	  memset (&wrq, 0, sizeof (wrq));
	  strncpy (wrq.ifr_name, ifname, IFNAMSIZ);
	  if (ioctl (fd, SIOCGIWNAME, &wrq) < 0)
	    continue;
	  
	  c = g_malloc (sizeof (*c));
	  c->name = g_strdup (ifname);
	  c->type = g_strdup (wrq.u.name);
	  list = g_slist_append (list, c);
	}
    }

  close (fd);

  return list;
}
