/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2003      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: htmlnode.cc,v $
 * Revision 1.6  2003/03/06 14:54:21  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.5  2003/02/18 12:56:49  bdrieu
 * - Update to make prestimel compile with g++-3.2
 * - Use Magick++ instead of Magick
 *
 * Revision 1.4  2002/03/04 07:32:11  slash
 * Bugfix if the theme property is not given in the html-tag.
 *
 * Revision 1.3  2002/02/12 08:33:14  slash
 * Bugfix in htmlnode.cc.
 * Changed htmlnode's cell_padding to cellpadding.
 *
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:33  slash
 * Initial release.
 *
 */

#include "main.h"
#include "parameters.h"
#include "htmlnode.h"


//---------------------------------------------------------------------------
HTMLNode::HTMLNode(xmlNodePtr node) : Node()
{
    Parameters_.xml_html_theme_ = "";
    Parameters_.xml_html_resolution_ = -1;
    Parameters_.xml_html_sloppy_buttons_ = -1;
    Parameters_.xml_html_cellpadding_ = -1;
    Parameters_.xml_html_top_navigation_ = -1;

    // Parse the properties of the html-markup.
    char *resolution = (char*)xmlGetProp(node, (xmlChar*)"resolution");
    if (resolution) {
        if      (!strcmp(resolution, "640x480"))
            Parameters_.xml_html_resolution_ = 640;
        else if (!strcmp(resolution, "800x600"))
            Parameters_.xml_html_resolution_ = 800;
        else if (!strcmp(resolution, "1024x768"))
            Parameters_.xml_html_resolution_ = 1024;
    }
    char *theme = (char*)xmlGetProp(node, (xmlChar*)"theme");
    if (theme) {
       Parameters_.xml_html_theme_ = theme;
    }
    char *sloppybuttons = (char*)xmlGetProp(node, (xmlChar*)"sloppybuttons");
    if (sloppybuttons) {
        if      (!strcmp(sloppybuttons, "yes"))
            Parameters_.xml_html_sloppy_buttons_ = 1;
        else if (!strcmp(sloppybuttons, "no"))
            Parameters_.xml_html_sloppy_buttons_ = 0;
    }
    char *cellpadding = (char*)xmlGetProp(node, (xmlChar*)"cellpadding");
    if (cellpadding) {
        Parameters_.xml_html_cellpadding_ = atoi(cellpadding);
    }
    char *top_navigation = (char*)xmlGetProp(node, (xmlChar*)"top_navigation");
    if (top_navigation) {
        if      (!strcmp(top_navigation, "yes"))
            Parameters_.xml_html_top_navigation_ = 1;
        else if (!strcmp(top_navigation, "no"))
            Parameters_.xml_html_top_navigation_ = 0;
    }
}

//---------------------------------------------------------------------------
HTMLNode::~HTMLNode()
{
}


//---------------------------------------------------------------------------
void HTMLNode::writeHTML(int parameter) const
{
}

//---------------------------------------------------------------------------
void HTMLNode::writeLaTeX() const
{
}

//---------------------------------------------------------------------------
void HTMLNode::writeXML() const
{
    Output_ << "<html";
    
    switch (Parameters_.cl_html_resolution_) {
      case 640:  Output_ << " rtesolution=\"640x480\""; break;
      case 800:  Output_ << " resolution=\"800x600\""; break;
      case 1024: Output_ << " resolution=\"1024x768\""; break;
    }

    if (!Parameters_.xml_html_theme_.empty()) {
        Output_ << " theme=\"" << Parameters_.xml_html_theme_ << "\"";
    }

    switch (Parameters_.xml_html_sloppy_buttons_) {
      case 0: Output_ << " sloppybuttons=\"no\""; break;
      case 1: Output_ << " sloppybuttons=\"yes\""; break;
    }

    if (Parameters_.xml_html_cellpadding_ != -1) {
        Output_ << " cellpadding=\"" << Parameters_.xml_html_cellpadding_ << "\"";
    }

    switch (Parameters_.xml_html_sloppy_buttons_) {
      case 0: Output_ << " top_navigation=\"no\""; break;
      case 1: Output_ << " top_navigation=\"yes\""; break;
    }

    Output_ << "/>" << std::endl;
}
