/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: contentnode.h,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:41  slash
 * Initial release.
 *
 */

#ifndef CONTENTNODE_H
#define CONTENTNODE_H

#include "node.h"

//---------------------------------------------------------------------------
/**
 * This class represents a node, which contains plain text.
 * It is called ContentNode, because TextNode is used for nodes,
 * which represent the <text> markup.
 */
class ContentNode : public Node {
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the content-node.
     *
     * @param node The XML-node, which represents the content-node.
     * @param latex_encode Indicates, if special characters should be encoded
     *                     in the LaTeX-output.
     */
    ContentNode(xmlNodePtr node,
                int latex_encode = 1);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~ContentNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     * An integer-parameter has to be given because of the derivation,
     * but it won't be used in this class.
     *
     * @param parameter A dummy-parameter
     */
    void writeHTML(int parameter=0) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;

    //-----------------------------------------------------------------------
    /**
     * This method returns the number of characters of the stored text.
     *
     * @return The length of the text.
     */
    unsigned int getLength() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * The text of the content-node.
     */
    char *text_;

    //-----------------------------------------------------------------------
    /**
     * 1, if the LaTeX-output should encode special characters, else 0.
     */
    int latex_encode_;
};

#endif //CONTENTNODE_H
