#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>

#include <version.h>

#define	GENCAT_TYPE	0

#if	__GLIBC__ >= 2
#undef	GENCAT_TYPE
#define	GENCAT_TYPE	1
#endif

#if	defined(__OpenBSD__) || defined(__NetBSD__)
#undef	GENCAT_TYPE
#define	GENCAT_TYPE	2
#endif

#if	GENCAT_TYPE == 2

#define	GENCAT_HEADER	"-h"

void
output(char *name, char *buff)
{
    static int num=0;

    if (!buff) {
	printf("$set 1 #%s_\n", name);
	name = "VERSION";
	buff = VERSION;
    }
    printf("%d %s\n", ++ num, buff);
}
#endif

#if	GENCAT_TYPE == 1

#define	GENCAT_HEADER	"-H"

void
output(char *name, char *buff)
{
    if (!buff) {
	printf("$set %s_\n\n", name);
	name = "VERSION";
	buff = VERSION;
    }
    printf("%s %s\n", name, buff);
}
#endif

#if	GENCAT_TYPE == 0

#define	GENCAT_HEADER	"-h"

void
output(char *name, char *buff)
{
    if (!buff) {
	printf("$set 1 #%s_\n\n", name);
	name = "VERSION";
	buff = VERSION;
    }
    printf("$ #%s\n# %s\n", name, buff);
}
#endif

int
main(int argc, char *argv[])
{
    char buff[8192], line[1024], name[100];
    char *p, *ret;
    unsigned sys;
    int defmsg;

    if (argc > 1) {
	if (argc == 2 && !strcmp(argv[1], "-print-hflag")) {
	    printf(GENCAT_HEADER"\n");
	    exit(0);
	}
	output(argv[1], NULL);
	defmsg = 0;
    } else {
	printf("/*\n"
	       " * Generated automatically by mkmsg\n"
	       " * DO NOT EDIT!!\n"
	       " */\n\n"
	       "static const char *strMsg[]={\n");
	defmsg = 1;
    }
    buff[0] = '\0';
    do {
	if ((ret = fgets(line, sizeof(line), stdin)) != NULL)
	    if ((p = strpbrk(line, "\r\n")) != NULL) *p = '\0';
	if (ret == NULL || (line[0] == '$' && strchr("\t ", line[1]))) {
	    if (buff[0]) {
		if (defmsg) {
		    printf("    \"%s\",\n", buff);
		    defmsg ++;
		} else
		    output(name, buff);
	    }
	    if (line[0] == '$') {
		p = &line[2];
		while (*p && strchr("\t ", *p)) p ++;
		strncpy(name, p, sizeof(name) - 1);
	    }
	    buff[0] = '\0';
	} else strcat(buff, line);
    } while (ret);
    if (defmsg) printf("};\n\n#define	MAX_STRMSGS %d\n", defmsg);
    return(0);
}	
