#
#
#
#

Widget:DefineClass ButtonBox LabelFrame bbox:create bbox:config bbox_proc

set bbox_proc(get)		bbox:get
set bbox_proc(subwidget)	bbox:subwidget

proc bbox:create {w a} {
    global bbox_conf bbox_change

    set bbox_conf($w,buttons)  {}
    set bbox_conf($w,orient)   horizontal
    set bbox_conf($w,row)      1
    set bbox_conf($w,state)    normal

    set bbox_change(place)    0
    set bbox_change(state)    0
}

proc bbox:config {w opt val} {
    global bbox_conf bbox_change

    switch -- $opt {
	-buttons {
	    bbox:set_buttons $w $val
	    set bbox_change(place)    1
	    set bbox_change(state)    1
	}
	-orient {
	    set bbox_conf($w,orient) $val
	    set bbox_change(place) 1
	}
	-row {
	    set bbox_conf($w,row) $val
	    set bbox_change(place) 1
	}
	-variable {}
	-state {
	    set bbox_conf($w,state) $val
	    set bbox_change(state) 1
	}
	default {
	    return 1
	}
    }
    if $bbox_change(place) {
	bbox:place_buttons $w
	set bbox_change(place) 0
    }
    if $bbox_change(state) {
	bbox:set_state $w
	set bbox_change(state) 0
    }
    return 0
}

proc bbox:set_buttons {w buttons} {
    global bbox_conf

    set bbox_conf($w,buttons) {}
    foreach i $buttons {
	set btn [eval $i]
	lappend bbox_conf($w,buttons) $btn
    }
}

proc bbox:place_buttons {w} {
    global bbox_conf

    set f [$w subwidget frame]
    set orient $bbox_conf($w,orient)
    set maxrow $bbox_conf($w,row)

    set col 0
    set row 0

    foreach b $bbox_conf($w,buttons) {
	grid $b -in $f -column $col -row $row -sticky w
	if {$orient == "horizontal"} {
	    incr col
	    if {$col >= $maxrow} {
		set col 0
		incr row
	    }
	} else {
	    incr row
	    if {$row >= $maxrow} {
		set row 0
		incr col
	    }
	}
    }
}

proc bbox:set_state {w} {
    global bbox_conf

    set state $bbox_conf($w,state)
    foreach b $bbox_conf($w,buttons) {
	$b configure -state $state
    }
}

proc bbox:get {w a} {
    return {}
}

proc bbox:subwidget {w a} {
    global bbox_conf

    switch -- $a {
	buttons {return $bbox_conf($w,buttons)}
	default {return [eval Widget:Super ButtonBox $w subwidget $a]}
    }
}

proc bbox:test {} {
    option add *aho.text aho
    option add *baka.text baka
    option add *tawake.text tawake

    ButtonBox .b1 -buttons {
	{checkbutton .b1.aho}
	{checkbutton .b1.baka}
	{checkbutton .b1.tawake}
    }
    pack .b1
}
