// ------------------------------------------------------------------------- //
// $Id: common.cpp,v 1.6 2004/01/27 20:19:39 weismann Exp $
// ------------------------------------------------------------------------- //
/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include "common.h"

/*!
 * Create a orthonomal matrix from an x-dir and an up (y) dir.
 * The up-dir defaults to (0,1,0).
 */
void m33::create_from_dir(const v3& xdir, const v3& up)
{
	v3 x = xdir;
	x.make_norm();
	v3 z = vcross(x, up);
	z.make_norm();
	v3 y = vcross(z, x);
	set (x.x(), y.x(), z.x(),
	     x.y(), y.y(), z.y(),
	     x.z(), y.z(), z.z());
}

std::ostream& operator<< (std::ostream& os, const size3& s)
{
	os << "(" <<
		s.x.min << "-" << s.x.max << "," <<
		s.y.min << "-" << s.y.max << "," <<
		s.z.min << "-" << s.z.max << ")" <<  std::endl;
	return os;
}

float glmat[16];

// ------------------------------------------------------------------------- //
