#!/bin/sh
#
# mkprofile.sh - Makefile "il_profile.h" from a profile definition.
#
# Copyright (C) 2002  Southern Storm Software, Pty Ltd.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Usage: mkprofile.sh profile il_profile.h

# Parse the command-line options.
PROFILE="$1"
HEADER="$2"
if test -z "$PROFILE" ; then
	exit 1
fi
if test -z "$HEADER" ; then
	exit 1
fi

# Don't do anything if "il_profile.h" is more recent than "profile",
# to avoid causing unnecessary recompiles.  (Now done in include/Makefile.am).
# if test "$PROFILE" -ot "$HEADER" ; then
# 	exit 0
# fi

# Process the profile to create the header file.
echo '#ifndef _IL_CONFIG_OPTIONS' >"$HEADER"
echo '' >>"$HEADER"
echo '/* This file is automatically generated.  Do not edit */' >>"$HEADER"
echo '' >>"$HEADER"
grep '^IL_' "$PROFILE" | awk 'BEGIN{FS="="}{
	if($2 == "y")
	{
		print "#define",$1,"1"
	}
	else if($2 == "n")
	{
		print "#undef",$1
	}
	else
	{
		print "#define",$1,$2
	}
}' - >>"$HEADER"
echo '' >>"$HEADER"
echo '#endif /* _IL_CONFIG_OPTIONS */' >>"$HEADER"
exit 0
