/*
 * doc_texi.c - Convert csdoc into texinfo.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>

#include <dirent.h>

#include "il_system.h"
#include "il_utils.h"
#include "doc_tree.h"
#include "doc_backend.h"
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <errno.h>

#ifdef	__cplusplus
extern	"C" {
#endif

char *license="\
/*\n\
 * Test%s.cs - Test class for \"%s\" \n\
 *\n\
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.\n\
 * Copyright (C) 2002  FSF.\n\
 * \n\
 * Authors : Autogenerated using csdoc2test \n\
 *\n\
 * This program is free software; you can redistribute it and/or modify\n\
 * it under the terms of the GNU General Public License as published by\n\
 * the Free Software Foundation; either version 2 of the License, or\n\
 * (at your option) any later version.\n\
 *\n\
 * This program is distributed in the hope that it will be useful,\n\
 * but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
 * GNU General Public License for more details.\n\
 *\n\
 * You should have received a copy of the GNU General Public License\n\
 * along with this program; if not, write to the Free Software\n\
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n\
 */\n\n";

char *test_setup=
"	// Constructor.\n\
	public Test%s(String name)	: base(name)\n\
	{\n\
		// Nothing to do here.\n\
	}\n\
\n\
	// Set up for the tests.\n\
	protected override void Setup()\n\
	{\n\
		// Nothing to do here.\n\
	}\n\
\n\
	// Clean up after the tests.\n\
	protected override void Cleanup()\n\
	{\n\
		// Nothing to do here.\n\
	}\n\
";

/*********END GOPAL's H4cks**************/
		
char const ILDocProgramHeader[] =
	"CSDOC2TEST " VERSION " - Convert C# documentation into C# Test Stubs";

char const ILDocProgramName[] = "CSDOC2TEST";

ILCmdLineOption const ILDocProgramOptions[] = {
	{"-fclass",'c',1,
			"-fclass=CLASS",
			"Specify class to stub out as -fclass=CLASS"},
/*	{"-fnamespace",'n',1,
			"-fnamespace=NS",
			"Specify namespace to stub out as -fnamespace=NS"},*/
	{0, 0, 0, 0, 0}
};

char *ILDocDefaultOutput(int numInputs, char **inputs, const char *progname)
{
	return ".";
}

int ILDocValidateOutput(char *outputPath, const char *progname)
{
	/* Nothing to do here: any pathname is considered valid */
	return 1;
}
typedef struct _tagdict
{
	char *name;
	struct _tagdict *prev;
}dict;

dict * add_dict(dict *l,char *name)
{
	dict *retval=(dict*)calloc(1,sizeof(dict));
	retval->name=strdup(name);
	retval->prev=l;
	return retval;
}

dict * get_dict(dict *l,char *name)
{
	while(l!=NULL)
	{
		if(!strcmp(l->name,name))return l;
		l=l->prev;
	}
	return NULL;
}

dict * func_list=NULL;

int ctor=0;

void ILDocPrintMember(FILE *fp,ILDocType *type,ILDocMember *foo)
{
	if(foo->memberType == ILDocMemberType_Method)
	{
		if(!get_dict(func_list,foo->name))
		{
			func_list=add_dict(func_list,foo->name);
			fprintf(fp,"\tpublic void Test%s%s()\n",type->name,foo->name);
			fprintf(fp,"\t{\n");
			fprintf(fp,"\t/*TODO*/\n");
			fprintf(fp,"\t}\n\n");
		}
	}
	else if(foo->memberType == ILDocMemberType_Property)
	{
		fprintf(fp,"\tpublic void Test%s()\n",foo->name);
		fprintf(fp,"\t{\n");
		fprintf(fp,"\t/*TODO*/\n");
		fprintf(fp,"\t}\n");	
	}
	else if(foo->memberType == ILDocMemberType_Constructor && !ctor)
	{
		fprintf(fp,"\tpublic void TestConstructor()\n");
		fprintf(fp,"\t{\n\t/*TODO*/\n\t}\n\n");
		ctor=1;
	}
}

void ILDocPrintType(ILDocNamespace *ns, ILDocType *type,char *name)
{
	ILDocMember *i;
	FILE *fp;
	char *fname=(char*)calloc(strlen(name)+strlen(type->name)+10,sizeof(char));
	sprintf(fname,"%s/Test%s.cs",name,type->name);
	fp=fopen(fname,"w");
	if(!fp)
	{
		fprintf(stderr,"Could not open %s\n",fname);
	}
	printf("\twriting %s\n",fname);
	fprintf(fp,license,type->name,type->fullName);
	fprintf(fp,"using CSUnit;\nusing %s;\n\n",type->namespace->name);
	fprintf(fp,"public class Test%s : TestCase\n ",type->name);
	fprintf(fp,"{\n");
	fprintf(fp,test_setup,type->name);
	
	for(i=type->members;i!=NULL;i=i->next)
	{
		ILDocPrintMember(fp,type,i);
	}
	
	fprintf(fp,"}\n");
	fclose(fp);
	free(fname);
}

/*void ILDocPrintNS(ILDocNamespace *ns,char *outputPath)
{
	ILDocType *i;
	int j;
	char *name=(char*)calloc(strlen(outputPath)+strlen(ns->name),sizeof(char));
	strcat(name,outputPath);
	if(name[strlen(name)-1]!='/')
	{
		name[strlen(name)]='/';
	}
	strcat(name,ns->name);
	for(j=strlen(outputPath)-1;j<strlen(name);j++)
	{
			if(name[j]=='.')
			{
				name[j]='\0';
				mkdir(name,0777);
				//create a new dir every time we correct a NS
				name[j]='/';
			}
	}
	printf("Processing %s namespace\n",name);
	mkdir(name,0777);//make dir if still not made
	for(i=ns->types;i!=NULL;i=i->nextNamespace)
	{
		ILDocPrintType(ns,i,name);
	}
	free(name);
}*/

int ILDocPrintClass(ILDocNamespace *ns,char  *klassname,char *outputPath)
{
	char *namespace=strdup(klassname);
	ILDocNamespace *n=ns;
	ILDocType *j;
	int i;
	for(i=strlen(namespace)-1;i>=0;i--)
	{
		if(namespace[i]=='.')
		{
			namespace[i]='\0';//split off last entries
			break;
		}
	}
	while(n!=NULL)
	{
		if(!strcmp(n->name,namespace))
		{
			j=n->types;
			while(j!=NULL)
			{
				if(!strcmp(klassname,j->fullName))
				{
					ILDocPrintType(n,j,outputPath);
					return 1;
				}
				j=j->nextNamespace;
			}
		}
		n=n->next;
	}
	fprintf(stderr,"Class %s not found in the XML file \n",klassname);
	return 0;
}

int ILDocConvert(ILDocTree *tree, int numInputs, char **inputs,
				 char *outputPath, const char *progname)
{
	ILDocNamespace *i=tree->namespaces;
	char *klass=(char*)ILDocFlagValue("class");
	if(klass!=NULL)
	{
		return	ILDocPrintClass(i,klass,outputPath);
	}
	else
	{
		fprintf(stderr,
				"Class name missing . Please specify using -fclass=CLASS\n");
	}
	return 1;
}

#ifdef	__cplusplus
};
#endif
