#!/bin/sh
#
# cpp_defs.sh - Get the list of symbols that "cpp" defines, even when
#               asked not to nicely with "-undef".
#
# Copyright (C) 2002  Southern Storm Software, Pty Ltd.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Print the header.
echo '/* This file is automatically generated.  Do not edit */'
echo ''
echo 'char *ILCppUndefines[] = {'

# Determine the version of awk to use.
if test -n "$1" ; then
	AWK="$1"
else
	AWK=awk
fi

# Find the pre-processor.
if test -z "$CPP" ; then
	for dir in /usr/bin /bin /usr/local/bin /usr/lib /lib /usr/local/lib ; do
		if test -x "$dir/cpp" ; then
			CPP="$dir/cpp"
			break
		fi
	done
fi

# Run the pre-processor to determine the macros to undefine.
if test -n "$CPP" ; then
	echo "" | "$CPP" -undef -dM - 2>/dev/null | grep '^#define' | "$AWK" '{ print "\"" $2 "\"," }' -
fi

# Print the footer.
echo '};'
echo 'int ILCppNumUndefines = (sizeof(ILCppUndefines) / sizeof(char *));'

# Finished.
exit 0
