/*
 * PIMPPA: Newsgroup related
 *
 */

#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include "proto.h"

#include "../src/pimppa.h"
#include "../src/news.h"

static void leech(GList *list);

static void leech_clicked(GnomeDialog *dlg, int button, gpointer data);

static char *groupFlagNames[1]={"GROUP_DISABLED (1)"};

static bowser_flags groupFlags={groupFlagNames, 1};
static bowser_foreign groupForeign={"area_name", "area_id", "p_areas"};

static bowser_column groupDatas[5]=
    {{"g_name", COLUMN_TEXT, 300, "alt.binaries.pictures.goats", NULL},
	 {"g_server", COLUMN_NUMBER, 50, "1", NULL},
     {"g_last", COLUMN_NUMBER, 100, "0", NULL},
     {"g_flags", COLUMN_FLAGS, 50, "0", &groupFlags},
     {"g_dest", COLUMN_COMBO, 50, "", &groupForeign}};
static bowser_table groupTable={groupDatas, "p_groups", 5};

GnomeUIInfo leechMenu[] = {
	GNOMEUIINFO_MENU_SELECT_ALL_ITEM(select_all, GNOMEUIINFO_KEY_UIDATA),
	GNOMEUIINFO_MENU_CLEAR_ITEM(unselect_all, GNOMEUIINFO_KEY_UIDATA),
	GNOMEUIINFO_END
};	

GtkWidget *get_groups_box(void)
{
	return(get_table(&groupTable));
}

void leech_all(void)
{
	GList *glist;

	glist=get_sql(db, "SELECT g_name FROM p_groups "
			  "WHERE NOT (g_flags & %ld)",
	              GROUP_DISABLED);
	
	leech(glist);

	clear_glist(NULL, glist);
}

/*
 * Leechs the newsgroups in *list
 *
 */
static void 
leech(GList *list)
{
	char buffer[PATH_MAX];
	char stderrfile[PATH_MAX];
	GList *tmp;
	FILE *fp;
	int status,fd;
	int groups_passed=0,groups_total=0;
	int waita,waits;
	char *value;
	static int leeching=0;

	if(!list)
	{
		my_error_dialog("How about selecting something first?");
		return;
	}
	if(leeching)
	{
		my_error_dialog("One leech at a time, for now...");
		return;
	}

	leeching=1;

	value=p_getmisc(db, P_KEY_NEWSWAITAFTER);
	if(value)
		waita=atoi(value);
	else
		waita=atoi(P_NEWS_WAIT_AFTER);
	
	value=p_getmisc(db, P_KEY_NEWSWAITSECS);
	if(value)
		waits=atoi(value);
	else
		waits=atoi(P_NEWS_WAIT_SECS);

/****************** Get total number of groups **************/

	tmp=list;
	while(tmp)
	{
		groups_total++;
		tmp=tmp->next;
	}

/******** Create leech window **********/

	createinfowindow(NULL, (void *)1);

/****************** Get the groups **************************/
	
	sprintf(stderrfile, "/tmp/bowser_leech%d.stderr", getpid());

	tmp=list;
	
	while(tmp)
	{
		gchar *groupname=tmp->data;
	
		sprintf(buffer, "Leeching (%3d/%3d): %s", 
				groups_passed+1, groups_total, groupname);
		gnome_appbar_set_status(GNOME_APPBAR(statusBar), buffer);
		gnome_appbar_set_progress(GNOME_APPBAR(statusBar), 
			(float)((float)groups_passed/(float)(groups_total)));
			
		strcat(buffer, "\n");
		gtk_text_insert (GTK_TEXT (InfoText), NULL, &InfoText->style->black, NULL,
   	 	       	         buffer, -1);
		
		while(gtk_events_pending())
			gtk_main_iteration();
		
		unlink(stderrfile);
		mkfifo(stderrfile, 0600);

		if(fork()==0)
		{
			int options;

			freopen(stderrfile, "w", stdout);
			freopen(stderrfile, "w", stderr);

//			printf("Child entering...\n");

			options=OPT_VERBOSE|OPT_QUIET|OPT_INSERTSUBJECTS;// What a combo

			p_dlnews(NULL, groupname, options, waita, waits);
	
//			printf("Child exiting...\n");
			_exit(0);
		}
		
//		fprintf(stderr, "Parent enters wait...\n");
		
		fd=open(stderrfile, O_RDONLY|O_NONBLOCK);
		fp=fdopen(fd, "r");
		
		while((status=fgetc(fp))==EOF)			// Hackky kludgky kludgee
			usleep(500);

		ungetc(status, fp);

		while(!feof(fp))
		{
//			fprintf(stderr, "Loop\n");
			while(fgets(buffer, 1024, fp)>0)
			{
				gtk_text_insert (GTK_TEXT(InfoText), NULL, &InfoText->style->black, NULL,
   		 	       		         buffer, -1);
			}
		
			if(gtk_events_pending())
				gtk_main_iteration();
			else
				usleep(500);
		}
		
//		fprintf(stderr, "Gone\n");
		
		fclose(fp);
		close(fd);
	
		groups_passed++;
		tmp=tmp->next;
	}

	unlink(stderrfile);
	
	gtk_text_insert (GTK_TEXT(InfoText), NULL, &InfoText->style->black, NULL,
       	             "Done.\n", -1);

	leeching=0;

	gnome_appbar_set_status(GNOME_APPBAR(statusBar), "");
	gnome_appbar_set_progress(GNOME_APPBAR(statusBar), (float)0);
	
	return;
}

void leech_win(void)
{
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	GtkCList *list;
	GtkWidget *dlg, *scrolled_window, *popupmenu;
	gchar *titles[1]={"Newsgroup"};

	dlg=gnome_dialog_new("Select groups to leech",
						GNOME_STOCK_BUTTON_OK,
						GNOME_STOCK_BUTTON_CANCEL,
						NULL);

    gtk_widget_set_usize(GTK_WIDGET(dlg), 400,300);	
    gtk_window_set_position(GTK_WINDOW(dlg), GTK_WIN_POS_CENTER);

	list=(GtkCList *)gtk_clist_new_with_titles(1, titles);

	gtk_clist_set_selection_mode(list, GTK_SELECTION_MULTIPLE);

	popupmenu=gnome_popup_menu_new(leechMenu);
	gnome_popup_menu_attach(popupmenu, GTK_WIDGET(list), list);
	gnome_app_install_menu_hints(GNOME_APP(Bowser), leechMenu);

	p_query(db, "SELECT DISTINCT g_name FROM p_groups "
		    "WHERE NOT (g_flags & %ld)",
		GROUP_DISABLED);
	sql_res=mysql_store_result(db);
	if(sql_res)
	{
		gtk_clist_freeze(list);
		
		while((sql_row=mysql_fetch_row(sql_res)))
		{
			gtk_clist_prepend(list, sql_row);
		}

		gtk_clist_sort(list);
		gtk_clist_thaw(list);
	
		mysql_free_result(sql_res);
	}

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox), 
						scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show(scrolled_window);

    gtk_container_add(GTK_CONTAINER(scrolled_window), GTK_WIDGET(list));
    gtk_widget_show(GTK_WIDGET(list));

    gtk_signal_connect(GTK_OBJECT(dlg), "clicked",
                        GTK_SIGNAL_FUNC(leech_clicked),
                        list);

	gtk_widget_show_all(dlg);
}
	
static void
leech_clicked(GnomeDialog *dlg, int button, gpointer data)
{
	GtkCList *list=(GtkCList *)data;
	GList *tmp, *new=NULL;
	
    switch(button)
    {
        case 0:
            break;
        case 1:
        default:
            gnome_dialog_close(dlg);
            return;
            break;
    }

	if(!list)
		return;

	tmp=list->selection;
	if(!tmp)
	{
		my_error_dialog("Select some groups!\n");
		return;
	}
	
//	fprintf(stderr, "Murr!\n");
	
	while(tmp)
	{
		int row=(int)tmp->data;
		char *grouptmp=NULL, *groupname;
		
		gtk_clist_get_text(list, row, 0, &grouptmp);
//		fprintf(stderr, "G %s\n", grouptmp);
	
		groupname=strdup(grouptmp);
	
		new=g_list_append(new, groupname);
		
		tmp=tmp->next;
	}

//	fprintf(stderr, "Kurr!\n");
	
	gtk_clist_unselect_all(list);
	gnome_dialog_close(dlg);

	leech(new);
	
	clear_glist(NULL, new);
}
	
