/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#if defined USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include "main.h"

extern void pager_help(void);
extern char *headline;

void display_pa(char **pa, char *first_line, char *second_line, int palines)
{
   int j=0, num=0, last=1, height=_WINROWS_ - 4, plength=0, mnum=0;
   int scrollup=0, scrolldown=0;
   unsigned char update_lastline=0;
   static unsigned char ignorecase=0;
   char c='\0', *pattern=NULL, *str=NULL, *blankline=NULL;
   char **tmp, *ctmp=NULL, *lastline=NULL, *endline=NULL;
   
   MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
   MEM_CHECK((pattern = (char *)calloc(SONAME, sizeof(char))));
   *pattern = '\0';
   MEM_CHECK((lastline = (char *)calloc(SONAME, sizeof(char))));
   sprintf(lastline, "[%dH     <q> quit, </> search, < > more, <b> back, <UP> up, <DOWN> down ***", _WINROWS_);
   for (j=0, ctmp=lastline; *ctmp != 'H'; ctmp++, j++);
   for (ctmp=lastline; *ctmp; ctmp++);
   for (; ctmp - lastline < _WINCOLS_+j; ctmp++) *ctmp = '*';
   *ctmp='\r';
   *++ctmp='\0';
   MEM_CHECK((endline = (char *)calloc(SONAME, sizeof(char))));
   sprintf(endline, "[%dH     <q> quit, </> search, < > quit, <b> back, <UP> up ***", _WINROWS_);
   for (j=0, ctmp=endline; *ctmp != 'H'; ctmp++, j++);
   for (ctmp=endline; *ctmp; ctmp++);
   for (; ctmp - endline < _WINCOLS_+j; ctmp++) *ctmp = '*';
   *ctmp='\r';
   *++ctmp='\0';
   MEM_CHECK((blankline = (char *)calloc(SONAME, sizeof(char))));
   for (ctmp=blankline; ctmp - blankline < _WINCOLS_; ctmp++) *ctmp = ' ';
   *ctmp='\r';
   *++ctmp='\0';

   /*
    * Clear screen.
    */
   fprintf(stdout, "[H[J");

   do {
      if (palines - num < height) {
         num = palines - height + 1;
         scrollup = 0;
      }
      if (num < 0) {
         num = 0;
         scrolldown = 0;
      }
      if (last != num || c == '') {
         if ((!scrollup && !scrolldown) || ((scrollup || scrolldown) && update_lastline)) {
            if (num <= palines - height) {
               fprintf(stdout, lastline);
            }
            else {
               fprintf(stdout, endline);
            }
            update_lastline = 0;
         }
         if (scrollup) {
            fprintf(stdout, "[3;%dr[%dH", _WINROWS_-1, scrollup+4);
         }
         else if (scrolldown) {
            fprintf(stdout, "[3;%dr[3HM[3H", _WINROWS_-2);
         }
         else {
            fprintf(stdout, "[1;%dr[%dH%s", _WINROWS_, _WINROWS_-1, blankline);
            fprintf(stdout, "[H%s", first_line);
            fprintf(stdout, "[2H%s[%dH", second_line, scrollup+3);
         }
         for (last=j=num+scrollup; j < height + num - scrolldown && j <= palines; j++) {
            fprintf(stdout, "%s%s", mnum == j ? ">": " ", *(pa+j));
         }
         if (scrollup) fprintf(stdout, "[3H>");
         scrollup = scrolldown = 0;
         update_lastline = 0;
      }
      fflush(stdout);
      fprintf(stdout, "[%dH%3d%%", _WINROWS_, height <= palines ? ((num+height-1)*100)/palines: 100);
      while ((c = fgetc(stdin)) == '' || c == '[' || c == '~' || c == 'O');
      switch(c) {
         case ' ': case '6':
            if (palines - num < height && c == ' ') c = 'q';
            else {
               num += height;
               c = ' ';
            }
            last = 0;
            break;
         case 'd':
            if (palines - num < height) c = 'q';
            else num += height/2;
            break;
         case 'b': case '5':
            num -= height;
            break;
         case 'u':
            num -= height/2;
            break;
         case '': case '': case 'A': case 'k':
            if (num) {
               if (num + height > palines && !update_lastline) fprintf(stdout, "[%dH%s", _WINROWS_, lastline);
               num--;
               fprintf(stdout, "[%dH \n", mnum - num + 2);
               scrolldown = height - 1;
            }
            break;
         case '\n': case 'B': case 'j':
            if (palines - num >= height) {
               scrollup = height - 1;
               num++;
            }
            else last = 0;
            break;
         case 'D': case 'h':
            c = 'q';
            break;
         case '':
            fprintf(stdout, "[H[J");
            break;
         case 'g':
         case '1':
            num = 0;
            break;
         case 'G':
         case '4':
            num = palines - height + 1;
            last = 0;
            break;
         case 'N':
            plength = 1;
            if (*pattern && (plength = strlen(pattern))) {
               mnum--;
               for (tmp=pa+mnum; tmp+1 != pa && plength; tmp--) {
                  for (ctmp=*tmp; *(ctmp+1); ctmp++) {
                     if (ignorecase ? !strncasecmp(pattern, ctmp, plength): \
                                      !strncmp(pattern, ctmp, plength)) {
                        mnum = num = tmp - pa;
                        plength = 0;
                        last--;
                     }
                  }
               }
               if (!num) last = palines;
            }
            else {
               fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
               fprintf(stderr, "     No search pattern.");
               plength = 0;
               update_lastline = 1;
            }
            if (plength) {
               mnum++;
               fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
               fprintf(stderr, "     `%s' not found.", pattern);
               update_lastline = 1;
            }
            break;
         case 'n':
            plength = 1;
            if (*pattern && (plength = strlen(pattern))) {
               mnum++;
               for (tmp=pa+mnum; tmp - pa <= palines && plength; tmp++) {
                  for (ctmp=*tmp; *(ctmp+1); ctmp++) {
                     if (ignorecase ? !strncasecmp(pattern, ctmp, plength): \
                                      !strncmp(pattern, ctmp, plength)) {
                        mnum = num = tmp - pa;
                        plength = 0;
                        last--;
                     }
                  }
               }
            }
            else {
               fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
               fprintf(stderr, "     No search pattern.");
               last = num;
               plength = 0;
               update_lastline = 1;
            }
            if (plength) {
               mnum--;
               fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
               fprintf(stderr, "     `%s' not found.", pattern);
               last = num;
               update_lastline = 1;
            }
            break;
         case 'i':
            fprintf(stderr, "[%dH%s", _WINROWS_, blankline);
            if (ignorecase) {
               ignorecase = 0;
               fprintf(stderr, "     Case is significant in searches.");
            }
            else {
               ignorecase = 1;
               fprintf(stderr, "     Ignore case in searches.");
            }
            last = num;
            update_lastline = 1;
            break;
         case '?':
            pager_help();
            c = '';
            break;
         case 's':
         case '/':
            fprintf(stdout, "[%dH%s", _WINROWS_, blankline);
            fprintf(stdout, "[?25h\r[%s]: ", pattern);
            plength = 0;
            ctmp = str;
            *ctmp = '\0';
            do {
               c = fgetc(stdin);
               switch(c) {
                  case '\n':
                     *ctmp = '\0';
                     c = '\0';
                     break;
                  case '':
                     *str = '\0';
                     plength = -1;
                     break;
                  case '': case '':
                     if (ctmp > str) {
                        fprintf(stderr, "\b \b");
                        *--ctmp = '\0';
                     }
                     plength--;
                     break;
                  default:
                     if (isprint(c) && plength < SONAME) {
                        *ctmp++ = c;
                        fprintf(stderr, "%c", c);
                        plength++;
                     }
                     break;
               }
            } while (c && plength >= 0);
            if ((!*pattern && !plength) || plength < 0) {
               last--;
               fprintf(stdout, "[?25l\r");
               break;
            }
            if ((plength = strlen(str))) strcpy(pattern, str);
            if ((plength = strlen(pattern))) {
               mnum++;
               for (tmp=pa+mnum; tmp - pa <= palines && plength; tmp++) {
                  for (ctmp=*tmp; *(ctmp+1); ctmp++) {
                     if (ignorecase ? !strncasecmp(pattern, ctmp, plength): \
                                      !strncmp(pattern, ctmp, plength)) {
                        num = tmp - pa;
                        plength = 0;
                        last--;
                     }
                  }
               }
            }
            if (plength) {
               fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
               fprintf(stderr, "     `%s' not found.", pattern);
               last = num;
               update_lastline = 1;
            }
            fprintf(stdout, "[?25l\r");
      }
      if (c != '' && c != 'n' && c != 'N' && c != '/') {
         mnum = num;
         if (mnum < 0) mnum = 0;
         else if (c == ' ' && mnum > palines - height + 1) {
            mnum = palines - height + 1;
         }
      }
   } while (c != 'q');
   fprintf(stdout, "[1;%dr[%dH%s", _WINROWS_, _WINROWS_, blankline);
   if (endline) free(endline);
   if (lastline) free(lastline);
   if (blankline) free(blankline);
   if (pattern) free(pattern);
   if (str) free(str);
}


short pftp_pager(char *cdir, char *secondline, char *blankline)
{
   char *ltmp[BIG_BUFSIZE], *dtmp=NULL;
   char **tmp, *str=NULL, *ctmp=NULL;
   short islonger=0;
   long tmpend=0;
   FILE *fp=NULL;

   if (!(fp = fopen(cdir, "r"))) {
      fprintf(stdout, "[%dH%s", _WINROWS_, blankline);
      fprintf(stdout, "[%dH** %s: %s\n",
      _WINROWS_, cdir, _PFTP_ERROR_ARRAY_);
      return 0;
   }
   MEM_CHECK((str = (char *)calloc(LONAME, sizeof(char))));
   for (tmp=ltmp; fgets(str, LONAME, fp);) {
      for (ctmp=str, islonger=0; *ctmp && tmpend < BIG_BUFSIZE; islonger=1) {
         tmpend++;
         MEM_CHECK((*tmp++ = (char *)calloc(LONAME, sizeof(char))));
         for (dtmp=*(tmp-1); *ctmp && dtmp - *(tmp-1) < _WINCOLS_ - 1 - islonger; dtmp++, ctmp++) {
            if (islonger) {
               *dtmp = '+';
               ctmp--;
               islonger=0;
            }
            else *dtmp = isprint(*ctmp) ? *ctmp: ' ';
         }
         if (!*ctmp) for (; dtmp - *(tmp-1) < _WINCOLS_ - 1; dtmp++) *dtmp = ' ';
         *dtmp = '\n';
         *++dtmp = '\0';
      }
   }
   *tmp = NULL;
   fclose(fp);
   free(str);
   display_pa(ltmp, headline, secondline, --tmpend);  
   if (tmp != ltmp) {
      for (tmp--; tmp != ltmp; tmp--) free(*tmp);
   }
   free(*tmp);
   return 1;
}
