/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include "main.h"

#if !defined __RH_CYGLINT__
extern void set_tty(int);
extern void pmanager(short);
#endif
extern void warranty(void);
extern int substitute_string(char *, int);


void lhost(int *portn, int strnum)
{
   FILE *fp=NULL;
   char c=0, str[SONAME], *stra=NULL, *stre=NULL, *tmpstr=NULL;
   char *blankline=NULL, *listentry[HUNAME], **ltmp=NULL;
   int tmp, num=0, endnum=0;

   char hn[14], *pattern=NULL, ch='\0';
   int i=0, j=0, height=0, plength=0, last=0, defhost=0;
   int scrollup=0, scrolldown=0;

   if ((fp = fopen((*(statstr+strnum))->home, "r")) == NULL) {
      fprintf(stderr, "** %s: %s\n", (*(statstr+strnum))->home, _PFTP_ERROR_ARRAY_);
      exit(PFTP_OPEN_RC_ERR);
   }

   /*
    * Read host name list entries.
    */
   for (ltmp=listentry, endnum=0; fgets(str, SONAME, fp); endnum++) {
      tmp = *portn;
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra || !strncmp("PFTP", stra, 4)) {
         --endnum;
         continue;
      }

      /*
       * Substitute string with variable or file contents.
       */
      if (*stra == PFTP_SPECIAL_SIGN && \
         (*(stra+1) == 'V' || *(stra+1) == 'F')) {
         substitute_string(str, stra-str);
      }

      if (*stra == PFTP_SPECIAL_SIGN || *stra == '.') {
         --endnum;
         continue;
      }
      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      *stre = '\0';
      if (*portn) {
         for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
         if (*stre && atoi(stre) && !((*statstr)->_PFTP_DAEMON_ & BIT_TWO)) {
            tmp = atoi(stre);
         }
      }
      for (tmpstr=str; *tmpstr && *tmpstr != ':' && *tmpstr != '@'; tmpstr++);
      if (*tmpstr == ':') {
         *tmpstr = '\0';
         for (tmpstr++; *tmpstr && *tmpstr != '@'; tmpstr++);
         if (*tmpstr == '@') strcat(str, tmpstr);
      }
      MEM_CHECK((*ltmp = (char *) calloc(SONAME, sizeof(char))));
      if (!*portn) {
#if defined __RH_CYGLINT__
         char cygtmp[BUFSIZ];
#endif
         (*statstr)->host_number = endnum + 1;
         (*statstr)->bsize = 0;
#if defined __RH_CYGLINT__
         get_var_from_pftprc((FILE *)NULL, "PFTPRECEIVE", cygtmp, 0);
#else
         pmanager(2);
#endif
         tmp = (*statstr)->bsize;
      }
      sprintf(*ltmp, " %3d) %-36.36s %6d", endnum+1, str, tmp);
      for (stra=*ltmp; *stra; stra++);
      for (; stra - *ltmp < _WINCOLS_ - 1; stra++) *stra = ' ';
      *stra = '\n';
      *++stra = '\0';
      ltmp++;
   }
   *ltmp = NULL;
   fclose(fp);
   endnum--;

   /*
    * Create host name list.
    */
   c = '0';
   num = 0;

   MEM_CHECK((pattern = (char *) calloc(SONAME, sizeof(char))));
   *pattern = '\0';
   MEM_CHECK((blankline = (char *) calloc(SONAME, sizeof(char))));
   for (num=1; num < _WINCOLS_ && num < SONAME; num++) *(blankline+num-1) = ' ';
   *(blankline+num-1) = '\r';
   *(blankline+num) = '\0';
   num = 0;

   /*
    * Check if running in non-silent mode.
    */
   if (!slfp) {
      fprintf(stderr, "** Started in silent mode: Cannot output the host list.\n");
      exit(PFTP_NO_TTY_ERR);
   }

#if !defined __RH_CYGLINT__
   /*
    * Set _WINROWS_.
    */
   set_tty(2);
#endif

   /*
    * Print list on screen.
    */
   height = _WINROWS_ - 4;
   fprintf(stderr, "[H[J\r");
   for (;;) {
      if (num + height > endnum) {
         num = endnum-height+1;
         scrollup = 0;
      }
      if (num < 0) {
         num = 0;
         scrolldown = 0;
      }
      if (scrollup) {
         fprintf(stdout, "[3;%dr[4H>[%dH", _WINROWS_-1, scrollup+4);
      }
      else if (scrolldown) {
         fprintf(stdout, "[3;%dr[3HM[3H", _WINROWS_-2);
      }
      else {
         fprintf(stdout, "[1;%dr", _WINROWS_);
         if (num + height > endnum && endnum >= height) fprintf(stdout, "[%dH** End of list reached.", _WINROWS_-1);
         else fprintf(stdout, "[%dH%s", _WINROWS_-1, blankline);
         if (*portn) fprintf(stdout, "[H******* Host name(s) ****************** Port number(s) [%d] ******",*portn);
         else fprintf(stdout, "[H******* Host name(s) *********************** New data ****************");
         fprintf(stdout, "[%dH", scrollup+3);
      }
      for (j=num+scrollup; j < height + num - scrolldown && j <= endnum; j++) {
         fprintf(stdout, "%s%s", defhost == j ? ">": " ", *(listentry+j));
      }
      fprintf(stdout, "[%dH%3d%% <q> quit, </> search, < > more, <b> back, <NUM> select host[%d]: ",
      _WINROWS_, height <= endnum ? ((num+height-1)*100)/endnum: 100, defhost+1);
      fflush(stdout);

      c = '0'; i = 0; *hn = '\0';
      scrollup = scrolldown = 0;

      while (isdigit(c) || c == '' || c == '') {
         while ((c = fgetc(stdin)) == '' || c == '[');
         switch(c) {
            case 'G':
               num = endnum;
               break;
            case 'g':
               num = 0;
               break;
            case 'q':
               for (ltmp=listentry+endnum; ltmp+1 != listentry; ltmp--) free(*ltmp);
               fprintf(stdout, "quit[1;%dr[%dH\n", _WINROWS_, _WINROWS_);
#if !defined __RH_CYGLINT__
               set_tty(0);
#endif
               exit(PFTP_NO_ERR);
               break;
            case '':
               fprintf(stdout, "[H[J\r");
               break;
            case 'k': case 'A':
               if (num) {
                  fprintf(stdout, "    ");
                  if (num + height > endnum) fprintf(stdout, "[%dH%s", _WINROWS_-1, blankline);
                  num--;
                  fprintf(stdout, "[%dH \n", defhost-num+2);
                  scrolldown = height - 1;
               }
               else c = '0';
               break;
            case 'j': case 'B':
               if (endnum - num < height) c = '0';
               else {
                  fprintf(stdout, "    ");
                  scrollup = height - 1;
                  num++;
               }
               break;
            case 'b':
               if (!num) c = '0';
               else num -= height;
               break;
            case ' ':
               if (endnum - num < height) c = '0';
               else num += height;
               break;
            case '': case '':
               if (i > 0) {
                  fputs("\b \b", stdout); 
                  hn[--i] = '\0';
               }
               break;
            case '\n':
               for (ltmp=listentry+endnum; ltmp+1 != listentry; ltmp--) free(*ltmp);
               fprintf(stdout, "[1;%dr[%dH", _WINROWS_, _WINROWS_);
               fprintf(stdout, "\r%s", blankline);  
               fflush(stdout);
               (*statstr)->host_number = atoi(hn) ? atoi(hn) : defhost+1;
#if !defined __RH_CYGLINT__
               set_tty(0);
#endif
               return;
            case 'N':
               last = num;
               defhost--;
               if (*pattern && (plength = strlen(pattern))) {
                  for (ltmp=listentry+defhost; ltmp+1 != listentry && plength; ltmp--) {
                     for (stra=*ltmp; *(stra+1); stra++) {
                        if (!strncmp(pattern, stra, plength)) {
                           defhost = num = ltmp - listentry;
                           plength = 0;
                        }
                     }
                  }
               }
               else {
                  fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                  fprintf(stderr, "** No search pattern.");
                  num = last;
                  c = '0';
               }
               if (plength) {
                  fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                  fprintf(stderr, "** `%s' not found.", pattern);
                  num = last;
                  c = '0';
               }
               break;
            case 'n':
               last = num;
               defhost++;
               if (*pattern && (plength = strlen(pattern))) {
                  for (ltmp=listentry+defhost; ltmp - listentry <= endnum && plength; ltmp++) {
                     for (stra=*ltmp; *(stra+1); stra++) {
                        if (!strncmp(pattern, stra, plength)) {
                           defhost = num = ltmp - listentry;
                           plength = 0;
                        }
                     }
                  }
               }
               else {
                  fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                  fprintf(stderr, "** No search pattern.");
                  num = last;
                  c = '0';
               }
               if (plength) {
                  fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                  fprintf(stderr, "** `%s' not found.", pattern);
                  num = last;
                  c = '0';
               }
               break;
            case '/':
               fprintf(stdout, "[%dH                                                                       \r", _WINROWS_);
               fprintf(stdout, "[%s]: ", pattern);
               plength = 0;
               last = num;
               stra = str;
               *stra = '\0';
               do {
                  ch = fgetc(stdin);
                  switch(ch) {
                     case '\n':
                        *stra = '\0';
                        ch = '\0';
                        break;
                     case '':
                        *str = '\0';
                        plength = -1;
                        break;
                     case '': case '':
                        if (stra > str) {
                           fprintf(stderr, "\b \b");
                           *--stra = '\0';
                        }
                        plength--;
                        break;
                     default:
                        if (isprint(ch)) {
                           plength++;
                           *stra++ = ch;
                           fprintf(stderr, "%c", ch);
                        }
                        break;
                  }
               } while (ch && plength >= 0);
               if ((!*pattern && !plength) || plength < 0) break;
               if ((plength = strlen(str))) strcpy(pattern, str);
               if ((plength = strlen(pattern))) {
                  defhost++;
                  for (ltmp=listentry+defhost; ltmp - listentry <= endnum && plength; ltmp++) {
                     for (stra=*ltmp; *(stra+1); stra++) {
                        if (!strncmp(pattern, stra, plength)) {
                           defhost = num = ltmp - listentry;
                           plength = 0;
                        }
                     }
                  }
               }
               if (plength) {
                  defhost--;
                  fprintf(stderr, "[%dH                                                                       \r", _WINROWS_);
                  fprintf(stderr, "** `%s' not found.", pattern);
                  num = last;
                  c = '0';
               }
               break;
            case 'w':
               fprintf(stderr, "[?25l");
               warranty();
               fprintf(stdout, "[?25h[H[J\r");
               break;
            default:
               if (isdigit(c) && i < 10) {
                  fputc(c, stdout);
                  hn[i++] = c;
                  hn[i] = '\0';
               }
               else c = '0';
         }
         if (c != '' && c != 'n' && c != 'N' && c != '/') {
            defhost = num - (c == 'G' || c == 'g' ? height: 1) + 1;
            if (defhost < 0) defhost = 0;
            if (c == ' ' && defhost > endnum - height + 1) defhost = endnum - height + 1;
         }
      }
   }
}
