/* ----------------------------------------------------------------------------
 * pbb_errno.c
 * libpbb funtions to handle error messages
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <stdio.h>
#include <unistd.h>
#include <syslog.h>
#include <stdarg.h>

#include "pbb.h"

extern struct libbase libdata;

void
print_error(char *msg, ...)
{
	struct libbase *base = &libdata;
	char logerror[200];
	va_list list;

	va_start (list, msg);
	if (base->daemon != PBBDS_NONE) {
		vsnprintf (logerror, sizeof(logerror), msg, list);
		syslog(LOG_ERR, logerror);
	} else
		vfprintf(stderr, msg, list);
	va_end (list);
}
