#ifndef INCLUDE_PBB_H
#define INCLUDE_PBB_H
/* ----------------------------------------------------------------------------
 * pbb.h
 * prototypes and definitions for pbbuttons library.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <sys/types.h>

#include "pbbipc.h"
#include "pbberrno.h"
#include "pbbmisc.h"
#include "pbbtaglist.h"
#include "pbbtags.h"

#define MAXPROTECTEDTAGS 20

#define MODE_QUERY	0	/* modes for new handle_tags routines */
#define MODE_CONFIG	1

#define PBBDF_NONE	0   /* Flags for deamonise functions */
#define PBBDF_FORCE	1

enum {PBBDS_NONE, PBBDS_PREPARE, PBBDS_CHILD, PBBDS_PARENT};

/* --- private module data structure of libpbbuttons --- */
struct libbase {
	int serverport;
	int msgport;
	struct tagitem ptags[MAXPROTECTEDTAGS];
	int mode;            /* client or server */
	int ptagcount;
	int client[MAXCLIENTS]; /* IPC ids of registrated cilent message ports */
	int count;             /* number of entries in the client array */
	int daemon;            /* deamon status, possible values see PBBDS_* */
	char pidfile[80];    /* name of the pidfile to write the child pid to */
	int filtermode;      /* = 0: IPC-filtering off
	                        = 1: no IPC-Messages will be accepted
	                        = 2: only IPC-messages from 'uid' will be accepted */
	uid_t uid;           /* user-id for IPC-filter */
	int rc;              /* return code of last launched program */
	int timeforcmd;      /* timeout value for lauched programs */
};

/* prototypes */

/* main initialisation function, call before using any other function */
void init_libpbb();
/* this should be the nearly last function you called in your program */
void exit_libpbb ();

int prepare_daemon (char *name, char *pidfile, int flags);
int create_daemon ();

#endif    /* INCLUDE_PBB_H */

