/*
**  IMAPFolder.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_IMAPFolder
#define _Pantomime_H_IMAPFolder

#include <Pantomime/Folder.h>

#import <Foundation/NSArray.h>
#import <Foundation/NSData.h>
#import <Foundation/NSString.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

@class Flags;

@interface IMAPFolder : Folder
{
  BOOL selected, newMessagesHaveArrived;
  int UIDValidity;

  id delegate;
}

- (id) initWithName: (NSString *) theName
               mode: (int) theMode;

- (void) copyMessages: (NSArray *) theMessages
             toFolder: (NSString *) theFolder;

- (BOOL) prefetch;

- (int) UIDValidity;
- (void) setUIDValidity: (int) theUIDValidity;

- (BOOL) selected;
- (void) setSelected: (BOOL) aBOOL;

- (id) delegate;
- (void) setDelegate: (id) theDelegate;

@end


//
// Private methods
//
@interface IMAPFolder (Private)

- (NSString *) _flagsAsStringFromFlags: (Flags *) theFlags;
- (NSData *) _removeInvalidHeadersFromMessage: (NSData *) theMessage;
- (int) _updateMessagesFromUID: (int) startUID 
                         toUID: (int) endUID;
@end

#endif // _Pantomime_H_IMAPFolder
