//
// C++ Interface: tagselectionview.h
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
// The first version of this file was generated by umbrello 
// on Tue May 18 2004 at 20:13:27

#ifndef __TAGSELECTIONVIEW_H_2004_05_18
#define __TAGSELECTIONVIEW_H_2004_05_18

#include <string>
#include <set>

#include "tagitem.h"
#include "exception.h"

using namespace std;

namespace Tagcoll
{
	class FacetSet;
}

/** @brief This class defines an interface for a GUI for the selection of tags by the user.
  *
  * It is characterized by a set of TagItems which are organized in a hierarchy. At each time there 
  * is a subset of them selected. Whenever the selection changes, the tagItemsSelected signal will 
  * be emitted.
  * @author Benjamin Mesing
  */
class TagSelectionView {
/**
 * Public stuff
 */
public:
	/** Unary predicate that test if an item matches a given string. */
	struct equal_to_tagname : public unary_function<TagItem*,bool>
	{
		bool operator()(TagItem* pItem)	{ return pItem->fullTagname()==_fullTagname; };
		/** Constructs the object, fullTagname gives the string to be matched. */
		equal_to_tagname(const string& fullTagname) : _fullTagname(fullTagname) 	{};
	private:
		const string& _fullTagname;
	};

	/** @brief Adds a TagSelectionItem as child of parent to the view.
	  * 
	  * @param pItem item to be added
	  * @param pParent item under which the new item should be added, if parent == 0 the item is handled as
	  * a top level item 
	  */
	virtual void addTagItem(TagItem* pItem, TagItem* pParent=0) = 0;
	/** @brief Adds a TagSelectionItem as child of parent to the view.
	  * 
	  * @param pItem item to be added
	  * @param parentFullTagname name of the item under which the new item should be added. */
	virtual void addTagItem(TagItem* pItem, const string& parentFullTagname) = 0;
	/** @brief Deselects the tag with the given name.
	  * 
	  * @param fullTagname tag to be deselected  */
	virtual void deselectTag(const string& fullTagname) = 0;
	/** @brief Deselects all tags. */
	virtual void deselectAll() = 0;
	/** @brief Clears the view and emits the tagItemsSelected() signal. */
	virtual void clear() = 0;
	/** @brief Get the item with the given name.
	  * 
	  * @param fullName the fullName of the item to be fetched
	  * @returns the item that matches fullName, returns 0 if no such item was found */
	virtual TagItem* getTagItem(const string& fullName) = 0;
	/** This is a dummy function for documentation purpose only.\n
	  * It shows that there is a signal called tagItemsSelected that will be emitted by this class.
	  * But as QT does not support multiple QObjects as parents, I left the definition of 
	  * this signal to the subclasses.
	  *
	  * The signal will be emitted, whenever the selection changes.
	  *
	  * @param tags the items that were selected by the user.
	  */
	void signal_tagItemsSelected(set<TagItem*> tags) {};
	/** @brief Loads or reloads and the vocabulary data.
	  *
	  * Call this whenever you want to change the vocabulary data.
	  */
	virtual void loadVocabulary(const Tagcoll::FacetSet& pVocabulary)= 0;
	/** @brief Sets a pattern to be used to filter the tags. */
	virtual void setFilterByNamePattern(const string& filterByNamePattern) = 0;
	/** @returns if the current TagSelectionView has valid data loaded. */
	virtual bool hasData() const = 0;

};
#endif	// __TAGSELECTIONVIEW_H_2004_05_18

