/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

// Tagcoll
#include <Tag.h>
#include <TagSet.h>

// Debtags
#include <Vocabulary.h>
#include <Environment.h>

#include <helpers.h>

// NDebtags
#include "selectedfacetsmatcher.h"

#include "exception.h"

/** always call init(Debtags::Vocabulary) before doing anything else. */
void DebtagsSettingsWidget::init()
{
}

/** @brief The button to add facets to the hidden facets was clicked. */
void DebtagsSettingsWidget::onAddClicked()
{
 QListViewItemIterator it(_pShownFacetsList, QListViewItemIterator::Selected);
 while ( it.current() ) 
 {
  QListViewItem* pItem = (*it); // make a temporary copy of the item
  new QListViewItem(_pHiddenFacetsList, pItem->text(0), pItem->text(1) );
  ++it;
  emit facetHidden( toString(pItem->text(0)) );
  delete pItem;
 }
}

/** @brief The button to remove facets from the hidden facets was clicked. */
void DebtagsSettingsWidget::onRemoveClicked()
{
 QListViewItemIterator it(_pHiddenFacetsList, QListViewItemIterator::Selected);
 while ( it.current() ) 
 {
  QListViewItem* pItem = (*it); // make a temporary copy of the item
  new QListViewItem(_pShownFacetsList, pItem->text(0), pItem->text(1) );
  ++it;
  emit facetShown( toString(pItem->text(0)) );
  delete pItem;
 }
}

/** @brief Needed to add this as there is no way of changing the constructor in the designer.
  * Allways call this after construction.
  *
  * @param hiddenFacets the facets which are hidden
  */
void DebtagsSettingsWidget::init( const set<string>& hiddenFacets )
{
	/// @todo this should not be static, but a bug in libdebtags makes this neccessary
	static Debtags::Vocabulary vocabulary = Debtags::Environment::get().vocabulary();
	NDebtags::HiddenFacetsMatcher matcher(hiddenFacets);
	// iterate over all facets
	for ( Tagcoll::FacetSet::const_iterator it = vocabulary.begin(); it != vocabulary.end(); ++it )
	// iterate over the vocabulary, a vocabulary entry is a pair of <tag, Record>
	// the whole algorithm does only work, because the Vocabulary class' content is arranged in
	// a map, which assures: it->first < (it+1)->first (and this way app comes before app::myApp)
	{
		const Tagcoll::Facet& facet = *it;
		if (facet.name().empty()) // it seems that there is the global facet, which contains the facets..
			continue;
		if ( matcher.match(facet) ) // if the facet is not hidden
		{
			// add the facet to the view
			///@todo check wheter to use ldesc or sdesc here -> nothing seems to be useful
			new QListViewItem(_pShownFacetsList, facet.name(), facet.ldesc());
		}
		else
		{
			// add the facet to the view
			///@todo check wheter to use ldesc or sdesc here -> nothing seems to be useful
			new QListViewItem(_pHiddenFacetsList, facet.name(), facet.ldesc());
		}
	}
}

/** @brief This returns all facets that where selected to be hidden. */
set<string> DebtagsSettingsWidget::hiddenFacets()
{
	set<string> result;
	QListViewItemIterator it(_pHiddenFacetsList);
	while ( it.current() ) 
	{
		result.insert( toString((*it)->text(0)) );
		++it;
	}
 return result;
}

/** @brief This returns all facets that where selected to be shown. */
set<string> DebtagsSettingsWidget::shownFacets()
{
	set<string> result;
	QListViewItemIterator it(_pShownFacetsList);
	while ( it.current() ) 
	{
		result.insert( toString((*it)->text(0)) );
		++it;
	}
	return result;
}
