/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <iostream>
#include <sstream>
#include <map>
#include <list>

#include <assert.h>

#include <qapplication.h>
#include <qtimer.h>
#include <qstatusbar.h>
#include <qbutton.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qiconset.h>
#include <qpixmap.h>

#include "packagesearchaboutdlg.h"
#include "exception.h"
#include "packagelistviewitem.h"


using namespace std;

void PackageSearch::init()
{
	{ // search for the icon and doc pathes
		if  ( QFile("../doc/content.html").exists() )
		{
			QDir docDir = QDir::current();
			docDir.cd("../doc/");
			_docDir = docDir.absPath()+"/";
		}
		else if ( QFile("doc/content.html").exists() )
		{
			QDir docDir = QDir::current();
			docDir.cd("doc/");
			_docDir = docDir.absPath()+"/";
		}
		else if ( QFile("/usr/share/doc/packagesearch/content.html").exists() )
			_docDir = "/usr/share/doc/packagesearch/";
		else
			cerr << "Could not find doc directory. It must be located at "
			"/usr/share/doc/packagesearch/, ../doc/ or doc/."<<endl;
		if ( QFile("../icons/packagesearch.png").exists() )
			_iconDir = "../icons/";
		else if ( QFile("icons/packagesearch.png").exists() )
			_iconDir = "icons/";
		else if ( QFile("/usr/share/pixmaps/packagesearch.png").exists() )
			_iconDir = "/usr/share/pixmaps/";
		else
			cerr << "Could not find icon directory. It must located at "
			"/usr/share/pixmaps/, ../icons/ or icons/."<<endl;
	} // search the data paths
	QPixmap appIcon(_iconDir+"packagesearch.png");
	setIcon(appIcon);
	
	/** @todo The designer currently does not show the whatsThis slot, so I had to implement it by hand...*/
	connect(_pWhatsThisAction, SIGNAL(activated()), SLOT(whatsThis()));
	_pWhatsThisAction->setIconSet( QIconSet(QPixmap(_iconDir+"packagesearch-whatsThis.png")) );
	_pWhatsThisAction->addTo(_pToolbar);
	
	uint width = 700;
	uint height = 600;
	
	QValueList<int> sizes;
	sizes.push_back(width/2);
	sizes.push_back((width+1)/2);
	
	resize(width, height);
	_pUpperVSplitter->setSizes(sizes);
	_pLowerVSplitter->setSizes(sizes);


	updateBrowseToolbar();
}



/** @brief Updates the Details section in the Dialog (#_pDetailsView).
  *
  * Connected to the selectionChanged() signal from the package view (#_pPackageView).*/
void PackageSearch::onPackageSelectionChanged(QListViewItem* pItem)
{
	if ( pItem != 0 )
	{
		PackageListViewItem* pPackageItem = dynamic_cast<PackageListViewItem*>(pItem) ;
		selectNewPackage(pPackageItem->packageName());
	}
	else
	{
		_pDetailsView->clear();
	}
}

void PackageSearch::onClearSearch()
{
}


void PackageSearch::onLinkClicked( const QString & link)
{
	selectNewPackage(link);
}


void PackageSearch::onForward()
{
	setSelectedPackage(_viewHistory.forward());
	updateBrowseToolbar();
}


void PackageSearch::onBack()
{
	setSelectedPackage(_viewHistory.back());
	updateBrowseToolbar();
}

/** @brief This chooses the given package to be shown and adds it to the history if
  * different from the current entry.
  */
void PackageSearch::selectNewPackage( const QString & package)
{
	// reselect the package even if already selected to reflect changes due to a changed search
	setSelectedPackage(package);
	if ( _viewHistory.empty() || _viewHistory.current() != package)
	{
		_viewHistory.append(package);
		updateBrowseToolbar();
	}
}


/** Enables/ Disables the browse buttons */
void PackageSearch::updateBrowseToolbar()
{
	_pForwardButton->setEnabled(_viewHistory.forwardPossible());
	_pBackButton->setEnabled(_viewHistory.backPossible());
}

void PackageSearch::onHelpContentsAction()
{
	QDialog* pDlg = new QDialog(this);
	QVBoxLayout* pMainLayout = new QVBoxLayout(pDlg);
	QTextBrowser *pHelpWindow = new QTextBrowser(pDlg, "helpWindow"); 
	pHelpWindow->setCaption(tr("Package Search Help Page"));
	pHelpWindow->setSource(_docDir+"content.html");
	pMainLayout->add(pHelpWindow);
	pDlg->resize(520,560);
	pDlg->show();
}

void PackageSearch::onHelpAboutAction()
{
 PackageSearchAboutDlg dlg;
 // works only for txt files
 dlg._pLicenceDisplay->setSource(_docDir+"COPYING.txt");
 dlg.exec();
}


void PackageSearch::onPackageViewContextMenu(QListViewItem* pItem, const QPoint& pos)
{
}


/** @brief Sets the number of packages that were found.
  *
  * This information is displayed in the dialog. 
  * @param number number of packages found, hand -1 if no search is active */
void PackageSearch::setPackagesFound( int number )
{
 QString output("<font size=\"-1\">");
 if (number == -1)
  output += "No Search Active";
 else
 {
  output += QString().setNum(number)+" Packages Found";
 }
 output += ("</font>");
 _pPackagesFoundDisplay->setText(output);
}

void PackageSearch::showPackageInformation( const QString & package )
{
}


/** @brief This sets the package selected for display to package.
	*
	* It updates the combobox which shows the package which triggers the showPackageInformation()
	* function. It does not add an entry to the history.
	*/
void PackageSearch::setSelectedPackage( const QString & package )
{
	if (package != _currentPackage)
	{
		_currentPackage = package;
		// this triggers a selectNewPackage() call  but it returns immidiately because 
		// package == _currentPackage
		_pPackageSelection->setCurrentText(package);	
	}
	// reselect the package even if already selected to reflect changes due to a changed search
	showPackageInformation(package);
}


void PackageSearch::onInformationPageChanged( QWidget * pPage )
{

}


void PackageSearch::onControlPlugins()
{

}


void PackageSearch::onPluginSettings()
{

}


