/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.javagroups.util.Queue;
import org.javagroups.util.QueueClosedException;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueueTest
extends TestCase {
    private Queue queue;
    static /* synthetic */ Class class$org$javagroups$tests$QueueTest;

    public void setUp() {
        this.queue = new Queue();
    }

    public void tearDown() {
        this.queue.reset();
        this.queue = null;
    }

    public void testQueue() {
        try {
            this.queue.add("Q1");
            this.queue.add("Q2");
            this.queue.add("Q3");
            QueueTest.assertEquals((Object)"Q1", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q1", (Object)this.queue.remove());
            QueueTest.assertEquals((Object)"Q2", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q2", (Object)this.queue.remove());
            this.queue.addAtHead("Q4");
            this.queue.add("Q5");
            QueueTest.assertEquals((Object)"Q4", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q4", (Object)this.queue.remove());
            this.queue.close(true);
            try {
                this.queue.add("Q6");
                QueueTest.assertTrue((boolean)false);
            }
            catch (QueueClosedException qc) {
                QueueTest.assertTrue((boolean)true);
            }
            int size = this.queue.size();
            this.queue.removeElement("Q5");
            boolean bl = false;
            if (size - 1 == this.queue.size()) {
                bl = true;
            }
            QueueTest.assertTrue((boolean)bl);
            QueueTest.assertEquals((Object)"Q3", (Object)this.queue.peek());
            QueueTest.assertEquals((Object)"Q3", (Object)this.queue.remove());
            QueueTest.assertTrue((boolean)this.queue.closed());
            System.out.println("Everything is ok");
        }
        catch (Exception x) {
            System.out.println(x);
            QueueTest.assertTrue((boolean)false);
        }
    }

    public void testLargeInsertion() {
        String element = "MyElement";
        try {
            System.out.println("Inserting 100000 elements");
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < 100000) {
                this.queue.add(element);
                ++i;
            }
            long stop = System.currentTimeMillis();
            System.out.println("Took " + (stop - start) + " msecs");
            System.out.println("Removing 100000 elements");
            start = System.currentTimeMillis();
            while (this.queue.size() > 0) {
                this.queue.remove();
            }
            stop = System.currentTimeMillis();
            System.out.println("Took " + (stop - start) + " msecs");
        }
        catch (Exception ex) {
            System.err.println(ex);
            QueueTest.assertTrue((boolean)false);
        }
    }

    public void testEmptyQueue() {
        QueueTest.assertNull((Object)this.queue.getFirst());
        QueueTest.assertNull((Object)this.queue.getLast());
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
    }

    public void testInsertionAndRemoval() throws Exception {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        this.queue.add(s1);
        boolean bl = false;
        if (this.queue.getFirst() != null) {
            bl = true;
        }
        QueueTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (this.queue.getLast() != null) {
            bl2 = true;
        }
        QueueTest.assertTrue((boolean)bl2);
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        this.queue.add(s2);
        boolean bl3 = false;
        if (this.queue.getFirst() != this.queue.getLast()) {
            bl3 = true;
        }
        QueueTest.assertTrue((boolean)bl3);
        Object o1 = this.queue.peek();
        Object o2 = this.queue.getFirst();
        boolean bl4 = false;
        if ("o1=" + o1 + ", o2=" + o2 + ", o1 == o2=" + o1 == o2 + ", o1.equals(o2)=" + o1.equals(o2)) {
            bl4 = true;
        }
        System.out.println(bl4);
        QueueTest.assertEquals((Object)this.queue.peek(), (Object)this.queue.getFirst());
        this.queue.remove();
        boolean bl5 = false;
        if (this.queue.size() == 1) {
            bl5 = true;
        }
        QueueTest.assertTrue((boolean)bl5);
        QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        this.queue.remove();
        boolean bl6 = false;
        if (this.queue.size() == 0) {
            bl6 = true;
        }
        QueueTest.assertTrue((boolean)bl6);
        boolean bl7 = false;
        if (this.queue.getFirst() == null) {
            bl7 = true;
        }
        QueueTest.assertTrue((boolean)bl7);
        boolean bl8 = false;
        if (this.queue.getLast() == null) {
            bl8 = true;
        }
        QueueTest.assertTrue((boolean)bl8);
    }

    public void testRemoveElementNoElement() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.removeElement(s1);
            QueueTest.assertTrue((boolean)(this.queue.closed() ^ true));
            boolean bl = false;
            if (this.queue.size() == 0) {
                bl = true;
            }
            QueueTest.assertTrue((boolean)bl);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementOneElement() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.removeElement(s1);
            boolean bl = false;
            if (this.queue.size() == 0) {
                bl = true;
            }
            QueueTest.assertTrue((boolean)bl);
            boolean bl2 = false;
            if (this.queue.getFirst() == null) {
                bl2 = true;
            }
            QueueTest.assertTrue((boolean)bl2);
            boolean bl3 = false;
            if (this.queue.getLast() == null) {
                bl3 = true;
            }
            QueueTest.assertTrue((boolean)bl3);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementTwoElementsFirstFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.removeElement(s1);
            boolean bl = false;
            if (this.queue.size() == 1) {
                bl = true;
            }
            QueueTest.assertTrue((boolean)bl);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementTwoElementsSecondFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.removeElement(s2);
            boolean bl = false;
            if (this.queue.size() == 1) {
                bl = true;
            }
            QueueTest.assertTrue((boolean)bl);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)this.queue.getLast());
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsFirstFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s1);
            boolean bl = false;
            if (this.queue.size() == 2) {
                bl = true;
            }
            QueueTest.assertTrue((boolean)bl);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s2);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s3);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsSecondFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s2);
            boolean bl = false;
            if (this.queue.size() == 2) {
                bl = true;
            }
            QueueTest.assertTrue((boolean)bl);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s3);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testRemoveElementThreeElementsThirdFound() {
        String s1 = "Q1";
        String s2 = "Q2";
        String s3 = "Q3";
        try {
            this.queue.add(s1);
            this.queue.add(s2);
            this.queue.add(s3);
            this.queue.removeElement(s3);
            boolean bl = false;
            if (this.queue.size() == 2) {
                bl = true;
            }
            QueueTest.assertTrue((boolean)bl);
            QueueTest.assertEquals((Object)this.queue.getFirst(), (Object)s1);
            QueueTest.assertEquals((Object)this.queue.getLast(), (Object)s2);
        }
        catch (QueueClosedException ex) {
            QueueTest.fail((String)ex.toString());
        }
    }

    public void testBarrier() {
        RemoveOneItem[] removers = new RemoveOneItem[10];
        int num_dead = 0;
        int i = 0;
        while (i < removers.length) {
            removers[i] = new RemoveOneItem(i);
            removers[i].start();
            ++i;
        }
        Util.sleep(1000L);
        System.out.println("-- adding element 99");
        try {
            this.queue.add(new Long(99L));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Util.sleep(5000L);
        System.out.println("-- adding element 100");
        try {
            this.queue.add(new Long(100L));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        Util.sleep(1000L);
        i = 0;
        while (i < removers.length) {
            System.out.println("remover #" + i + " is " + (removers[i].isAlive() ? "alive" : "terminated"));
            if (!removers[i].isAlive()) {
                ++num_dead;
            }
            ++i;
        }
        QueueTest.assertEquals((int)num_dead, (int)2);
    }

    public void testConcurrentAccess() {
        int NUM_THREADS = 10;
        int INTERVAL = 20000;
        Writer[] writers = new Writer[10];
        Reader[] readers = new Reader[10];
        int[] writes = new int[10];
        int[] reads = new int[10];
        long total_reads = 0L;
        long total_writes = 0L;
        int i = 0;
        while (i < writers.length) {
            readers[i] = new Reader(i, reads);
            readers[i].start();
            writers[i] = new Writer(i, writes);
            writers[i].start();
            ++i;
        }
        Util.sleep(20000L);
        System.out.println("current queue size=" + this.queue.size());
        i = 0;
        while (i < writers.length) {
            writers[i].stopThread();
            ++i;
        }
        i = 0;
        while (i < readers.length) {
            readers[i].stopThread();
            ++i;
        }
        this.queue.close(false);
        System.out.println("current queue size=" + this.queue.size());
        i = 0;
        while (i < writers.length) {
            try {
                writers[i].join(300L);
                readers[i].join(300L);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
            ++i;
        }
        i = 0;
        while (i < writes.length) {
            System.out.println("Thread #" + i + ": " + writes[i] + " writes, " + reads[i] + " reads");
            total_writes += (long)writes[i];
            total_reads += (long)reads[i];
            ++i;
        }
        System.out.println("total writes=" + total_writes + ", total_reads=" + total_reads + ", diff=" + Math.abs(total_writes - total_reads));
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class clazz = class$org$javagroups$tests$QueueTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$QueueTest = QueueTest.class$("[Lorg.javagroups.tests.QueueTest;", false);
        }
        stringArray[0] = clazz.getName();
        String[] testCaseName = stringArray;
        TestRunner.main((String[])testCaseName);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.queue = null;
    }

    public QueueTest(String Name_) {
        super(Name_);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class RemoveOneItem
    extends Thread {
        Long retval;
        int rank;

        public void run() {
            try {
                this.retval = (Long)QueueTest.this.queue.remove();
                System.out.println("Thread #" + this.rank + " removed element (" + this.retval + ')');
            }
            catch (QueueClosedException closed) {
                System.err.println("Thread #" + this.rank + ": queue was closed");
            }
        }

        Long getRetval() {
            return this.retval;
        }

        private final /* synthetic */ void this() {
            this.retval = null;
            this.rank = 0;
        }

        RemoveOneItem(int rank) {
            super("RemoveOneItem thread #" + rank);
            this.this();
            this.rank = rank;
            this.setDaemon(true);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Writer
    extends Thread {
        int rank;
        int num_writes;
        boolean running;
        int[] writes;

        public void run() {
            while (this.running) {
                try {
                    QueueTest.this.queue.add(new Long(System.currentTimeMillis()));
                    ++this.num_writes;
                }
                catch (QueueClosedException closed) {
                    this.running = false;
                }
                catch (Throwable t) {
                    System.err.println("QueueTest.Writer.run(): exception=" + t);
                }
            }
            this.writes[this.rank] = this.num_writes;
        }

        void stopThread() {
            this.running = false;
        }

        private final /* synthetic */ void this() {
            this.rank = 0;
            this.num_writes = 0;
            this.running = true;
            this.writes = null;
        }

        Writer(int i, int[] writes) {
            super("WriterThread");
            this.this();
            this.rank = i;
            this.writes = writes;
            this.setDaemon(true);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Reader
    extends Thread {
        int rank;
        int num_reads;
        int[] reads;
        boolean running;

        public void run() {
            while (this.running) {
                try {
                    Long el = (Long)QueueTest.this.queue.remove();
                    if (el == null) {
                        System.out.println("QueueTest.Reader.run(): peek() returned null element. queue.size()=" + QueueTest.this.queue.size() + ", queue.closed()=" + QueueTest.this.queue.closed());
                    }
                    QueueTest.assertNotNull((Object)el);
                    ++this.num_reads;
                }
                catch (QueueClosedException closed) {
                    this.running = false;
                }
                catch (Throwable t) {
                    System.err.println("QueueTest.Reader.run(): exception=" + t);
                }
            }
            this.reads[this.rank] = this.num_reads;
        }

        void stopThread() {
            this.running = false;
        }

        private final /* synthetic */ void this() {
            this.num_reads = 0;
            this.reads = null;
            this.running = true;
        }

        Reader(int i, int[] reads) {
            super("ReaderThread");
            this.this();
            this.rank = i;
            this.reads = reads;
            this.setDaemon(true);
        }
    }
}

