/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.stack.AckMcastSenderWindow;
import org.javagroups.stack.IpAddress;

public class AckMcastSenderWindowTest
extends TestCase {
    private static Address[] _RECVS = new Address[]{new IpAddress("localhost", 5000), new IpAddress("localhost", 5001), new IpAddress("localhost", 5002)};
    private AckMcastSenderWindow.RetransmitCommand _cmd;
    private AckMcastSenderWindow _win;
    private Hashtable _tbl;
    static /* synthetic */ Class class$org$javagroups$tests$AckMcastSenderWindowTest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _put(long seqno, Address addr) {
        Hashtable hashtable = this._tbl;
        synchronized (hashtable) {
            block6: {
                ArrayList<Address> list;
                block5: {
                    list = (ArrayList<Address>)this._tbl.get(new Long(seqno));
                    if (list == null) {
                        list = new ArrayList<Address>();
                        this._tbl.put(new Long(seqno), list);
                    }
                    if (list.contains(addr)) break block5;
                    list.add(addr);
                    break block6;
                }
                if (list.isEmpty()) {
                    this._tbl.remove(new Long(seqno));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _remove(long seqno, Address addr) {
        Hashtable hashtable = this._tbl;
        synchronized (hashtable) {
            List list = (List)this._tbl.get(new Long(seqno));
            if (list == null) {
                return;
            }
            list.remove(addr);
            if (list.isEmpty()) {
                this._tbl.remove(new Long(seqno));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean _contains(long seqno, Address addr) {
        Hashtable hashtable = this._tbl;
        synchronized (hashtable) {
            List list = (List)this._tbl.get(new Long(seqno));
            if (list == null) {
                return false;
            }
            return list.contains(addr);
        }
    }

    private final void _ackerRun() {
        this._win.ack(2, _RECVS[2]);
        this._remove(2, _RECVS[2]);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this._win.ack(1L, _RECVS[1]);
        this._remove(1L, _RECVS[1]);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this._win.ack(1L, _RECVS[0]);
        this._remove(1L, _RECVS[0]);
        this._win.ack(2, _RECVS[0]);
        this._remove(2, _RECVS[0]);
        this._win.ack(2, _RECVS[1]);
        this._remove(2, _RECVS[1]);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this._win.ack(1L, _RECVS[2]);
        this._remove(1L, _RECVS[2]);
    }

    private final void _retransmit(long seqno, Message msg, Address addr) {
        if (!this._contains(seqno, addr)) {
            AckMcastSenderWindowTest.fail((String)"Acknowledging a non-existent msg, great!");
        } else {
            System.out.println("retransmitting " + seqno);
        }
    }

    public void test1() {
        Vector<Address> dests = new Vector<Address>();
        Message msg = new Message();
        Acker acker = new Acker();
        int i = 0;
        while (i < _RECVS.length) {
            dests.add(_RECVS[i]);
            ++i;
        }
        long seqno = 1L;
        i = 0;
        while (i < _RECVS.length) {
            this._put(seqno, _RECVS[i]);
            ++i;
        }
        this._win.add(seqno, msg, dests);
        seqno = 2;
        i = 0;
        while (i < _RECVS.length) {
            this._put(seqno, _RECVS[i]);
            ++i;
        }
        this._win.add(seqno, msg, dests);
        acker.start();
        try {
            acker.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this._win.stop();
    }

    public void testRemove() {
        AckMcastSenderWindow mywin = new AckMcastSenderWindow((AckMcastSenderWindow.RetransmitCommand)new MyCommand(), new long[]{1000L, 2000L, 3000L});
        IpAddress sender1 = new IpAddress("127.0.0.1", 10000);
        IpAddress sender2 = new IpAddress("127.0.0.1", 10001);
        IpAddress sender3 = new IpAddress("127.0.0.1", 10002);
        Vector<IpAddress> senders = new Vector<IpAddress>();
        Message msg = new Message();
        long seqno = 322649L;
        senders.addElement(sender1);
        senders.addElement(sender2);
        senders.addElement(sender3);
        mywin.add(seqno, msg, (Vector)senders.clone());
        mywin.ack(seqno, sender1);
        mywin.ack(seqno, sender2);
        System.out.println("entry is " + mywin.printDetails(seqno));
        boolean bl = false;
        if (mywin.getNumberOfResponsesExpected(seqno) == (long)3) {
            bl = true;
        }
        AckMcastSenderWindowTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (mywin.getNumberOfResponsesReceived(seqno) == (long)2) {
            bl2 = true;
        }
        AckMcastSenderWindowTest.assertTrue((boolean)bl2);
        mywin.waitUntilAllAcksReceived(4000L);
        mywin.suspect(sender3);
        boolean bl3 = false;
        if (mywin.size() == 0L) {
            bl3 = true;
        }
        AckMcastSenderWindowTest.assertTrue((boolean)bl3);
    }

    public void setUp() {
        this._cmd = new Cmd();
        this._win = new AckMcastSenderWindow(this._cmd);
        this._tbl = new Hashtable();
    }

    public void tearDown() {
        this._win.stop();
    }

    public static Test suite() {
        Class clazz = class$org$javagroups$tests$AckMcastSenderWindowTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$AckMcastSenderWindowTest = AckMcastSenderWindowTest.class$("[Lorg.javagroups.tests.AckMcastSenderWindowTest;", false);
        }
        TestSuite suite = new TestSuite(clazz);
        return suite;
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class clazz = class$org$javagroups$tests$AckMcastSenderWindowTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$AckMcastSenderWindowTest = AckMcastSenderWindowTest.class$("[Lorg.javagroups.tests.AckMcastSenderWindowTest;", false);
        }
        stringArray[0] = clazz.getName();
        String[] name = stringArray;
        TestRunner.main((String[])name);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AckMcastSenderWindowTest(String name) {
        super(name);
    }

    private class Cmd
    implements AckMcastSenderWindow.RetransmitCommand {
        public void retransmit(long seqno, Message msg, Address addr) {
            AckMcastSenderWindowTest.this._retransmit(seqno, msg, addr);
        }

        private Cmd() {
        }
    }

    private class Acker
    extends Thread {
        public void run() {
            AckMcastSenderWindowTest.this._ackerRun();
        }

        private Acker() {
        }
    }

    class MyCommand
    implements AckMcastSenderWindow.RetransmitCommand {
        public void retransmit(long seqno, Message msg, Address dest) {
            System.out.println("-- retransmitting " + seqno);
        }

        MyCommand() {
        }
    }
}

