/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.Socket;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.protocols.TunnelHeader;
import org.javagroups.stack.IpAddress;
import org.javagroups.util.List;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RouterStub {
    String router_host;
    int router_port;
    Socket sock;
    DataOutputStream output;
    DataInputStream input;
    Address local_addr;
    final long RECONNECT_TIMEOUT = 5000L;
    boolean connected;
    private volatile boolean reconnect;

    public Address connect() throws Exception {
        Address ret = null;
        int len = 0;
        try {
            this.sock = new Socket(this.router_host, this.router_port);
            this.sock.setSoLinger(true, 500);
            this.input = new DataInputStream(this.sock.getInputStream());
            len = this.input.readInt();
            byte[] buf = new byte[len];
            this.input.readFully(buf);
            ret = (Address)Util.objectFromByteBuffer(buf);
            this.output = new DataOutputStream(this.sock.getOutputStream());
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            throw e;
        }
        if (ret == null && this.sock != null) {
            ret = new IpAddress(this.sock.getLocalPort());
        }
        if (this.local_addr == null) {
            this.local_addr = ret;
        }
        return ret;
    }

    public void disconnect() {
        if (this.output != null) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.sock != null) {
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connected = false;
        this.reconnect = false;
    }

    public boolean register(String groupname) {
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            Trace.error("RouterStub.register()", "No connection to router (groupname=" + groupname + ')');
            this.connected = false;
            return false;
        }
        if (groupname == null || groupname.length() == 0) {
            Trace.error("RouterStub.register()", "groupname is null");
            return false;
        }
        if (this.local_addr == null) {
            Trace.error("RouterStub.register()", "local_addr is null");
            return false;
        }
        try {
            buf = Util.objectToByteBuffer(this.local_addr);
            this.output.writeInt(-11);
            this.output.writeUTF(groupname);
            this.output.writeInt(buf.length);
            this.output.write(buf, 0, buf.length);
            this.output.flush();
        }
        catch (Exception e) {
            Trace.error("RouterStub.register()", Trace.getStackTrace(e));
            this.connected = false;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List get(String groupname) {
        block32: {
            block31: {
                block26: {
                    block30: {
                        block29: {
                            block25: {
                                ret = null;
                                tmpsock = null;
                                output = null;
                                input = null;
                                if (groupname == null || groupname.length() == 0) {
                                    Trace.error("RouterStub.get()", "groupname is null");
                                    return null;
                                }
                                try {
                                    try {
                                        tmpsock = new Socket(this.router_host, this.router_port);
                                        tmpsock.setSoLinger(true, 500);
                                        input = new DataInputStream(tmpsock.getInputStream());
                                        len = input.readInt();
                                        buf = new byte[len];
                                        input.readFully(buf);
                                        output = new DataOutputStream(tmpsock.getOutputStream());
                                        output.writeInt(-10);
                                        output.writeUTF(groupname);
                                        len = input.readInt();
                                        if (len == 0) {
                                            var10_8 = null;
                                            var9_9 = null;
                                            break block25;
                                        }
                                        buf = new byte[len];
                                        input.readFully(buf);
                                        ret = (List)Util.objectFromByteBuffer(buf);
                                    }
                                    catch (Exception e) {
                                        Trace.error("RouterStub.get()", "exception=" + e);
                                    }
                                    break block26;
                                }
                                catch (Throwable var8_16) {
                                    var9_10 = null;
                                    try {
                                        if (output != null) {
                                            output.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    try {
                                        if (input != null) {
                                            input.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    try {
                                        if (tmpsock == null) throw var8_16;
                                        tmpsock.close();
                                        throw var8_16;
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    throw var8_16;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [4 : 196->209)] { 
lbl58:
                            // 1 sources

                            if (output != null) {
                                output.close();
                            }
                            break block29;
lbl61:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [5 : 211->224)] { 
lbl65:
                        // 1 sources

                        if (input != null) {
                            input.close();
                        }
                        break block30;
lbl68:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [6 : 226->237)] { 
lbl72:
                    // 1 sources

                    if (tmpsock == null) return var10_8;
                    tmpsock.close();
                    return var10_8;
lbl75:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return var10_8;
                }
                var9_11 = null;
                ** try [egrp 2[TRYBLOCK] [4 : 196->209)] { 
lbl81:
                // 1 sources

                if (output != null) {
                    output.close();
                }
                break block31;
lbl84:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [5 : 211->224)] { 
lbl88:
            // 1 sources

            if (input != null) {
                input.close();
            }
            break block32;
lbl91:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {
            return ret;
        }
        if (tmpsock == null) return ret;
        tmpsock.close();
        return ret;
    }

    public boolean send(Message msg, String groupname) {
        byte[] msg_buf = null;
        byte[] dst_buf = null;
        Address dst_addr = null;
        if (this.sock == null || this.output == null || this.input == null) {
            Trace.error("RouterStub.send()", "No connection to router (groupname=" + groupname + ')');
            this.connected = false;
            return false;
        }
        if (msg == null) {
            Trace.error("RouterStub.send()", "Message is null");
            return false;
        }
        try {
            dst_addr = msg.getDest();
            if (dst_addr != null) {
                dst_buf = Util.objectToByteBuffer(dst_addr);
            }
            msg_buf = Util.objectToByteBuffer(msg);
            this.output.writeUTF(groupname);
            if (dst_buf != null && dst_buf.length > 0) {
                this.output.writeInt(dst_buf.length);
                this.output.write(dst_buf, 0, dst_buf.length);
            } else {
                this.output.writeInt(0);
            }
            this.output.writeInt(msg_buf.length);
            this.output.write(msg_buf, 0, msg_buf.length);
        }
        catch (Exception e) {
            Trace.error("RouterStub.send()", Trace.getStackTrace(e));
            this.connected = false;
            return false;
        }
        return true;
    }

    public Message receive() {
        Message ret = null;
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            Trace.error("RouterStub.receive()", "No connection to router");
            this.connected = false;
            return null;
        }
        try {
            int len = this.input.readInt();
            if (len == 0) {
                ret = null;
            } else {
                buf = new byte[len];
                this.input.readFully(buf, 0, len);
                ret = (Message)Util.objectFromByteBuffer(buf);
            }
        }
        catch (Exception e) {
            this.connected = false;
            Trace.error("RouterStub.receive()", Trace.getStackTrace(e));
            return null;
        }
        return ret;
    }

    public synchronized boolean reconnect() {
        Address new_addr = null;
        if (this.connected) {
            return false;
        }
        this.disconnect();
        this.reconnect = true;
        while (this.reconnect) {
            try {
                new_addr = this.connect();
                if (new_addr != null) {
                    break;
                }
            }
            catch (Exception ex) {
                Trace.warn("RouterStub.reconnect()", "exception is " + ex);
            }
            Util.sleep(5000L);
        }
        if (new_addr == null) {
            return false;
        }
        Trace.warn("RouterStub.reconnect()", "Client reconnected, new addess is " + new_addr);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("RouterStub <host> <port>");
            return;
        }
        RouterStub stub = new RouterStub(args[0], new Integer(args[1]));
        String groupname = "BelaGroup";
        try {
            try {
                Message msg;
                Address my_addr = stub.connect();
                System.out.println("My address is " + my_addr);
                System.out.println("Registering under BelaGroup");
                boolean rc = stub.register("BelaGroup");
                System.out.println("Done, rc=" + rc);
                System.out.println("Getting members of BelaGroup: ");
                List mbrs = stub.get("BelaGroup");
                System.out.println("Done, mbrs are " + mbrs);
                int i = 0;
                while (true) {
                    if (i >= 10) {
                        i = 0;
                        break;
                    }
                    msg = new Message(null, my_addr, (Serializable)((Object)("Bela #" + i)));
                    msg.putHeader("TUNNEL", new TunnelHeader("BelaGroup"));
                    rc = stub.send(msg, "BelaGroup");
                    System.out.println("Sent msg, rc=" + rc);
                    ++i;
                }
                while (i < 10) {
                    System.out.println("stub.receive():");
                    msg = stub.receive();
                    System.out.println("Received msg");
                    ++i;
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            stub.disconnect();
            throw throwable;
        }
        {
            Object var8_11 = null;
            stub.disconnect();
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.router_host = null;
        this.router_port = 0;
        this.sock = null;
        this.output = null;
        this.input = null;
        this.local_addr = null;
        this.RECONNECT_TIMEOUT = 5000L;
        this.connected = false;
        this.reconnect = false;
    }

    public RouterStub(String router_host, int router_port) {
        this.this();
        this.router_host = router_host != null ? router_host : "localhost";
        this.router_port = router_port;
    }
}

