/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.Interval;
import org.javagroups.util.TimeScheduler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AckMcastSenderWindow {
    private static final long SEC = 1000L;
    private static final long[] RETRANSMIT_TIMEOUTS = new long[]{2000L, 3000L, 5000L, 8000L};
    private static final long SUSPEND_TIMEOUT = 2000L;
    private Hashtable msgs;
    private LinkedList suspects;
    private int max_suspects;
    private Vector stable_msgs;
    private boolean waiting;
    private boolean retransmitter_owned;
    private TimeScheduler retransmitter;
    private long[] retransmit_intervals;
    private RetransmitCommand cmd;

    private static final String _toString(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _retransmit(Entry entry) {
        Entry entry2 = entry;
        synchronized (entry2) {
            Enumeration e = entry.senders.keys();
            while (e.hasMoreElements()) {
                Address sender = (Address)e.nextElement();
                boolean received = (Boolean)entry.senders.get(sender);
                if (received) continue;
                if (this.suspects.contains(sender)) {
                    if (Trace.trace) {
                        Trace.warn("AckMcastSenderWindow._retransmit()", "removing " + sender + " from retransmit list as it is in the suspect list");
                    }
                    this.remove(sender);
                    continue;
                }
                if (Trace.trace) {
                    Trace.info("AckMcastSenderWindow", "--> retransmitting msg #" + entry.seqno + " to " + sender);
                }
                this.cmd.retransmit(entry.seqno, entry.msg.copy(), sender);
            }
            return;
        }
    }

    private final void init(RetransmitCommand cmd, long[] retransmit_intervals, TimeScheduler sched, boolean sched_owned) {
        if (cmd == null) {
            Trace.error("AckMcastSenderWindow", "command is null. Cannot retransmit messages !");
            throw new IllegalArgumentException("cmd");
        }
        this.retransmitter_owned = sched_owned;
        this.retransmitter = sched;
        this.retransmit_intervals = retransmit_intervals;
        this.cmd = cmd;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(long seqno, Message msg, Vector receivers) {
        if (this.waiting) {
            return;
        }
        if (receivers.size() == 0) {
            return;
        }
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            if (this.msgs.get(new Long(seqno)) != null) {
                return;
            }
            Entry e = new Entry(seqno, msg, receivers, this.retransmit_intervals);
            this.msgs.put(new Long(seqno), e);
            this.retransmitter.add(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void ack(long seqno, Address sender) {
        block15: {
            var6_3 = this.msgs;
            // MONITORENTER : var6_3
            entry = (Entry)this.msgs.get(new Long(seqno));
            if (entry == null) {
                // MONITOREXIT : var6_3
                return;
            }
            var8_5 = entry;
            // MONITORENTER : var8_5
            ** try [egrp 3[TRYBLOCK] [4 : 57->144)] { 
lbl13:
            // 1 sources

            {
                received = (Boolean)entry.senders.get(sender);
                if (received == null || received.booleanValue()) {
                    // MONITOREXIT : var8_5
                    // MONITOREXIT : var6_3
                    return;
                }
                entry.senders.put(sender, new Boolean(true));
                ++entry.num_received;
                if (!entry.allReceived()) {
                    // MONITOREXIT : var8_5
                    // MONITOREXIT : var6_3
                    return;
                }
                // MONITOREXIT : var8_5
                break block15;
            }
lbl32:
            // 2 sources

            catch (Throwable v1) {
                // MONITOREXIT : var8_5
                throw v1;
            }
        }
        var8_5 = this.stable_msgs;
        // MONITORENTER : var8_5
        entry.cancel();
        this.msgs.remove(new Long(seqno));
        this.stable_msgs.add(new Long(seqno));
        // MONITOREXIT : var8_5
        this.msgs.notify();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Address obj) {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            Enumeration e = this.msgs.keys();
            while (e.hasMoreElements()) {
                Long key = (Long)e.nextElement();
                Entry entry = (Entry)this.msgs.get(key);
                Object object = entry;
                synchronized (object) {
                    Boolean received = (Boolean)entry.senders.remove(obj);
                    if (received == null) {
                        continue;
                    }
                    if (received.booleanValue()) {
                        --entry.num_received;
                    }
                    if (!entry.allReceived()) {
                        continue;
                    }
                }
                object = this.stable_msgs;
                synchronized (object) {
                    entry.cancel();
                    this.msgs.remove(key);
                    this.stable_msgs.add(key);
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 6, 10] lbl41 : MonitorExitStatement: MONITOREXIT : var7_6
                    this.msgs.notify();
                }
            }
            return;
        }
    }

    public void suspect(Address suspected) {
        if (Trace.trace) {
            Trace.info("AckMcastSenderWindow.suspect()", "suspect is " + suspected);
        }
        this.remove(suspected);
        this.suspects.add(suspected);
        if (this.suspects.size() >= this.max_suspects) {
            this.suspects.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getStableMessages() {
        Vector vector = this.stable_msgs;
        synchronized (vector) {
            Vector retval;
            Vector vector2 = retval = this.stable_msgs.size() > 0 ? (Vector)this.stable_msgs.clone() : null;
            if (this.stable_msgs.size() > 0) {
                this.stable_msgs.clear();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearStableMessages() {
        Vector vector = this.stable_msgs;
        synchronized (vector) {
            this.stable_msgs.clear();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long size() {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            return this.msgs.size();
        }
    }

    public long getNumberOfResponsesExpected(long seqno) {
        Entry entry = (Entry)this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.senders.size();
        }
        return -1;
    }

    public long getNumberOfResponsesReceived(long seqno) {
        Entry entry = (Entry)this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.num_received;
        }
        return -1;
    }

    public String printDetails(long seqno) {
        Entry entry = (Entry)this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilAllAcksReceived(long timeout) {
        block15: {
            Hashtable hashtable;
            Iterator it = this.suspects.iterator();
            while (it.hasNext()) {
                Address suspect = (Address)it.next();
                this.remove(suspect);
            }
            long time_to_wait = timeout;
            this.waiting = true;
            if (timeout <= 0L) {
                hashtable = this.msgs;
                synchronized (hashtable) {
                    while (true) {
                        if (this.msgs.size() <= 0) {
                            break block15;
                        }
                        try {
                            this.msgs.wait();
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                }
            }
            long start_time = System.currentTimeMillis();
            hashtable = this.msgs;
            synchronized (hashtable) {
                long current_time;
                while (this.msgs.size() > 0 && (time_to_wait = timeout - ((current_time = System.currentTimeMillis()) - start_time)) > 0L) {
                    try {
                        this.msgs.wait(time_to_wait);
                    }
                    catch (InterruptedException ex) {
                        Trace.warn("AckMcastSenderWindow.waitUntilAllAcksReceived()", ex.toString());
                    }
                }
            }
        }
        this.waiting = false;
    }

    public void start() {
        if (this.retransmitter_owned) {
            this.retransmitter.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            block7: {
                block6: {
                    if (!this.retransmitter_owned) break block6;
                    try {
                        this.retransmitter.stop();
                    }
                    catch (InterruptedException ex) {
                        Trace.error("AckMcastSenderWindow.stop()", AckMcastSenderWindow._toString(ex));
                    }
                    break block7;
                }
                Enumeration e = this.msgs.elements();
                while (e.hasMoreElements()) {
                    Entry entry = (Entry)e.nextElement();
                    entry.cancel();
                }
            }
            this.msgs.clear();
            this.msgs.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        if (this.waiting) {
            return;
        }
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            Enumeration e = this.msgs.elements();
            while (true) {
                if (!e.hasMoreElements()) {
                    this.msgs.clear();
                    this.msgs.notify();
                    return;
                }
                Entry entry = (Entry)e.nextElement();
                entry.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        ret = new StringBuffer();
        var4_2 = this.msgs;
        synchronized (var4_2) {
            ret.append("msgs: (" + this.msgs.size() + ')');
            e = this.msgs.keys();
            if (true) ** GOTO lbl16
            do {
                key = (Long)e.nextElement();
                entry = (Entry)this.msgs.get(key);
                ret.append("key = " + key + ", value = " + entry + '\n');
lbl16:
                // 2 sources

            } while (e.hasMoreElements());
            var7_3 = this.stable_msgs;
            synchronized (var7_3) {
                ret.append("\nstable_msgs: " + this.stable_msgs);
                return ret.toString();
            }
        }
    }

    private final /* synthetic */ void this() {
        this.msgs = new Hashtable();
        this.suspects = new LinkedList();
        this.max_suspects = 20;
        this.stable_msgs = new Vector();
        this.waiting = false;
        this.retransmitter = null;
        this.cmd = null;
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, long[] retransmit_intervals, TimeScheduler sched) {
        this.this();
        this.init(cmd, retransmit_intervals, sched, false);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, TimeScheduler sched) {
        this.this();
        this.init(cmd, RETRANSMIT_TIMEOUTS, sched, false);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, long[] retransmit_intervals) {
        this.this();
        this.init(cmd, retransmit_intervals, new TimeScheduler(2000L), true);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd) {
        this(cmd, RETRANSMIT_TIMEOUTS);
    }

    private static abstract class Task
    implements TimeScheduler.Task {
        private Interval intervals;
        private boolean cancelled;

        public long nextInterval() {
            return this.intervals.next();
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        protected Task(long[] intervals) {
            this.intervals = new Interval(intervals);
            this.cancelled = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Entry
    extends Task {
        public long seqno;
        public Message msg;
        public Hashtable senders;
        public int num_received;

        boolean allReceived() {
            boolean bl = false;
            if (this.num_received >= this.senders.size()) {
                bl = true;
            }
            return bl;
        }

        public void run() {
            AckMcastSenderWindow.this._retransmit(this);
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("num_received = " + this.num_received + ", received msgs = " + this.senders);
            return buff.toString();
        }

        private final /* synthetic */ void this() {
            this.msg = null;
            this.senders = new Hashtable();
            this.num_received = 0;
        }

        public Entry(long seqno, Message msg, Vector dests, long[] intervals) {
            super(intervals);
            this.this();
            this.seqno = seqno;
            this.msg = msg;
            int i = 0;
            while (i < dests.size()) {
                this.senders.put(dests.elementAt(i), new Boolean(false));
                ++i;
            }
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3, Address var4);
    }
}

