/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Transport;
import org.javagroups.View;
import org.javagroups.blocks.PullPushAdapter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Topology
extends Frame
implements WindowListener,
MembershipListener {
    private Vector members;
    private Font font;
    private FontMetrics fm;
    private Color node_color;
    private boolean coordinator;
    private final int NormalStyle = 0;
    private final int CheckStyle = 1;
    private Channel channel;
    private Object my_addr;
    private final String channel_name = "FD-Heartbeat";

    public void addNode(Object member) {
        int i = 0;
        while (i < this.members.size()) {
            Object tmp = this.members.elementAt(i);
            if (member.equals(tmp)) {
                return;
            }
            ++i;
        }
        this.members.addElement(member);
        this.repaint();
    }

    public void removeNode(Object member) {
        int i = 0;
        while (i < this.members.size()) {
            Object tmp = this.members.elementAt(i);
            if (member.equals(tmp)) {
                this.members.removeElement(this.members.elementAt(i));
                break;
            }
            ++i;
        }
        this.repaint();
    }

    public void drawNode(Graphics g, int x, int y, String label, int style) {
        Color old = g.getColor();
        int width = this.fm.stringWidth(label) + 10;
        int height = this.fm.getHeight() + 5;
        g.setColor(this.node_color);
        g.fillRect(x, y, width, height);
        g.setColor(old);
        g.drawString(label, x + 5, y + 15);
        g.drawRoundRect(x - 1, y - 1, width + 1, height + 1, 10, 10);
        if (style == 1) {
            g.drawRoundRect(x - 2, y - 2, width + 2, height + 2, 10, 10);
            g.drawRoundRect(x - 3, y - 3, width + 3, height + 3, 10, 10);
        }
    }

    public void drawTopology(Graphics g) {
        int x = 20;
        int y = 50;
        Dimension box = this.getSize();
        Color old = g.getColor();
        if (this.coordinator) {
            g.setColor(Color.cyan);
            g.fillRect(11, 31, box.width - 21, box.height - 61);
            g.setColor(old);
        }
        g.drawRect(10, 30, box.width - 20, box.height - 60);
        g.setFont(this.font);
        int i = 0;
        while (i < this.members.size()) {
            String label = this.members.elementAt(i).toString();
            this.drawNode(g, x, y, label, 0);
            y += 50;
            ++i;
        }
    }

    public void paint(Graphics g) {
        this.drawTopology(g);
    }

    public void viewAccepted(View view) {
        this.setState(view.getMembers());
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void setState(Vector mbrs) {
        this.members.removeAllElements();
        int i = 0;
        while (i < mbrs.size()) {
            this.addNode(mbrs.elementAt(i));
            ++i;
        }
        this.coordinator = mbrs.size() <= 1 || mbrs.size() > 1 && mbrs.elementAt(0).equals(this.my_addr);
        this.repaint();
    }

    public void coordinatorChosen() {
        this.coordinator = true;
        this.repaint();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.channel.close();
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void start() throws Exception {
        String props = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true)";
        this.channel = new JChannel(props);
        this.channel.connect("FD-Heartbeat");
        new PullPushAdapter((Transport)this.channel, this);
        this.my_addr = this.channel.getLocalAddress();
        if (this.my_addr != null) {
            this.setTitle(this.my_addr.toString());
        }
        this.pack();
        this.show();
    }

    public static void main(String[] args) {
        try {
            Topology top = new Topology();
            top.setLayout(null);
            top.setSize(240, 507);
            top.start();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    private final /* synthetic */ void this() {
        this.members = new Vector();
        this.node_color = new Color(250, 220, 100);
        this.coordinator = false;
        this.NormalStyle = 0;
        this.CheckStyle = 1;
        this.my_addr = null;
        this.channel_name = "FD-Heartbeat";
    }

    public Topology() {
        this.this();
        this.addWindowListener(this);
        this.fm = this.getFontMetrics(new Font("Helvetica", 0, 12));
        this.font = new Font("Helvetica", 0, 12);
    }
}

