/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.RpcDispatcher;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QuoteServer
implements MembershipListener,
MessageListener {
    Hashtable stocks;
    Channel channel;
    RpcDispatcher disp;
    final String channel_name = "Quotes";
    int num_members;
    String props;

    private final void integrate(Hashtable state) {
        if (state == null) {
            return;
        }
        Enumeration e = state.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.stocks.put(key, state.get(key));
        }
    }

    public void viewAccepted(View new_view) {
        System.out.println("Accepted view (" + new_view.size() + new_view.getMembers() + ')');
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void start() {
        try {
            this.channel = new JChannel(this.props);
            this.channel.setOpt(4, new Boolean(true));
            this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
            this.channel.connect("Quotes");
            System.out.println("\nQuote Server started at " + new Date());
            System.out.println("Joined channel 'Quotes' (" + this.channel.getView().size() + " members)");
            this.channel.getState(null, 0L);
            System.out.println("Ready to serve requests");
        }
        catch (Exception e) {
            System.err.println("QuoteServer.start() : " + e);
            System.exit(-1);
        }
    }

    public float getQuote(String stock_name) throws Exception {
        System.out.print("Getting quote for " + stock_name + ": ");
        Float retval = (Float)this.stocks.get(stock_name);
        if (retval == null) {
            System.out.println("not found");
            throw new Exception("Stock " + stock_name + " not found");
        }
        System.out.println(retval.floatValue());
        return retval.floatValue();
    }

    public void setQuote(String stock_name, Float value) {
        System.out.println("Setting quote for " + stock_name + ": " + value);
        this.stocks.put(stock_name, value);
    }

    public Hashtable getAllStocks() {
        System.out.print("getAllStocks: ");
        this.printAllStocks();
        return this.stocks;
    }

    public void printAllStocks() {
        System.out.println(this.stocks);
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        try {
            return Util.objectToByteBuffer(this.stocks.clone());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setState(byte[] state) {
        try {
            this.integrate((Hashtable)Util.objectFromByteBuffer(state));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            QuoteServer server = new QuoteServer();
            server.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.stocks = new Hashtable();
        this.channel_name = "Quotes";
        this.num_members = 1;
        this.props = "UDP:PING(num_initial_members=2;timeout=3000):FD:pbcast.PBCAST(gossip_interval=5000;gc_lag=50):UNICAST:FRAG:pbcast.GMS:pbcast.STATE_TRANSFER";
    }

    public QuoteServer() {
        this.this();
    }
}

