/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <cstdarg>

using namespace std;

#include "task.h"
#include "projectExceptions.h"

TASK::TASK(char *id, char *name, int duration):
  NAMED_ID(id, name)
{
    mDesc = NULL;
    mOverrun = NULL;
    mDuration = duration;
    mFullduration = duration;
    remaining = -1;
    rremaining = -1;
    mAssigned = NULL;
    mStart = INVALIDDAYNO;
    mFinish = INVALIDDAYNO;
    mLstart = INVALIDDAYNO;
    mLfinish = INVALIDDAYNO;
    mSlack = 0;
    mAstart = INVALIDDAYNO;
    mAfinish = INVALIDDAYNO;
    mBstart = INVALIDDAYNO;
    mBfinish = INVALIDDAYNO;
    mChildren = 0;
    mBlock = false;
    scheduled = 0;
    rscheduled = 0;
    x1 = x2 = y1 = y2 = 0;
    nx = ny = -1;
    mnDays = 0;
    mParents = 0;
    mPercentComplete = 0.0;
}


void TASK::Error(char *fmt, ...) 
{
    char buf[1024];
    va_list args;

    va_start(args, fmt);
    vsprintf(buf, fmt, args);
    va_end(args);

    string sid = id();
    throw TASKException( sid, buf );
}


void TASK::setDaysDone(int days)
{
    mnDays = days;
}


void TASK::Blockify()
{
    mBlock = true;
}


void TASK::setDesc( char * desc )
{
    mDesc = strdup(desc);
}

void TASK::setPercentComplete( double c )
{
    if( c < 0.0 || c > 100.0 )
	Error("Invalid completion (should be 0<=%s<=100)", c);
    mPercentComplete = c;
}


void TASK::AddNote(const string & note)
{
    mNotes.push_back(note);
}


void TASK::addDepends( TASK * depends ) 
{ 
    mDepends.push_back( depends ); 
    ++depends->mChildren;
};


void  TASK::addFollows( TASK * follows )
{ 
    mFollows.push_back( follows );
    ++follows->mParents;
}


void TASK::addTimeBlock(RESOURCE *r, int start, int finish, TimeBlock::Type type)
{
    mWhen.push_back(TaskTimeBlock(r, start, finish, type));
}


void TASK::addReverseTimeBlock(RESOURCE *r, int start, int finish, TimeBlock::Type type)
{
    mRwhen.push_back(TaskTimeBlock(r, start, finish, type));
}


void TASK::copyWhenToReverseWhen()
{
    mRwhen = mWhen;
}


bool TASK::DayBooked( int dayNo )
{
    for ( TaskTimeBlockIterator tb = mWhen.begin(); tb != mWhen.end() ; tb++ )
	if ( tb->start() <= dayNo && tb->finish() >= dayNo )
	    return true;
    return false;
}


bool TASK::overlap(int start, int finish)
{
    for ( TaskTimeBlockIterator tb = mWhen.begin(); tb != mWhen.end(); tb++ )
	if ( tb->overlap(start, finish) )
	    return true;
    return false;
}


bool TASK::isActiveDuring(int start, int finish)
{
    if ( start <= mStart && mStart <= finish )
	return true;
    if ( start <= mFinish && mFinish <= finish )
	return true;
    if ( mStart <= start && start <= mFinish )
	return true;
    if ( mStart <= finish && finish <= mFinish )
	return true;
    return false;
}


void TASK::addCandidate(RESOURCE *res)
{
    mCando.push_back(res);
}

double TASK::timeCost()
{
    return mAssigned->rate() * mDuration;
}


double TASK::itemCost()
{
    double value = 0.0;
    for ( ITEM::PTRLIST::const_iterator ip = mItems.begin() ; ip != mItems.end() ; ip++)
	value += (*ip)->cost();

    return value;
}


bool CompareTaskResources::operator()(const TASK * t1, const TASK * t2) const
{
    int deltar = strcmp(t1->assigned()->id(), t2->assigned()->id());
    if ( deltar != 0 )
	return deltar < 0;

    return t1->start() < t2->start();
}



