# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/min_dialogs.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: min_dialogs.py,v 1.12 2003/04/10 05:36:14 snowdog_ Exp $
#
# Description: This file contains some of the basic definitions for the chat
# utilities in the orpg project.

##-----------------------------
## Miniature List Panel
##-----------------------------

from miniatures import *

class min_list_panel(wxDialog):

    def __init__(self, parent,layers, log, pos =(-1,-1)):
        wxDialog.__init__(self,  parent,-1, log,pos = (-1,-1), size = (785,175), style= wxRESIZE_BORDER)
        listID = wxNewId()
        self.parent = parent
        self.min = layers['miniatures'].miniatures
        self.grid = layers['grid']
        self.layers = layers
        self.listID = listID
        list_sizer = wxBoxSizer(wxVERTICAL)
        self.list_sizer = list_sizer
        listctrl = wxListCtrl(self, listID, style = wxLC_REPORT|wxSUNKEN_BORDER)
        self.listctrl = listctrl
        self.Centre(wxBOTH)
        self.log = log
        self.list_sizer.Add(self.listctrl,1,wxEXPAND)
#        self.listctrl.InsertColumn(0,"HEIGHT")
#        self.listctrl.InsertColumn(0,"WIDTH")
        self.listctrl.InsertColumn(0,"POS    ")
        self.listctrl.InsertColumn(0,"LOCKED")
        self.listctrl.InsertColumn(0,"HEADING")
        self.listctrl.InsertColumn(0,"FACING")
        self.listctrl.InsertColumn(0,"LABEL")
        self.listctrl.InsertColumn(0,"PATH")
        self.listctrl.SetColumnWidth(1, wxLIST_AUTOSIZE_USEHEADER)
        self.listctrl.SetColumnWidth(2, wxLIST_AUTOSIZE_USEHEADER)
        self.listctrl.SetColumnWidth(3, wxLIST_AUTOSIZE_USEHEADER)
        self.listctrl.SetColumnWidth(4, wxLIST_AUTOSIZE_USEHEADER)
        self.listctrl.SetColumnWidth(5, wxLIST_AUTOSIZE_USEHEADER)
        self.list_sizer.Add(wxButton(self, wxID_OK, "DONE"),0,wxALIGN_CENTER)
        self.refresh()
        EVT_SIZE(self,self.on_size)
        EVT_BUTTON(self, wxID_OK, self.on_ok)
        EVT_COMMAND_RIGHT_CLICK(self.listctrl,listID,self.OnRightClick)
        EVT_RIGHT_UP(self.listctrl, self.OnRightClick)
        EVT_RIGHT_DOWN(self.listctrl, self.OnRightDown)
        self.SetSizer(self.list_sizer)

    def OnRightClick(self,event):
        if self.listctrl.GetSelectedItemCount() > 0:
            menu = wxMenu()
            lPopupID1 = 0
            lPopupID2 = 1
            lPopupID3 = 2
            menu.Append(lPopupID1, "&Edit")
            menu.Append(lPopupID2, "&Delete")
            menu.Append(lPopupID3, "To &Gametree")
            EVT_MENU(self, lPopupID1, self.onEdit)
            EVT_MENU(self, lPopupID2, self.onDelete)
            EVT_MENU(self, lPopupID3,self.onToGametree)
            self.PopupMenu(menu, cmpPoint(self.x, self.y))
            menu.Destroy()
        event.Skip()

    def refresh(self):
        for m in self.min:
            self.listctrl.InsertStringItem(self.min.index(m),self.min[self.min.index(m)].path)
            self.listctrl.SetStringItem(self.min.index(m),1,self.min[self.min.index(m)].label)
            self.listctrl.SetStringItem(self.min.index(m),2,`self.min[self.min.index(m)].heading`)
            self.listctrl.SetStringItem(self.min.index(m),3,`self.min[self.min.index(m)].face`)
            self.listctrl.SetStringItem(self.min.index(m),4,`self.min[self.min.index(m)].locked`)
#            self.listctrl.SetStringItem(min.index(m),4,`min[min.index(m)].snap_to_align`)
            self.listctrl.SetStringItem(self.min.index(m),5,`self.min[self.min.index(m)].pos`)
#            self.listctrl.SetStringItem(self.min.index(m),6,`self.min[self.min.index(m)].width`)
#            self.listctrl.SetStringItem(self.min.index(m),7,`self.min[self.min.index(m)].height`)
            oldcolumnwidth = self.listctrl.GetColumnWidth(0)
            self.listctrl.SetColumnWidth(0, wxLIST_AUTOSIZE)
            if oldcolumnwidth < self.listctrl.GetColumnWidth(0):
                self.listctrl.SetColumnWidth(0, wxLIST_AUTOSIZE)
            else:
                self.listctrl.SetColumnWidth(0, oldcolumnwidth)
        self.list_sizer=self.list_sizer
        self.on_size("send something")

    def onEdit(self,event):
        min_list = []
        min_index = []
        loop_count = 0
        item =-1
        while true:
            loop_count += 1
            item = self.listctrl.GetNextItem(item,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED)
            if item == -1:
                break
            min_list.append(self.min[item])
            min_index.append(item-loop_count+1)
        if len(min_list) > 0:
            dlg = min_list_edit_dialog(self.parent,min_index, min_list,self.layers)
        if dlg.ShowModal() == wxID_OK:
            pass
        self.listctrl.DeleteAllItems()

        self.refresh()
        event.Skip()

    def onDelete(self,event):
        loop_count = 0
        item = -1
        while true:
            loop_count += 1
            item = self.listctrl.GetNextItem(item,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED)
            if item == -1:
                break
            #self.min.remove(self.min[item-loop_count+1])
            self.layers["miniatures"].del_miniature(self.min[item-loop_count+1])
        self.listctrl.DeleteAllItems()
        self.refresh()
        event.Skip()

    def onToGametree(self,event):
        min_list = []
        min_index = []
        loop_count = 0
        item =-1
        while true:
            loop_count += 1
            item = self.listctrl.GetNextItem(item,wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED)
            if item == -1:
                break
            min_list.append(self.min[item])
            min_index.append(item-loop_count+1)
        if len(min_list) > 0:
            for sel_rmin in min_list:
#############
                min_xml = sel_rmin.toxml(action="new",preserve_changed=1)
                node_begin = "<nodehandler module='map_miniature_nodehandler' class='map_miniature_handler' name='"

                if sel_rmin.label:
                    node_begin += sel_rmin.label + "'"
                else:
                    node_begin += "Unnamed Miniature'"

                node_begin += ">"
                gametree = self.parent.myopenrpg.get_component('tree')
                node_xml = node_begin + min_xml + '</nodehandler>'
                print "Sending this XML to insert_xml:" + node_xml
                gametree.insert_xml(node_xml)
##########
        self.listctrl.DeleteAllItems()

        self.refresh()
        event.Skip()


    def OnRightDown(self,event):
        self.x = event.GetX()
        self.y = event.GetY()
        event.Skip()

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        fillerspace = (s[0]-15-self.listctrl.GetColumnWidth(0)-self.listctrl.GetColumnWidth(1)-self.listctrl.GetColumnWidth(2)-self.listctrl.GetColumnWidth(3)-self.listctrl.GetColumnWidth(4))/5
        self.listctrl.SetColumnWidth(0,self.listctrl.GetColumnWidth(0)+fillerspace)
        self.listctrl.SetColumnWidth(1,self.listctrl.GetColumnWidth(1)+fillerspace)
        self.listctrl.SetColumnWidth(2,self.listctrl.GetColumnWidth(2)+fillerspace)
        self.listctrl.SetColumnWidth(3,self.listctrl.GetColumnWidth(3)+fillerspace)
        self.listctrl.SetColumnWidth(4,self.listctrl.GetColumnWidth(4)+fillerspace)
        self.list_sizer.SetDimension(5,0,s[0]-10,s[1]-10)

    def on_ok(self,evt):
        self.EndModal(wxID_OK)


class min_list_edit_dialog(wxDialog):
    def __init__(self,parent,min_index, min_list, layers):
        wxDialog.__init__(self,parent,-1,"Miniature List",wxDefaultPosition,wxSize(600,530))
        self.layers = layers
        grid = layers['grid']
        min = layers['miniatures']
        self.min_list = min_list
        self.min_index = min_index
        self.min = min
        sizer =  wxBoxSizer(wxHORIZONTAL)
        self.grid = grid
        editor = min_list_edit_panel(self, min_index, min_list,layers)
        sizer.Add(wxButton(self, wxID_OK, "OK"), 1, wxEXPAND)
        sizer.Add(10,10)
#        sizer.Add(wxButton(self, wxID_REVERT,"Reset"), 1, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(wxButton(self, wxID_CANCEL, "Cancel"), 1, wxEXPAND)
        (w,h) = self.GetClientSizeTuple()
        editor.SetDimensions(0,0,w,h-25)
        sizer.SetDimension(0,h-25,w,25)
        self.editor = editor
        EVT_BUTTON(self, wxID_OK, self.on_ok)
        #self.SetSizer(sizer)
#        EVT_BUTTON(self, wxID_REVERT, self.on_revert)

    def on_revert(self,evt):
        pass

    def on_ok(self,evt):
        self.editor.on_ok(self.layers)
        self.EndModal(wxID_OK)


class min_list_edit_panel(wxPanel):
    def __init__(self, parent, min_index, min_list,layers):
        LABEL_COMBO = wxNewId()
        PATH_COMBO = wxNewId()
        POS_COMB = wxNewId()
        MIN_POS = wxNewId()
        POS_SPIN =wxNewId()
        self.grid = layers['grid']
        self.min = layers['miniatures'].miniatures
        self.min_list = min_list
        self.min_index = min_index
        self.layers = layers
        wxPanel.__init__(self, parent, -1)
        self.min=min
        listsizer = wxBoxSizer(wxVERTICAL)
        labelsizer = wxBoxSizer(wxHORIZONTAL)
        self.labelcheck = wxCheckBox(self,-1,"Serialize")
        labelsizer.Add(wxStaticText(self, -1, "Label:          "), 0, wxEXPAND)
        labelsizer.Add(self.labelcheck,wxALIGN_RIGHT,wxEXPAND)
        listsizer.Add(labelsizer,0, wxEXPAND)
        self.labelcombo = wxComboBox(self, LABEL_COMBO,"no change",style=wxCB_DROPDOWN)
        listsizer.Add(self.labelcombo,0, wxEXPAND)
        self.pathcombo = wxComboBox(self, PATH_COMBO, "no change",style=wxCB_DROPDOWN)
        self.positioncombo = wxComboBox(self, POS_COMB, "no change", choices=["no change"], style=wxCB_READONLY)
        #self.positioncombo.SetValue(`min_list[0].pos`)
        self.labelcombo.Append("no change")
        self.pathcombo.Append("no change")
        for m in min_list:
            self.labelcombo.Append(min_list[min_list.index(m)].label)
            self.pathcombo.Append(min_list[min_list.index(m)].path)
            self.positioncombo.Append(`min_list[min_list.index(m)].pos`)
        listsizer.Add(wxStaticText(self, -1, "Path:"), 0, wxEXPAND)
        listsizer.Add(self.pathcombo, 0, wxEXPAND)
        listsizer.Add(10,10)
        self.heading = wxRadioBox(self, MIN_HEADING, "Heading", choices=["None","N","NE","E","SE","S","SW","W","NW","no change"], majorDimension=5, style=wxRA_SPECIFY_COLS)
        self.heading.SetSelection( 9 )
        listsizer.Add( self.heading, 0, wxEXPAND )
        listsizer.Add(10,10)
        self.face = wxRadioBox(self, MIN_FACE, "Facing", choices=["None","N","NE","E","SE","S","SW","W","NW","no change"], majorDimension=5, style=wxRA_SPECIFY_COLS)
        self.face.SetSelection(9)
        listsizer.Add(self.face, 0, wxEXPAND)
###
###    Group together locked, Hide, and snap radioboxes in group2 box
###
        group2 = wxBoxSizer(wxHORIZONTAL)
        self.locked = wxRadioBox(self, MIN_LOCK, "Lock", choices=["Don't lock","Lock","no change"],majorDimension=1,style=wxRA_SPECIFY_COLS)
        self.locked.SetSelection(2)
        self.hide = wxRadioBox(self, MIN_HIDE, "Hide", choices=["Don't hide", "Hide", "no change"],majorDimension=1,style=wxRA_SPECIFY_COLS)
        self.hide.SetSelection(2)
        self.snap = wxRadioBox(self,MIN_ALIGN,"Snap",choices=["Center","Top left","no change"],majorDimension=1,style=wxRA_SPECIFY_COLS)
        self.snap.SetSelection(2)
        group2.Add(self.locked, 0, wxEXPAND)
        group2.Add(10,0)
        group2.Add(self.hide, 0, wxEXPAND)
        group2.Add(10,0)
        group2.Add(self.snap, 0, wxEXPAND)
        group2.Add(10,0)
        listsizer.Add(group2,0,0)
###
###     group together the postion radiobox and the and its selection elements
###
        xpos = int(min_list[0].pos[0])
        #xpos = int(`min_list[0].pos`[1:`min_list[0].pos`.index(',')])
        ypos = int(min_list[0].pos[1])
        #ypos = int(`min_list[0].pos`[`min_list[0].pos`.rfind(',')+1:len(`min_list[0].pos`)-1])
        self.scx = wxSpinCtrl(self, POS_SPIN, "", (-1,-1), wxSize(75,25))
        self.scx.SetRange(0,self.grid.return_grid()[0])
        self.scx.SetValue(xpos)
        self.scy = wxSpinCtrl(self, POS_SPIN, "", (-1,-1), wxSize(75,25))
        self.scy.SetRange(0,self.grid.return_grid()[1])
        self.scy.SetValue(1)
        self.scy.SetValue(ypos)
        positionbox = wxBoxSizer(wxHORIZONTAL)
        self.poschoice = wxRadioBox(self,MIN_POS,"Position",choices=["Manual", "Existing", "no change"],majorDimension=1,style=wxRA_SPECIFY_COLS)
        self.poschoice.SetSelection(2)
        positionbox.Add(self.poschoice,0,0)
        ###
        ### group together choices under position choice boxsizer
        ###
        poschoicebox = wxBoxSizer(wxVERTICAL)
            ###
            ### spinbox contains the x and y spinctrls
            ###
        spinbox = wxBoxSizer(wxHORIZONTAL)
        group2.Add(positionbox,0, wxEXPAND)
        xpos = wxStaticText(self, -1,"XPOS:  ")
        spinbox.Add(xpos,0, 0)
        spinbox.Add(self.scx, 0, 0)
        ypos = wxStaticText(self, -1,"YPOS:  ")
        spinbox.Add(ypos,0, 0)
        spinbox.Add(self.scy, 0, 0)
        poschoicebox.Add(0,15)
        poschoicebox.Add(spinbox,0,0)
            ###
            ### kludge is just a way to horizontaly position text.  .Add doesn't seem to work.
            ###
        kluge = wxBoxSizer(wxHORIZONTAL)
        klugetext = wxStaticText(self, -1, "            ")
        kluge.Add(klugetext,0,0)
        kluge.Add(self.positioncombo,0,0)
        poschoicebox.Add(0,1)
        poschoicebox.Add(kluge,0,0)
        positionbox.Add(poschoicebox,0,0)
        listsizer.Add(positionbox,0, 0)
        self.listsizer = listsizer
        self.outline = wxStaticBox(self,-1,"Miniature list properties")
        listsizer.Add(self.outline,0, wxEXPAND)
        self.SetSizer(listsizer)

        EVT_SPINCTRL(self, POS_SPIN, self.on_spin)
        EVT_TEXT(self, POS_COMB, self.on_combo_box)
        EVT_SIZE(self, self.on_size)
        EVT_TEXT(self, MIN_LABEL, self.on_text)
        EVT_RADIOBOX(self, MIN_HEADING, self.on_radio_box)
        EVT_RADIOBOX(self, MIN_FACE, self.on_radio_box)


    def on_ok(self,min):
        self.min = min
        for m in self.min_list:
            if self.hide.GetSelection() !=2:
                m.hide = self.hide.GetSelection()
            if self.heading.GetSelection() !=9:
                m.heading = self.heading.GetSelection()
            if self.face.GetSelection() !=9:
                m.face = self.face.GetSelection()
            if self.locked.GetSelection() !=2:
                m.locked = self.locked.GetSelection()
            if self.snap.GetSelection() !=2:
                m.snap_to_align = self.snap.GetSelection()
            if self.labelcombo.GetValue() != "no change":
                m.label = self.labelcombo.GetValue()
                if self.labelcheck.GetValue():
                    m.label += " " + `self.layers['miniatures'].next_serial()`
                    # self.layers['miniatures'].serial_number +=1
                    # m.label += " " + `self.layers['miniatures'].serial_number`
            if self.pathcombo.GetValue() != "no change":
                path = self.pathcombo.GetValue()
                image = self.evaluate(path)
                if image[1] != -1:
                    m.path = image[0]
                    m.bmp = image[1]
                else:
                    image[-1] = -1
                    while image[1] == -1:
                        image = 0
                        self.dlg = wxTextEntryDialog(self, 'You entered an invalid URL for the image path.  Please Enter a valid URL or cancel to leave the old url unchanged')
                        if self.dlg.ShowModal() == wxID_OK:
                            path = self.dlg.GetValue()
                            image = self.evaluate(path)
                            if image[1] != -1:
                                m.path = image[0]
                                m.bmp = image[1]
                            self.dlg.Destroy()
                        else:
                            break
            if self.poschoice.GetSelection() !=2:
                if self.poschoice.GetSelection() == 0:
                    m.pos = cmpPoint(self.scx.GetValue(),self.scy.GetValue())
                else:
                    pos = self.positioncombo.GetValue()
                    m.pos = cmpPoint(int(`pos`[2:`pos`.index(",")]),int(`pos`[`pos`.rfind(',')+1:len(`pos`)-2]))
        self.layers["miniatures"].canvas.send_map_data()



    def evaluate(self,ckpath):
        path = []
        if ckpath[:7] != "http://":
            ckpath ="http://" + ckpath
        path = self.check_path(ckpath)
        return [ckpath,path]



    def check_path(self,path):
        if imageCache.has_key(path):
            return imageCache[path]
        pos = string.rfind(path,".")
        ext = string.lower(path[pos+1:])
        img_type = 0
        if ext == "gif":
            img_type = wxBITMAP_TYPE_GIF
        elif (ext == "jpg") | (ext == "jpeg"):
            img_type = wxBITMAP_TYPE_JPEG
        elif ext == "bmp":
            img_type = wxBITMAP_TYPE_BMP
        elif ext == "png":
            img_type = wxBITMAP_TYPE_PNG
        else:
            return -1
        try:
            data = urllib.urlretrieve(path)
        except:
            return -1
        try:
            img = wxBitmap(data[0], img_type)
            if img.Ok() == FALSE:
                return -1
            imageCache[path] = img
            return img
        except:
            return -1



    def on_text(self,evt):
        id=evt.GetId()



    def on_spin(self,evt):
        self.poschoice.SetSelection(0)



    def on_combo_box(self,evt):
        self.poschoice.SetSelection(1)

    def on_radio_box(self,evt):
        id=evt.GetId()
        index = evt.GetInt()

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        self.listsizer.SetDimension(20,20,s[0]-40,s[1]-40)
        self.outline.SetDimensions(5,5,s[0]-10,s[1]-10)

##-----------------------------
## Miniature Prop Panel
##-----------------------------

MIN_LABEL = wxNewId()
MIN_HEADING = wxNewId()
MIN_FACE = wxNewId()
MIN_HIDE = wxNewId()
MIN_LOCK = wxNewId()
MIN_ALIGN = wxNewId()
wxID_MIN_WIDTH = wxNewId()
wxID_MIN_HEIGHT = wxNewId()
wxID_MIN_SCALING = wxNewId()

class min_edit_panel(wxPanel):
    def __init__(self, parent, min):
        wxPanel.__init__(self, parent, -1)
        self.min = min
        sizer = wxBoxSizer(wxVERTICAL)
        sizerSize = wxBoxSizer(wxHORIZONTAL)
        hSizer = wxBoxSizer(wxHORIZONTAL)
        self.label = orpgTextCtrl(self, MIN_LABEL, min.label)
        sizer.Add(wxStaticText(self, -1, "Label:"), 0, wxEXPAND)
        sizer.Add(self.label, 0, wxEXPAND)
        sizer.Add(10,10)

        self.heading = wxRadioBox(self, MIN_HEADING, "Heading", choices=["None","N","NE","E","SE","S","SW","W","NW"],majorDimension=5,style=wxRA_SPECIFY_COLS)
        self.heading.SetSelection(min.heading)
        self.face = wxRadioBox(self, MIN_FACE, "Facing", choices=["None","N","NE","E","SE","S","SW","W","NW"],majorDimension=5,style=wxRA_SPECIFY_COLS)
        self.face.SetSelection(min.face)
        self.locked = wxCheckBox(self, MIN_LOCK, " Lock")
        self.locked.SetValue(min.locked)
        self.hide = wxCheckBox(self, MIN_HIDE, " Hide")
        self.hide.SetValue(min.hide)
        sizer.Add(self.heading, 0, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(self.face, 0, wxEXPAND)
        sizer.Add(10,10)

        #
        #image resizing
        #
        self.min_width_old_value = str(self.min.bmp.GetWidth())
        self.min_width = orpgTextCtrl(self, wxID_MIN_WIDTH, self.min_width_old_value)
        sizerSize.Add(wxStaticText(self, -1, "Width: "), 0, wxALIGN_CENTER)
        sizerSize.Add(self.min_width, 1, wxEXPAND)
        sizerSize.Add(20, 25)
        #TODO:keep in mind that self.min is a local copy???
        self.min_height_old_value = str(self.min.bmp.GetHeight())
        self.min_height = orpgTextCtrl(self, wxID_MIN_HEIGHT, self.min_height_old_value)
        sizerSize.Add(wxStaticText(self, -1, "Height: "),0,wxALIGN_CENTER)
        sizerSize.Add(self.min_height, 1, wxEXPAND)
        self.min_scaling = wxCheckBox(self, wxID_MIN_SCALING, "Lock scaling")
        self.min_scaling.SetValue(TRUE)
        sizerSize.Add(self.min_scaling, 1, wxEXPAND)

        sizer.Add(sizerSize, 0, wxEXPAND)
        sizer.Add(10, 10)

        # Now, add the last items on in their own sizer
        hSizer.Add(self.locked, 0, wxEXPAND)
        hSizer.Add(10,10)
        hSizer.Add(self.hide, 0, wxEXPAND)

        # Add the hSizer to the main sizer
        sizer.Add( hSizer )
               
        self.sizer = sizer
        self.SetSizer(self.sizer)
        self.outline = wxStaticBox(self,-1,"Miniature") 
        EVT_SIZE(self, self.on_size)
        EVT_TEXT(self, MIN_LABEL, self.on_text)
        EVT_TEXT(self, wxID_MIN_WIDTH, self.on_scaling)
        EVT_TEXT(self, wxID_MIN_HEIGHT, self.on_scaling)
        EVT_RADIOBOX(self, MIN_HEADING, self.on_radio_box)
        EVT_RADIOBOX(self, MIN_FACE, self.on_radio_box)


    def on_scaling(self, evt):
        if self.min_scaling.GetValue() == FALSE:
            return
        elif self.min_width.GetValue() and wxID_MIN_WIDTH == evt.GetId() and self.min_width.GetInsertionPoint():
            self.min_height.SetValue ( str(int((float(self.min_width.GetValue()) / float(self.min_width_old_value)) * float(self.min_height_old_value))) )
        elif self.min_height.GetValue() and wxID_MIN_HEIGHT == evt.GetId() and self.min_height.GetInsertionPoint():
            self.min_width.SetValue ( str(int((float(self.min_height.GetValue()) / float(self.min_height_old_value)) * float(self.min_width_old_value))) )

    def update_min(self):
        self.min.set_min_props(self.heading.GetSelection(),
                               self.face.GetSelection(),
                               self.label.GetValue(),
                               self.locked.GetValue(),
                               self.hide.GetValue(),
                               self.min_width.GetValue(),
                               self.min_height.GetValue())


    def on_radio_box(self,evt):
        id = evt.GetId()
        index = evt.GetInt()

    def on_text(self,evt):
        id = evt.GetId()

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        self.sizer.SetDimension(20,20,s[0]-40,s[1]-40)
        self.outline.SetDimensions(5,5,s[0]-10,s[1]-10)

class min_edit_dialog(wxDialog):
    def __init__(self,parent,min):
#520,265
        wxDialog.__init__(self,parent,-1,"Miniature",wxDefaultPosition,wxSize(520,350))
        (w,h) = self.GetClientSizeTuple()
        
        mastersizer = wxBoxSizer(wxVERTICAL)
        
        editor = min_edit_panel(self,min)
        editor.SetDimensions(0,0,w,h-25)
        self.editor = editor
        mastersizer.Add(editor)
        
        sizer =  wxBoxSizer(wxHORIZONTAL)
        sizer.Add(wxButton(self, wxID_OK, "OK"), 1, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(wxButton(self, wxID_CANCEL, "Cancel"), 1, wxEXPAND)
        sizer.SetDimension(0,h-25,w,25)
        mastersizer.Add(sizer, 0, wxEXPAND)

        self.SetSizer(mastersizer)
        EVT_BUTTON(self, wxID_OK, self.on_ok)

    def on_ok(self,evt):
        self.editor.update_min()
        self.EndModal(wxID_OK)
