/*
 * session-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/srmv2/session-srmv2.h,v 1.21 2002/02/03 03:05:47 lim Exp $
 */

#ifndef srmv2_session_h
#define srmv2_session_h

#include "srmv2/srmv2.h"
#include "srmv2/srmv2-api.h"
#include "srmv2/pktbuf-srmv2.h"
#include "srmv2/manager-srmv2.h"

#include "common/ntp-time.h"
#include "common/all-types.h"
#include "iohandler/timer.h"
#include "common/random.h"
#include "common/hash.h"

#include "hfsc/hfsc_fun.h"

#include "net/inet.h"
#include "net/net.h"
#include "net/net-ip.h"
#include "net/transmitter.h"


class SRMv2_BufferPool;
class SRMv2_Manager;
class SRMv2_Source;
class SRMv2_Request;

class SRMv2_Session : public SRMv2_Transmitter, public SRMv2_SessionHandler {
public:
	SRMv2_Session(unsigned int addr, unsigned int sport,unsigned int rport,
		      unsigned int ttl, int bps, int *status=0);

	void init_hfsc(unsigned int total_bps);
	
	~SRMv2_Session();

	void announce(SRMv2_CtrlHandler *);

	unsigned int send_adu(SRMv2_Source *source, unsigned char *data, 
			      unsigned int ss, unsigned int sbytes, 
			      unsigned int ebytes, unsigned int adulbytes, 
			      unsigned int cid, unsigned char type, 
			      unsigned int addr, unsigned char frag,
			      const srm_adu_info *info);
	
	void send_rreq(SRMv2_Request *request, unsigned char type);

	void send_announcement(SRMv2_Source *src, int include_srcinfo,
			       naddr* comps, int count);

	void recv(SRMv2_DataHandler*);
	void recv(SRMv2_CtrlHandler*);
	void send_delayinfo();
	

	SRMv2_Source *source(int *srcID, unsigned int address, int *created);
	SRMv2_Source *source(SRMv2_Source *src);
	SRMv2_Source *create_localsrc(const char *srcid=NULL);
	int reset(unsigned int addr, unsigned int sport,  unsigned int sport,
		  unsigned int ttl);
	double backoff(SRMv2_Source* src, unsigned int level);
	//int recover(char *aname, unsigned int start, unsigned int end);

	FILE* logfile() { return logfile_; }
	SRMv2_Network* unet() { return uh_.net(); }
	SRMv2_Network* mnet() { return dh_.net(); }

	inline srm_callbacks *callbacks() { return &callbacks_; };
	int srm_should_recover(SRMv2_Source *source, unsigned int cid,
			       unsigned int sseq, unsigned int eseq);
	inline int delay_until_full_packet(int flag) {
		int f=delay_until_full_pkt_;
		if (!flag && delayed_pkt_.pb_) {
			// send out the delayed packet
			send_delayed_pkt();
		}
		delay_until_full_pkt_ = flag;
		return f;
	}
	inline int delay_until_full_packet() { return delay_until_full_pkt_; }

#ifndef NDEBUG
	inline double drop_probability() { return dropProb_; }
	inline double drop_probability(double p) {
		double save = dropProb_;
		dropProb_ = p;
		return save;
	}
#endif
	
	inline u_short ttl() { return pool_->sttl(); }
	void dump_cmnhdr(SRMv2_pktbuf *pb);
	
protected:
	void send_delayed_pkt();		
	void send(SRMv2_pktbuf* pb);
	//void simloss(SRMv2_pktbuf* pb);
	void transmit(SRMv2_pktbuf* pb);

	void parse_header(SRMv2_pktbuf *pb);
	void handle_data(SRMv2_pktbuf *pb, SRMv2_pktbuf *cp, u_int32_t addr);
	void handle_ctrl(SRMv2_pktbuf *pb, u_char type, u_int32_t sndr);
	void handle_rreq(SRMv2_pktbuf *pb, SRMv2_Source *src,
			 u_int32_t cid, u_int32_t addr);
	void handle_dvec(SRMv2_pktbuf *pb, u_int32_t addr);
	void handle_announce(SRMv2_pktbuf *pb, SRMv2_Source *src);

	float delay(unsigned int addr);
	void fill_delays(SRMv2_pktbuf* pb);
	void update_delay(unsigned int addr, unsigned int tsend,unsigned int n,
			  srmv2_delayhdr* dvec);
	
	int badproto_;
#ifndef NDEBUG
	double dropProb_;
#endif
	float c1_;
	float c2_;
	FILE* logfile_;

	SRMv2_DataHandler dh_;
	SRMv2_DataHandler uh_; /* Unicast handler. To handle 2-step local
				  recovery replies. */
	u_short uport_;
	SRMv2_Source *representative_lsrc_;
	SRMv2_Manager *manager_;
	SRMv2_BufferPool *pool_;

	srm_callbacks callbacks_; /* Registry of app handlers. */
	
        HashTable  *srcs_;
        HashTable  *delayinfo_; /* Delay information, indexed by IPv4
				   addresses */

	u_int32_t lport_;
	u_int32_t laddr_;

	int delay_until_full_pkt_;
	struct DelayedPacket {
		DelayedPacket() : pb_(NULL), type_(0), addr_(0), src_(0),
			cid_(0), last_aduhdr_(0) {}
		~DelayedPacket() { if (pb_) pb_->release(); }
		SRMv2_pktbuf *pb_;
		u_char type_;
		u_int32_t addr_;
		SRMv2_Source *src_;
		u_int32_t cid_;
		srmv2_aduhdr *last_aduhdr_;
	} delayed_pkt_;

};
#endif

