/*
 * transmitter.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/net/transmitter.h,v 1.8 2002/02/03 03:03:19 lim Exp $ (LBL)
 */

#ifndef mash_transmitter_h
#define mash_transmitter_h

#ifdef WIN32
#include <winsock.h>
#else
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#endif

#if defined(linux) /* For struct timeval. */
#include <sys/time.h>
#endif

#include "config.h"
#include "timer.h"
#include "inet.h"
#include "pktbuf.h"
#include "srmv2-api.h"
#include "hfsc_queue.h"
#include "hfsc_hierarchy.h"

/*FIXME*/
#define MAXHDR 128

/*
 * The base object for performing the outbound path of
 * the application level protocol.
 */
class SRMv2_Transmitter : public SRMv2_PacketModule, public SRMv2_Timer {
    public:
	SRMv2_Transmitter(int bps);
	virtual void timeout();

	static void dump(int fd);
	inline void bps(int b) { bps_ = b; }
	inline int bps() { return(bps_); }
	inline int mtu() const { return (mtu_); }
	void flush();
	virtual void recv(SRMv2_pktbuf* pb);
	ClassItem *hfscRoot();
	
/* Transmitter maintains a HFSC queue. */
	void  init_hfsc(unsigned int total_bps);
	unsigned int allocate_tcid() { return next_tcid_ ++; }
	unsigned int next_tcid_;

protected:
	virtual void loopback(SRMv2_pktbuf*);
        virtual void update_stats(SRMv2_pktbuf*);

	void update(int nbytes);
	void dump(int fd, const SRMv2_pktbuf*) const;
	void output(SRMv2_pktbuf* pb);
	virtual void transmit(SRMv2_pktbuf* pb) = 0;

	double gettimeofday() const;
	double txtime(SRMv2_pktbuf* pb);

	int mtu_;		/* mtu of wire (as seen by application) */

	int nb_;		/* number of bytes sent */
	int nf_;		/* number of frames sent */
	int np_;		/* number of packets sent */
	
	int bps_;		/* bit-rate for interpkt spacing */
	double nextpkttime_;

	/* packet transmission queue */
	int busy_;
	SRMv2_pktbuf* head_;
	SRMv2_pktbuf* tail_;
	virtual void idle();

	int loopback_;		/* true to loopback data packets */
	int loop_layer_;	/* # of layers to loop back (for testing) */
	static int dumpfd_;	/* fd to dump packet stream to */

	HFSCQueue *hfsc_queue_; /* Class hierarchy for scheduler. */
};
#endif
