/*
 * idlecallback.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/iohandler/idlecallback.cc,v 1.5 2002/02/03 03:03:57 lim Exp $
 */

#include "idlecallback.h"

SRMv2_IdleCallback::SRMv2_IdleCallback() : pending_(0)
{
}

SRMv2_IdleCallback::~SRMv2_IdleCallback()
{
	if (pending_ != 0) 
		idle_cancel();
}

void SRMv2_IdleCallback::idle_sched()
{
	if (!pending_) {
		Tcl_DoWhenIdle(dispatch, (ClientData)this);
		pending_ = 1;
	}
}

void SRMv2_IdleCallback::dispatch(ClientData cd)
{
	SRMv2_IdleCallback* t = (IdleCallback*)cd;
	t->pending_ = 0;
	t->idle_callback();
}

void SRMv2_IdleCallback::idle_cancel()
{
	if (pending_) {
		Tcl_CancelIdleCall(dispatch, (ClientData)this);
		pending_ = 0;
	}
}
