# debug.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#
# tunable debugging
#
proc DbgOut { args } {     
	mtrace trcMB $args
}

import Callback
Class MBDebugDlg -superclass Callback

MBDebugDlg instproc init {mgr showUI} {
        $self instvar appmgr_ f_ isActive_ showUI_
        $self tkvar drop_ cont_   
        
        set appmgr_ $mgr
        set cont_ 5
        set drop_ 5
        set f_ ".__debug"
        set showUI_ $showUI
        set isActive_ 0

        $self build
        wm withdraw $f_
}

MBDebugDlg instproc disable_drop {} {
	$self change_state 0
	$self dismiss
	$self callback disable_drop
}

MBDebugDlg instproc dismiss {} {        
        wm iconify [$self set f_]
}

MBDebugDlg instproc build {} {
        $self instvar f_ showUI_ 

        if [winfo exists $f_] {
                if $showUI_ { wm deiconify $f_ }
                return
        }
        set f_ [toplevel $f_]
        frame $f_.f1 -borderwidth 2 -relief groove
        label $f_.f1.drop -text "# pkts to drop: "
        entry $f_.f1.e -textvariable [$self tkvarname drop_]
        if $showUI_ {
                pack $f_.f1.drop $f_.f1.e  -side left -fill x
        }
        frame $f_.f2 -borderwidth 2 -relief groove    
        label $f_.f2.cont -text "# pkts to receive : "
        entry $f_.f2.e -textvariable [$self tkvarname cont_]
        button $f_.d -text "Dismiss" -command "$self dismiss"
        button $f_.st -text "Disable pkt drop" -command "$self disable_drop"
        if $showUI_ {
                pack $f_.f2.cont $f_.f2.e -side left -fill x
                pack $f_.f2 $f_.f1 -fill x -side top
                pack $f_.d -side right -fill x
                pack $f_.st -side left -fill x
        }
}

MBDebugDlg instproc change_state {onoff} {
        $self instvar f_ isActive_ activate_ counters_ showUI_

        set isActive_ $onoff
        if {$isActive_==1} {
                # restart everything
                foreach src [array names activate_] {
                        set activate_($src) [expr $counters_($src) + 1]
                }
                if {$showUI_} { $self build }
        } else {
                if {$showUI_ && [winfo exists $f_]} { wm withdraw $f_ }
        }
}

MBDebugDlg instproc get_state {} {
        $self instvar isActive_
        return $isActive_
}

# called when a packet is received.
MBDebugDlg instproc recv {src} { 
        $self instvar counters_ action_ activate_ f_ drop_ cont_ \
                        isActive_
        $self tkvar drop_ cont_    
        
        if {$isActive_ == 0} {
                return "cont"
        }
        if ![info exists counters_($src)] {
                set counters_($src) 0
                set action_($src) "drop"
                #start asking one the first packet
                set activate_($src) 1
        }
        incr counters_($src) 
        if {$activate_($src)==$counters_($src)} {
                if {$action_($src)=="drop"} {
                        if {$cont_>0} {
                                incr activate_($src) $cont_
                                set action_($src) "cont"
                        } else {
                                incr activate_($src) 
                        }
                } else {
                        if {$drop_>0} {
                                incr activate_($src)  $drop_
                                set action_($src) "drop"
                        } else {
                                incr activate_($src)
                        }
                }
        }      
        if {$action_($src) == "drop"}  {
                DbgOut "Drop pkt#=$counters_($src), n_actv=$activate_($src)"
                return "drop"
        } else {
                DbgOut "Recv pkt#:$counters_($src), actv=$activate_($src)"
                return "cont"
        }                
}

Class DbgInfoWindow

DbgInfoWindow set id_ 0

DbgInfoWindow instproc init {title text} {
        global InfoWindowOK_

	set i [DbgInfoWindow set id_]
	incr i
	DbgInfoWindow set id_ $i
	set w .dbgw$i
	$self set path_ $w
        toplevel $w
        wm title $w $title
        set InfoWindowOK_ ""    
        set f [frame $w.f]
        set txt [text $f.text -yscrollcommand "$f.sy set"]
        scrollbar $f.sy -orient vert -command "$f.text yview"
        pack $txt -side left -fill both -expand true
	pack $f.sy -side left -fill both -expand false
        $txt insert insert $text
        set dismiss [button $w.dismiss -text "dismiss" \
                        -command "delete $self"]
        pack $f $dismiss -side top -anchor c  -fill both  
}

DbgInfoWindow instproc destroy {} {
	destroy [$self set path_]
}

proc DumpCanvas {canv} {
        set elements [$canv find withtag all]
        append result "item#\ttype\tcoords\t        text\n"
        append result "======\t====\t=====\t        ====\n"
        foreach elt $elements {
                append result "$elt\t"
                append result [$canv type $elt]\t
                append result [$canv coords $elt]
                if {[$canv type $elt]=="text"} {
                        append result \t
                        append result [$canv itemcget $elt -text]
                }
                append result \n
        }
	return $result
}
