/*
 * real_audio_enc.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This is the Virtual Device abstraction to grab raw PCM from an audio stream.
 *
 */


//#include <osfcn.h>
#include <fcntl.h>
#include "audio.h"
#include "mulaw.h"
#include "Tcl.h"
#include "real_encoder.h"

#define ULAW_ZERO 0x7f

// and encoder that takes that PCM audio and gives it to a Real Networks
// encoding engine.

class RealAudioEnc : public Audio {
public:
  RealAudioEnc();
  ~RealAudioEnc();
  virtual int FrameReady();
  virtual u_char* Read();
  virtual void Write(u_char *);
  virtual void SetRGain(int);
  virtual void SetPGain(int);
  virtual void OutputPort(int);
  virtual void InputPort(int);
  virtual void Obtain();
  virtual void Release();
  int command(int argc, const char*const* argv);
protected:
  void WriteHelper(u_char *);
  int droppedPackets;
  int interval;
  int intervalPos;
  
  RealWindow* encoder;
  int bufferSize;
  u_char* dummyReadBuf;
  u_short* WriteBuf0;
  u_short* WriteBuf1;
  ULONG32 TimeCode;
  int currentBuf;
  int bufferPosition;
  int timerFlag;
  int secondReadFlag;
};

static class RealAudioEncClass : public TclClass {
public:
        RealAudioEncClass() : TclClass("Audio/RealAudioVirtualDevice") {}
        TclObject* create(int, const char*const*) {
	    return (new RealAudioEnc);
        }
} real_audio_enc_class;

int RealAudioEnc::command(int argc, const char*const* argv) {
  int howOften = 1000; // in milliseconds
  int temp;

  if (argc == 2) {
    Tcl& tcl = Tcl::instance();
    if (strcmp(argv[1], "start_output") == 0) {
      tcl.evalf("after %d %s start_output", howOften, name());
      temp = ((50*howOften)/1000); // this is the number of blocks per interval.

      if (droppedPackets <= 0)
	interval = temp*2; // big so that it doesn't inject a blank when not needed.
      else if (droppedPackets > 16) {
	while (droppedPackets > 5) {
	  Write(dummyReadBuf);
	  secondReadFlag = 0;
	  //	  printf("blank audio here\n");
	}
	interval = temp/droppedPackets;
      } else
	interval = temp/droppedPackets;

      intervalPos = 0;
      droppedPackets = droppedPackets + temp;
      return (TCL_OK);
    } else if (strcmp(argv[1], "grab_audio") == 0) {
      tcl.evalf("after %d %s grab_audio", 10, name());
      timerFlag = 1;
      return (TCL_OK);
    } else if (strcmp(argv[1], "stop_output") == 0) {
      encoder = 0;
      return (TCL_OK);
    }
  } 
  if (argc == 3) {
    if (strcmp(argv[1], "linkEncoder") == 0) {
      encoder = (RealWindow*)TclObject::lookup(argv[2]);
      return (TCL_OK);
    }
  }
  return Audio::command(argc,argv);
}

RealAudioEnc::RealAudioEnc() : droppedPackets(0), interval(100), intervalPos(0), encoder(0), bufferSize(0), TimeCode(0), currentBuf(0), bufferPosition(0), timerFlag(0), secondReadFlag(0) {
    /*
     * The only way to determine if the device is full duplex
     * or not is by actually opening it.  Unfortunately, we might
     * not be able to open it because some other process is
     * using it.  Assume half-duplex.  Obtain() will override
     * if appropriate.
     */
  duplex_ = 0;

  dummyReadBuf = new u_char[blksize_];

  memset(dummyReadBuf, ULAW_ZERO, blksize_);

  input_names_ = "mike";
  output_names_ = "speaker";
}

RealAudioEnc::~RealAudioEnc() {
  Tcl& tcl = Tcl::instance();
  tcl.evalf("after cancel %s start_output", name());  
  delete dummyReadBuf;
}

void RealAudioEnc::Obtain() {
  //  printf("Obtain is called\n");
      
  Tcl& tcl = Tcl::instance();
  tcl.evalf("after %d %s start_output", 100, name());
  
  if (haveaudio())
    abort();

  if (duplex_ == 0) {
    fd_ = 9;
    notify();
  } else {
    // this is a hack, this should never happen. 
    fd_ = open("/dev/audio", O_RDWR );    
    Audio::Obtain();
    tcl.evalf("after %d %s grab_audio", 1000, name());
  }
}


void RealAudioEnc::Release() {
  //  printf("called release\n");
  if (haveaudio()) {
      notify();
  }
}

// write data to the encoder (encode data and send to server)
void RealAudioEnc::Write(u_char *cp) {
  //printf("got a packet to the virtual device, num is: %d!\n", (int)cp[0]);
  u_char cp2[blksize_];
  u_int i, j;
  
  if (secondReadFlag)
    return;
  else
    secondReadFlag = 1;
  
  if (encoder == 0)
    return;

  if (bufferSize == 0) {
    // this only happens at the start, to initialize the encoder.
    bufferSize = encoder->SuggestAudioBufferSize();
    bufferSize = (bufferSize - (bufferSize % (blksize_*2)))/2;
    if (bufferSize == 0) {
      encoder->setup_encoder();
      return;
    }
    WriteBuf0 = new u_short[bufferSize];
    WriteBuf1 = new u_short[bufferSize];
  }

  if (intervalPos >= interval) {
    // we need to elongate samples to fill in for lost data...
    // shouldn't happen often.
    //    printf("making up, interval is: %d, position is: %d\n", interval, intervalPos);
    intervalPos = 0;
    j = blksize_/2;
    for (i=0; i< j; i++) {
      cp2[(2*i)] = cp[i];
      cp2[(2*i)+1] = cp[i];
    }      
    for (i=0; j< blksize_; j++,i+=2) {
      cp[i] = cp[j];
      cp[i+1] = cp[j];
    }
    WriteHelper(cp2);
  }
  WriteHelper(cp);
  intervalPos++;
}

// this is the function that actually writes the data to the Real engine.
void RealAudioEnc::WriteHelper(u_char* cp){
  u_short* writeBuf;
  
  droppedPackets--;

  if (currentBuf == 0)
    writeBuf = WriteBuf0;
  else
    writeBuf = WriteBuf1;

  if (bufferPosition == 0)
    TimeCode = GetTime();
  
  for (u_int i=0; i< blksize_; i++)
    writeBuf[i+bufferPosition] = mulawtolin[cp[i]] ;

  bufferPosition += blksize_;

  if (bufferPosition == bufferSize) {
    currentBuf = (currentBuf+1)%2;
    bufferPosition = 0;
    encoder->encodeAudio(writeBuf, (2*bufferSize), TimeCode);
  }
}

u_char* RealAudioEnc::Read() {
  //  printf("Read was called\n");
  secondReadFlag = 0;
  return dummyReadBuf;
}

void RealAudioEnc::SetRGain(int level)
{    
  //  printf("setRgain() called\n");
}

void RealAudioEnc::SetPGain(int level)
{
  //  printf("SetPgain() called\n");
}

void RealAudioEnc::OutputPort(int p)
{
  
  printf("outputPort() called\n");
  oport_ = p;
}

void RealAudioEnc::InputPort(int p)
{
  printf("inputPort() called for %d\n",p);
}

/*
 * FrameReady must return 0 every so often, or the system will keep
 * processing mike data and not other events.
 *
 * This should never get called because we are not going in duplex mode.
 */
int RealAudioEnc::FrameReady() {
  printf("in FrameReady\n");
  if (timerFlag == 1) {
    timerFlag = 0;
    return 1;
  }
  return 0;
}

/*** end of file ***/



