# range.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc makegraph {filename begin end} {

    if {$filename == "stdin"} {
	set fd "stdin"
    } else {
	if [catch {open $filename r} fd] {
	    puts stdout "Cannot open file $filename"
	    return 0
	}
    }

    while {[gets $fd line] >= 0} {
	set sLine [split $line " "]
	set index [lindex $sLine 0]

	set gt 1
	set lt 1
	if {$begin != "all"} {
	    if {$index < $begin} {
		set gt 0
	    }
	}
	if {$end != "all"} {
	    if {$index > $end} {
		set gt 0
	    }
	}
	if {$gt && $lt} {
	    puts stdout $line
	}
    }
    close $fd

    return 1
}

# main program

if {[llength $argv] != 3} {
    puts stdout "usage: range <filename> <begin> <end>"
    exit
}
set filename [lindex $argv 0]
set begin [lindex $argv 1]
set end [lindex $argv 2]

makegraph $filename $begin $end

